package de.lunqual.rzpro.fenster.rzDatePicker;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.components.DatePickerSettings;
import com.github.lgooddatepicker.optionalusertools.DateChangeListener;
import com.github.lgooddatepicker.zinternaltools.DateChangeEvent;

import de.lunqual.rzpro.RzPro;

public class RzOnlyDatePicker extends JPanel{

	
	private static final int				BUTTON_UP 			= 1;
	private static final int				BUTTON_DOWN 		= 2;
	private static final int				BUTTON_WEEK_UP 		= 3;
	private static final int				BUTTON_WEEK_DOWN 	= 4;
	RzPro 										rz;
	JPanel										centerPanel;
	JPanel										buttonPanel;

	ImageIcon								icon;
	 List<pickerDateListener> 	listeners;
	 List<pickerCalendarListener> 	clisteners; 
	boolean									atDayEnd = false;
	DatePicker								picker;
	 	
	public RzOnlyDatePicker(RzPro rz) {
		this.rz = rz;
		initComponent();
		picker.setDate(LocalDate.now());
	}

	public RzOnlyDatePicker(RzPro rz,boolean atDayEnd) {
		super();
		this.rz = rz;
		this.atDayEnd = atDayEnd;
		initComponent();
		setStartDate(Calendar.getInstance());
	}
	
	public RzOnlyDatePicker(RzPro rz,Date datum) {
		super();
		this.rz = rz;
		initComponent();
		setStartDate(datum);
	}
	
	public RzOnlyDatePicker(RzPro rz,Calendar datum) {
		super();
		this.rz = rz;
		initComponent();
		datum.set(Calendar.HOUR, 0);
		datum.set(Calendar.MINUTE ,0);
		datum.set(Calendar.SECOND, 0);
		setStartDate(datum.getTime());
	}

	public RzOnlyDatePicker(RzPro rz,Date datum,boolean atDayEnd) {
		super();
		this.rz = rz;
		this.atDayEnd = atDayEnd;
		initComponent();
		setStartDate(datum);
	}

	public Date getDate() {
		return getSelectedDate();
	}
	
	public Calendar getCalendar(){
		Calendar c = Calendar.getInstance();
			LocalDateTime time = picker.getDate().atStartOfDay();
			c.clear();
			c.set(Calendar.YEAR, time.getYear());
			c.set(Calendar.MONTH, time.getMonthValue()-1);
			c.set(Calendar.DAY_OF_MONTH,time.getDayOfMonth());
			c.set(Calendar.HOUR, time.getHour());
			c.set(Calendar.MINUTE, time.getMinute());
			c.set(Calendar.SECOND, time.getSecond());
		return c;
	}
	
	public void setStartDate(Date datum) {
		if(datum == null) {
			picker.setDate(LocalDate.now());
		} else {
			picker.setDate(date2local(datum));
		}
	}
	
	public void setStartDate(Calendar datum) {
		if(datum == null) {
			LocalDate d = rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(LocalDate.now(),0);
			picker.setDate(d);
		} else {
			picker.setDate(Calendar2local(datum));
		}
	}
	
	
	
	private void initComponent() {
		listeners = new ArrayList<pickerDateListener>();
		clisteners = new ArrayList<pickerCalendarListener>();
		this.setLayout(new BorderLayout());
		this.setBorder(BorderFactory.createEtchedBorder());
		centerPanel = new JPanel(new BorderLayout());
		/*
		 * Date Picker
		 */
		icon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/rzdatepicker_icon.png"));
		
		 DatePickerSettings s = new DatePickerSettings();
	        	s.setFormatForDatesCommonEra(rz.getOptionFactory().getOption("rzsimpledatepicker.format"));
	        	s.setWeekNumbersDisplayed(true, true);
		picker = new DatePicker(s);	
        	JButton datePickerButton = picker.getComponentToggleCalendarButton();
        	datePickerButton.setText("");
        	datePickerButton.setIcon(icon);
        	picker.addDateChangeListener(new DateChangeListener() {

			@Override
				public void dateChanged(DateChangeEvent event) {
					dateNew( );
			}});
		/*
		 * Panels
		 */
		centerPanel.add(picker,BorderLayout.CENTER);
		buttonPanel = new JPanel(new GridLayout(1,4));
		
		centerPanel.add(buttonPanel,BorderLayout.WEST);
		this.add(centerPanel,BorderLayout.CENTER);
	}
	
	
	
	
	private void dateButton(int direction) {
		switch (direction) {
			case BUTTON_UP:
				picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goForward(picker.getDate(), 1));
				break;
			case BUTTON_DOWN:
				picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goBack(picker.getDate(), 1));
				break;
			case BUTTON_WEEK_DOWN:
				picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goBackWeeks(picker.getDate(), 1));
				break;
			case BUTTON_WEEK_UP:
				picker.setDate(rz.getDatabase().getAuftrag().getAuftragsConfig().goForwardWeeks(picker.getDate(), 1));
				break;
		}
	}
	
	private void dateNew() {
        for (pickerDateListener hl : listeners) {
        		hl.dateChanged(getSelectedDate());
        }
        for (pickerCalendarListener hl :clisteners) {
    		hl.calendarChanged(getSelectedCalendar());
        }	
	}
	
	
	private LocalDate date2local(Date datum) {
		return  datum.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
	}
	
	
	private Calendar getSelectedCalendar(){
		Calendar c = Calendar.getInstance();
		try {
			LocalDateTime time = picker.getDate().atStartOfDay();
			c.clear();
			c.set(Calendar.YEAR, time.getYear());
			c.set(Calendar.MONTH, time.getMonthValue()-1);
			c.set(Calendar.DAY_OF_MONTH,time.getDayOfMonth());
			c.set(Calendar.HOUR, time.getHour());
			c.set(Calendar.MINUTE, time.getMinute());
			c.set(Calendar.SECOND, time.getSecond());
		}catch(NullPointerException n) {
			
		}
		return c;
	}
	
	private LocalDate Calendar2local(Calendar datum) {
		return  datum.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
	}
	
	private Date getSelectedDate(){
		LocalDateTime time = atDayEnd?picker.getDate().atTime(23,59,59):picker.getDate().atStartOfDay();
		return  Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
	}
	
	 public void addListener(pickerDateListener toAdd) {
	        listeners.add(toAdd);
	    }

	 public void addListener(pickerCalendarListener toAdd) {
	        clisteners.add(toAdd);
	    }
}




