/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.fenster.splash;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;


/**
 * @author lunqual
 *
 */
public class SplashFenster extends JFrame{

	private final JPanel bildPanel;
	private final JLabel lblBild;
	private final JProgressBar progress;

	public SplashFenster() {
        this.setUndecorated(true);
		bildPanel = new JPanel(new BorderLayout());
			lblBild = new JLabel();
			try {
				lblBild.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/splash2021.png")));
			} catch (final Exception e) {
				// Splash nicht gefunden.... soll uns aber nicht weiter stören
			}
		bildPanel.add(lblBild,BorderLayout.CENTER);
			progress = new JProgressBar();
				bildPanel.add(progress,BorderLayout.SOUTH);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(bildPanel,BorderLayout.CENTER);
		pack();
        final Toolkit tk = Toolkit.getDefaultToolkit();
        final Dimension screen=tk.getScreenSize();
        this.setBounds((screen.width/2) - (this.getWidth()/2),(screen.height/2) - (this.getHeight()/2),this.getWidth(),this.getHeight());
		setVisible(true);
		toFront();
	}

	public void setStatus(int percent) {
		progress.setValue(percent);
	}
}
