/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.tafelfenster;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.tafel.TafelItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class AlkoholTafel extends JRzFrame{

    //GUI-Variablen
    private JToolBar tb1;
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
      private  JPanel contentPanel;
      	private JPanel tbPanel;
      	private JPanel centerPanel;
      		private JPanel topPanel;
      			private JNumberField txtProzentVol;
      			private JLabel lblProzentVol;
      			private JNumberField txtProzentMas;
      			private JLabel lblProzentMas;
      			private JNumberField txtTemp;
      			private JLabel lblTemp;
          	private JPanel center1Panel;
          		private JPanel centerNorthPanel;
	      			private JPanel leftPanel;
	      				private JLabel leftHeadLine;
	      				private JLabel lblTafel2_Label;
	      				private JLabel lblTafel3_Label;
	      				private JLabel lblLitergewicht_Label;
	      				private JLabel lblVolumen_Label;
	      				private JLabel lblTafel6_Label;
	      				private JLabel lblFlammpunkt_Label;
		      		private JPanel rightPanel;
						private JLabel centerHeadLine;
		  				private JLabel lblTafel2;
		  				private JLabel lblTafel3;
		  				private JLabel lblLitergewicht;
		  				private JLabel lblVolumen;
		  				private JLabel lblTafel6;
		  				private JLabel lblFlammpunkt;
		  		private JPanel centerCenterPanel;
		  			private JPanel wertePanel;
		  				private JLabel lblLiter;
		  				private JNumberField txtLiter;
		  				private JLabel lblKg;
		  				private JNumberField txtKg;
		  				private JLabel lblLa;
		  				private JNumberField txtLa;
		  			private JPanel ergebnisPanel;
		  				private JLabel lblErgebnis;
  		private JPanel buttonPanel;
      	    private JButton btHilfe;
      	    private JButton btDrucken;
      	    private JButton btAbbrechen;

    public static final int				NUM_COLUMNS=14;

    public static final int         		ACTION_CLOSE_CODE = 1001;
    public static final String     		ACTION_CLOSE_TEXT = "tafel.action_close";
    public static final int         		ACTION_HILFE_CODE = 1002;
    public static final String     		ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         		ACTION_HIDE_CODE = 1003;
    public static final String    		ACTION_HIDE_TEXT = "action_hide";
    public static final int				ACTION_DRUCKEN_CODE = 1004;
    public static final String			ACTION_DRUCKEN_TEXT = "tafel.action_drucken";

    TafelItem								ti;
    SpinnerModel							spmTemp;

    /** Creates new form AdressenFenster */
    public AlkoholTafel(RzPro r, String name, Object extendedData) {
        super(r,name,extendedData);
        ti = null;
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
    	// Menü
    	mb = new JMenuBar();
    	mnuDatei = new JMenu();
    	mnuExtras = new JMenu();
    	mnuHilfe = new JMenu();
    	mb.add(mnuDatei);
    	mb.add(mnuExtras);
    	mb.add(mnuHilfe);
    	setJMenuBar(mb);
		//Toolbar
		tb1 = new JToolBar();
		tb1.setFloatable(false);
		tb1.setRollover(true);
		//ToolbarPanel
		//contentPanel
		contentPanel = new JPanel(new BorderLayout());
			tbPanel = new JPanel(new BorderLayout());
				tbPanel.add(tb1,BorderLayout.NORTH);
		contentPanel.add(tbPanel,BorderLayout.NORTH);
			centerPanel = new JPanel(new BorderLayout());
				topPanel = new JPanel(new GridLayout(1,6));
					txtProzentVol = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0.0,0,99.9999999);
  					txtProzentVol.setColumns(NUM_COLUMNS);
			        txtProzentVol.addKeyListener(new java.awt.event.KeyAdapter() {
			            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
			            		if(ti != null) {
			            		    ti.setProzentVol(txtProzentVol.getValue());
			            		    ti.rechnen(TafelItem.RECHNEN_PROZENTVOL);
			            		    fromItem();
			            		    txtProzentVol.requestFocus();
			            		}
			            	}
			            }
			        });
					txtProzentVol.addFocusListener(new FocusListener() {
						public void focusGained(FocusEvent evt) {
						}
						public void focusLost(FocusEvent evt) {
							if(ti != null) {
							    ti.setProzentVol(txtProzentVol.getValue());
							    ti.rechnen(TafelItem.RECHNEN_PROZENTVOL);
							    fromItem();
							}
							}
			    		});
					topPanel.add(txtProzentVol);
					lblProzentVol = new JLabel();
					topPanel.add(lblProzentVol);
					txtProzentMas = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),0.0,0,99.9999999);
  					txtProzentMas.setColumns(NUM_COLUMNS);
			        txtProzentMas.addKeyListener(new java.awt.event.KeyAdapter() {
			            @Override
						public void keyReleased(java.awt.event.KeyEvent evt) {
			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
			            		if(ti != null) {
			            		    ti.setProzentMas(txtProzentMas.getValue());
			            		    ti.rechnen(TafelItem.RECHNEN_PROZENTMAS);
			            		    fromItem();
			            		    txtProzentMas.requestFocus();
			            		}
			            	}
			            }
			        });
					txtProzentMas.addFocusListener(new FocusListener() {
						public void focusGained(FocusEvent evt) {
						}
						public void focusLost(FocusEvent evt) {
							if(ti != null) {
							    ti.setProzentMas(txtProzentMas.getValue());
							    ti.rechnen(TafelItem.RECHNEN_PROZENTVOL);
							    fromItem();
							}
							}
			    		});
					topPanel.add(txtProzentMas);
					lblProzentMas = new JLabel();
					topPanel.add(lblProzentMas);
					txtTemp = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_STAERKE),20.0,-30,40);
	    	           spmTemp = new SpinnerNumberModel(20,-30,30,0.1);
						txtTemp.addFocusListener(new FocusListener() {
							public void focusGained(FocusEvent evt) {
							}
							public void focusLost(FocusEvent evt) {
								if(ti != null) {
			            		    ti.setTemp(txtTemp.getValue());
			            		    ti.rechnen(TafelItem.RECHNEN_TEMP);
			            		    fromItem();
								}
								}
				    		});
				       txtTemp.addKeyListener(new java.awt.event.KeyAdapter() {
				            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
				            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
				            		if(ti != null) {
				            		    ti.setTemp(txtTemp.getValue());
				            		    ti.rechnen(TafelItem.RECHNEN_TEMP);
				            		    fromItem();
				            		    txtTemp.requestFocus();
				            		}
				            	}
				            }
				        });
	    	        topPanel.add(txtTemp);
	  				lblTemp = new JLabel();
	  				topPanel.add(lblTemp);
  				centerPanel.add(topPanel,BorderLayout.NORTH);
	  	      		center1Panel = new JPanel(new BorderLayout());
	  	      			centerNorthPanel = new JPanel(new BorderLayout());
	  	      				leftPanel = new JPanel(new GridLayout(7,1));
	  	      					leftHeadLine = new JLabel();
	  	      						leftHeadLine.setHorizontalAlignment(SwingConstants.CENTER);
	  	      					leftPanel.add(leftHeadLine);
	  	      					lblTafel2_Label = new JLabel();
	  	      						lblTafel2_Label.setHorizontalAlignment(SwingConstants.TRAILING);
	  	      					leftPanel.add(lblTafel2_Label);
	  	      					lblTafel3_Label = new JLabel();
	  	      						lblTafel3_Label.setHorizontalAlignment(SwingConstants.TRAILING);
	  	      					leftPanel.add(lblTafel3_Label);
	  	      					lblLitergewicht_Label=new JLabel();
	  	      						lblLitergewicht_Label.setHorizontalAlignment(SwingConstants.TRAILING);
	  	      					leftPanel.add(lblLitergewicht_Label);
	  	      					lblVolumen_Label=new JLabel();
  	      							lblVolumen_Label.setHorizontalAlignment(SwingConstants.TRAILING);
  	      						leftPanel.add(lblVolumen_Label);
	  	      					lblTafel6_Label = new JLabel();
	  	      						lblTafel6_Label.setHorizontalAlignment(SwingConstants.TRAILING);
	  	      					leftPanel.add(lblTafel6_Label);
		       					lblFlammpunkt_Label = new JLabel();
	  	      						lblFlammpunkt_Label.setHorizontalAlignment(SwingConstants.TRAILING);
	  	      					leftPanel.add(lblFlammpunkt_Label);
	      					centerNorthPanel.add(leftPanel,BorderLayout.WEST);

	  	      				rightPanel = new JPanel(new GridLayout(7,1));
  	      					centerHeadLine = new JLabel();
  	      						centerHeadLine.setHorizontalAlignment(SwingConstants.CENTER);
  	      					rightPanel.add(centerHeadLine);
  	      					lblTafel2 = new JLabel();
  	      						lblTafel2.setHorizontalAlignment(SwingConstants.LEADING);
  	      					rightPanel.add(lblTafel2);
  	      					lblTafel3 = new JLabel();
  	      						lblTafel3.setHorizontalAlignment(SwingConstants.LEADING);
  	      					rightPanel.add(lblTafel3);
  	      					lblLitergewicht=new JLabel();
  	      						lblLitergewicht.setHorizontalAlignment(SwingConstants.LEADING);
  	      					rightPanel.add(lblLitergewicht);
  	      					lblVolumen=new JLabel();
	      						lblVolumen.setHorizontalAlignment(SwingConstants.LEADING);
	      					rightPanel.add(lblVolumen);
  	      					lblTafel6 = new JLabel();
  	      						lblTafel6.setHorizontalAlignment(SwingConstants.LEADING);
  	      					rightPanel.add(lblTafel6);
  	      					lblFlammpunkt = new JLabel();
	      						lblFlammpunkt.setHorizontalAlignment(SwingConstants.LEADING);
	      					rightPanel.add(lblFlammpunkt);
      					centerNorthPanel.add(rightPanel,BorderLayout.CENTER);
      					centerNorthPanel.setBorder(BorderFactory.createRaisedBevelBorder());
	      			center1Panel.add(centerNorthPanel,BorderLayout.NORTH);

			      		centerCenterPanel = new JPanel(new BorderLayout());
			  				wertePanel = new JPanel(new GridLayout(1,6));
			  					lblLiter = new JLabel();
			  						lblLiter.setHorizontalAlignment(SwingConstants.TRAILING);
			  					wertePanel.add(lblLiter);
			  					txtLiter = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
			  					txtLiter.setColumns(NUM_COLUMNS);
						        txtLiter.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
						            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
						            		if(ti != null) {
						            		    ti.setLiter(txtLiter.getValue());
						            		    ti.rechnen(TafelItem.RECHNEN_LITER);
						            		    fromItem();
						            		    txtLiter.requestFocus();
						            		}
						            	}
						            }
						        });
								txtLiter.addFocusListener(new FocusListener() {
									public void focusGained(FocusEvent evt) {
									}
									public void focusLost(FocusEvent evt) {
										if(ti != null) {
										    ti.setLiter(txtLiter.getValue());
										    ti.rechnen(TafelItem.RECHNEN_LITER);
										    fromItem();
										}
										}
						    		});
			  					wertePanel.add(txtLiter);
			  					lblKg = new JLabel();
			  						lblKg.setHorizontalAlignment(SwingConstants.TRAILING);
			  					wertePanel.add(lblKg);
			  					txtKg =  new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
			  					txtKg.setColumns(NUM_COLUMNS);
								txtKg.addFocusListener(new FocusListener() {
									public void focusGained(FocusEvent evt) {
									}
									public void focusLost(FocusEvent evt) {
										if(ti != null) {
										    ti.setKg(txtKg.getValue());
										    ti.rechnen(TafelItem.RECHNEN_KG);
										    fromItem();
										}
										}
						    		});
						        txtKg.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
						            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
						            		if(ti != null) {
						            		    ti.setKg(txtKg.getValue());
						            		    ti.rechnen(TafelItem.RECHNEN_KG);
						            		    fromItem();
						            		    txtKg.requestFocus();
						            		}
						            	}
						            }
						        });
			  					wertePanel.add(txtKg);
			  					lblLa = new JLabel();
			  						lblLa.setHorizontalAlignment(SwingConstants.TRAILING);
			  					wertePanel.add(lblLa);
			  					txtLa = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,0,Double.POSITIVE_INFINITY);
			  					txtLa.setColumns(NUM_COLUMNS);
						        txtLa.addKeyListener(new java.awt.event.KeyAdapter() {
						            @Override
									public void keyReleased(java.awt.event.KeyEvent evt) {
						            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
						            		if(ti != null) {
						            		    ti.setLa(txtLa.getValue());
						            		    ti.rechnen(TafelItem.RECHNEN_LA);
						            		    fromItem();
						            		    txtLa.requestFocus();
						            		}
						            	}
						            }
						        });
								txtLa.addFocusListener(new FocusListener() {
									public void focusGained(FocusEvent evt) {
									}
									public void focusLost(FocusEvent evt) {
										if(ti != null) {
										    ti.setLa(txtLa.getValue());
										    ti.rechnen(TafelItem.RECHNEN_LA);
										    fromItem();
										}
										}
						    		});
			  					wertePanel.add(txtLa);
			  				centerCenterPanel.add(wertePanel,BorderLayout.NORTH);
			  					ergebnisPanel = new JPanel(new BorderLayout());
			  						lblErgebnis = new JLabel();
			  							lblErgebnis.setHorizontalAlignment(SwingConstants.CENTER);
			  						ergebnisPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			  						ergebnisPanel.add(lblErgebnis);
			  				centerCenterPanel.add(ergebnisPanel,BorderLayout.SOUTH);
			  				centerCenterPanel.setBorder(BorderFactory.createRaisedBevelBorder());
			  			center1Panel.add(centerCenterPanel,BorderLayout.SOUTH);
		      	centerPanel.add(center1Panel,BorderLayout.CENTER);
		contentPanel.add(centerPanel,BorderLayout.CENTER);
		    // ButtonPanel
			buttonPanel=new JPanel(new GridLayout(1,3));
				btAbbrechen = new JButton();
				buttonPanel.add(btAbbrechen);
				btDrucken = new JButton();
				buttonPanel.add(btDrucken);
				btHilfe = new JButton();
				buttonPanel.add(btHilfe);
		contentPanel.add(buttonPanel,BorderLayout.SOUTH);

		//Panels ans Fenster hängen;
		this.getContentPane().setLayout(new BorderLayout());

		this.getContentPane().add(contentPanel, BorderLayout.CENTER);
    }


    @Override
	public void setGUIComponents() {
        setTitle(rz.getVersionString() + " " + rz.getLocale().getString("tafel.titel"));

		mnuDatei.setText(rz.getLocale().getString("menu.datei"));
		mnuExtras.setText(rz.getLocale().getString("menu.extras"));
		mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));

		mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

		tb1.add(getAction(ACTION_CLOSE_CODE));
		tb1.add(getAction(ACTION_HIDE_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_DRUCKEN_CODE));
		tb1.addSeparator();
		tb1.add(getAction(ACTION_HILFE_CODE));
		tb1.addSeparator();


		btHilfe.setAction(getAction(ACTION_HILFE_CODE));
		btAbbrechen.setAction(getAction(ACTION_CLOSE_CODE));
		btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));

		lblProzentVol.setText(rz.getLocale().getString("string_prozentvol"));
		lblProzentMas.setText(rz.getLocale().getString("string_prozentmas"));
		lblTemp.setText(rz.getLocale().getString("tafel.label_tanktemperatur"));


		lblTafel2_Label.setText(rz.getLocale().getString("tafel.label_tafel2"));
		lblTafel3_Label.setText(rz.getLocale().getString("tafel.label_tafel3"));
		lblTafel6_Label.setText(rz.getLocale().getString("tafel.label_tafel6"));
		lblFlammpunkt.setText(" ");
		lblLiter.setText(rz.getLocale().getString("tafel.label_liter"));
		lblKg.setText(rz.getLocale().getString("tafel.label_kg"));
		lblLa.setText(rz.getLocale().getString("tafel.label_la"));

		lblLitergewicht_Label.setText(rz.getLocale().getString("tafel.label_litergewicht").replaceAll("%s", rz.getDatabase().getEinheiten().dbGetLitergewichtString()));
		lblVolumen_Label.setText(rz.getLocale().getString("tafel.label_volumen").replaceAll("%s", rz.getDatabase().getEinheiten().dbGetVolumenString()));
		leftHeadLine.setText(rz.getLocale().getString("tafel.label_left_headline"));
		centerHeadLine.setText(rz.getLocale().getString("tafel.label_center_headline"));

		setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
		          case ACTION_HILFE_CODE: hilfeAction();break;
		          case ACTION_HIDE_CODE:hideAction();break;
		          case ACTION_CLOSE_CODE:closeWindow();break;
		          case ACTION_DRUCKEN_CODE:druckenAction();break;
		          default :
		              break;
           }
    		break;
         case MessageItem.MSG_SHOW_TAFEL :
            ti = (TafelItem)msg.getData();
	      	break;

        default:
            rz.getLogFactory().logMessage(2, "alkoholtafelfenster", "auswahlAction:" + msg.getMsgCode());
            break;
        }

    }
    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1,0));
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT, KeyEvent.VK_ESCAPE,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE),new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D,InputEvent.CTRL_DOWN_MASK));

    }


    @Override
	public void openWindow(){
        if(ti != null) {
			fromItem();
            setVisible(true);
            toFront();
            txtProzentVol.requestFocus();
        } else {
            closeWindow();
        }
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }


    private void fromItem() {
        txtProzentVol.setValue(ti.getProzentVol());
        txtProzentMas.setValue(ti.getProzentMas());
        txtTemp.setValue(ti.getTemp());
        txtLiter.setValue(ti.getLiter());
        txtKg.setValue(ti.getKg());
        txtLa.setValue(ti.getLa());
        lblTafel2.setText(rz.getLocale().getString("tafel.tafel2").replaceAll("%s", rz.getLocale().formatNumber( ti.getTafel2(),OptionFactory.NF_TAFEL_2)));
        lblTafel3.setText(rz.getLocale().getString("tafel.tafel3").replaceAll("%s", rz.getLocale().formatNumber( ti.getTafel3(),OptionFactory.NF_TAFEL_3)));
        lblTafel6.setText(rz.getLocale().getString("tafel.tafel6").replaceAll("%s", rz.getLocale().formatNumber( ti.getTafel6(),OptionFactory.NF_TAFEL_6)));
        lblFlammpunkt.setText("<html><font color=\"blue\">"+rz.getTafelFactory().getFlammpunkt(ti.getProzentVol())+"</font></html>");
        lblLitergewicht.setText(rz.getLocale().getString("tafel.litergewicht").replaceAll("%s", rz.getLocale().formatNumber( ti.getLitergewicht(),OptionFactory.NF_LITERGEWICHT)));
        lblVolumen.setText(rz.getLocale().getString("tafel.volumen").replaceAll("%s", rz.getLocale().formatNumber( ti.getVolumen(),OptionFactory.NF_LITERGEWICHT)));
        lblErgebnis.setText(rz.getLocale().getString("tafel.label_ergebnis").
                replaceAll("%s",rz.getLocale().formatNumber( ti.getLiter20(),OptionFactory.NF_NORMAL)).
                replaceAll("%k",rz.getLocale().formatNumber( ti.getLa(),OptionFactory.NF_NORMAL))
        );
    }

    private void druckenAction() {
        if(ti != null) {
            rz.getReportFactory().TafelReport(ti,this);
        }
    }

    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"tafel.html",this));
    }




}

