package de.lunqual.rzpro.fenster.tankfenster;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.tank.ortItem;
import de.lunqual.rzpro.options.OptionFactory;

public class ortListenRenderer extends JLabel implements ListCellRenderer<ortItem> {
	 
	RzPro rz;
	Icon select;
	public ortListenRenderer(RzPro rz) {
		super();
		setOpaque(true);
		this.rz = rz;
		select = new  javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/tankliste_plan.png"));
	}

	public Component getListCellRendererComponent(JList<? extends ortItem> list,
			ortItem value, int index, boolean isSelected,
			boolean cellHasFocus) {
			if(value != null){
				setText(value.getBezeichnung());
				if (value.isSelected()) {
					setIcon(select);
				} else {
					setIcon(null);
				}
			} else {
				setText("");
				setIcon(null);
			}
			 if(isSelected){
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_SELECTED));
	                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_SELECTED));
	            }else {
	                setBackground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_BACKGROUND_NORMAL));
	                setForeground(rz.getOptionFactory().getColor(OptionFactory.COLOR_LIST_FOREGROUND_NORMAL));
	            }
			
		return this;
	}
     
}