/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen aber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenständige
 * Verbindungen zur Datenbank auf
 *
 */

package de.lunqual.rzpro.fenster.tracefenster;


import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;


import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.abfrage.AbfrageItem;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.bewertungen.BewertungsItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
import de.lunqual.rzpro.items.trace.TraceItem;
import de.lunqual.rzpro.options.OptionFactory;
/**
 *
 * @author  lunqual
 */
public class TraceFenster extends JRzFrame{

    //GUI-Variablen
    private JMenuBar mb;
    private JMenu mnuDatei;
    private JMenu mnuBearbeiten;
    private JMenu mnuExtras;
    private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel titelPanel;
    			private JLabel lblTitel;
    		private JPanel anzeigePanel;
    			private JScrollPane scrAnzeige;
    				private JEditorPane txtAnzeige;
    	private JPanel buttonPanel;
    		private JButton btClose;
    		private JButton btHide;
    		private JComboBox cmbDruckFormular;
    		private JCheckBox chkDuplex;
    		private JButton btPrint;
    		private JButton btVorschau;
    		private JPanel limitPanel;
    			private JLabel lblLimit1;
    			private JNumberField txtLimit;
    			private JLabel lblLimit2;
    		private JButton btHilfe;


    //ActionCodes Adressenfenster
    public static final int         	ACTION_CLOSE_CODE = 1001;
    public static final String      	ACTION_CLOSE_TEXT = "tracefenster.action_close";
    public static final int         	ACTION_DRUCKEN_CODE = 1002;
    public static final String      	ACTION_DRUCKEN_TEXT = "tracefenster.action_drucken";
    public static final int         	ACTION_HILFE_CODE = 1003;
    public static final String      	ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         	ACTION_HIDE_CODE = 1004;
    public static final String      	ACTION_HIDE_TEXT= "action_hide";
    public static final int         	ACTION_VORSCHAU_CODE = 1005;
    public static final String      	ACTION_VORSCHAU_TEXT = "tracefenster.action_vorschau";
    public static final int         	ACTION_DOKUMENTE_ALLE_CODE = 1006;
    public static final String     		ACTION_DOKUMENTE_ALLE_TEXT = "auswahl.action_dokumente_alle";
  

    JRzFrame				origin;

    TraceItem				trace;
    
    /** Creates new form TraceFenster */
    public TraceFenster(RzPro r,String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
		mb.add(mnuDatei);
		mnuBearbeiten = new JMenu();
		mb.add(mnuBearbeiten);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
		toolbarPanel = new JPanel(new BorderLayout());
			tb1 = new JToolBar();
			tb1.setFloatable(false);
			tb1.setRollover(true);
			toolbarPanel.add(tb1);
			contentPanel = new JPanel(new BorderLayout());
				titelPanel = new JPanel(new BorderLayout());
					lblTitel = new JLabel();
					lblTitel.setHorizontalAlignment(SwingConstants.CENTER);
					titelPanel.setBorder(BorderFactory.createEtchedBorder());
					titelPanel.add(lblTitel);
				contentPanel.add(titelPanel,BorderLayout.NORTH);
				anzeigePanel = new JPanel(new BorderLayout());
					anzeigePanel.setBorder(BorderFactory.createEtchedBorder());
					scrAnzeige = new JScrollPane();
						txtAnzeige = new JEditorPane();
						 txtAnzeige.addHyperlinkListener(new javax.swing.event.HyperlinkListener() {
					            public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent evt) {
					                if(evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED){
						                	linkAction(evt);
					                	}
						            }
						        });
							txtAnzeige.setContentType("text/html");
							txtAnzeige.setEditable(false);
						scrAnzeige.setViewportView(txtAnzeige);
					anzeigePanel.add(scrAnzeige,BorderLayout.CENTER);
				contentPanel.add(anzeigePanel,BorderLayout.CENTER);
				buttonPanel = new JPanel(new GridLayout(1,7));
					btClose = new JButton();
					buttonPanel.add(btClose);
					btHide = new JButton();
					buttonPanel.add(btHide);
					cmbDruckFormular = new JComboBox();
					rz.getDatabase().getReport().dbGetReportListeCombo(cmbDruckFormular,ReportFactory.REPORT_TYPE_TRACE);
					cmbDruckFormular.addActionListener(new ActionListener() {
	    	        		public void actionPerformed(ActionEvent evt) {
	    	        			if(cmbDruckFormular.getSelectedIndex() != -1) {
	    	        				rz.getOptionFactory().setOption("report.trace",((ReportItem)cmbDruckFormular.getSelectedItem()).getID());
	    	        			}
	    	        		}
	                });
					buttonPanel.add(cmbDruckFormular);
					chkDuplex= new JCheckBox();
					chkDuplex.setSelected((rz.getOptionFactory().getOption("trace.duplex",0) == 1?true:false));
					chkDuplex.addActionListener(new ActionListener() {
			        	public void actionPerformed(ActionEvent evt) {
			        		rz.getOptionFactory().setOption("trace.duplex", chkDuplex.isSelected()?1:0);
			        		rz.getOptionFactory().saveOptions();
			        	}
		    	    });
					buttonPanel.add(chkDuplex);
					btPrint = new JButton();
					buttonPanel.add(btPrint);
					btVorschau = new JButton();
					buttonPanel.add(btVorschau);
					limitPanel = new JPanel(new BorderLayout());
						lblLimit1=new JLabel();
						limitPanel.add(lblLimit1,BorderLayout.WEST);
						txtLimit = new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),2.0,0,100);
						txtLimit.setValue(rz.getOptionFactory().getDouble("tracefenster.limit", 2.0));
						txtLimit.addKeyListener(new java.awt.event.KeyAdapter() {
	 			            @Override
							public void keyReleased(java.awt.event.KeyEvent evt) {
	 			            	if(evt.getKeyCode() == KeyEvent.VK_ENTER) {
	 			            		rz.getOptionFactory().setDouble("tracefenster.limit", txtLimit.getValue());
	 			            		rz.getOptionFactory().saveOptions();
	 			            		if(trace != null) {
	 			            			trace.reload();
	 			            			rz.getAusgabeFactory().TraceAusgabe(txtAnzeige, trace);
	 			            		}
	 			            	}
	 			            }
	 			        });
						limitPanel.add(txtLimit,BorderLayout.CENTER);
						lblLimit2 = new JLabel();
						limitPanel.add(lblLimit2,BorderLayout.EAST);
					buttonPanel.add(limitPanel);
					btHilfe = new JButton();
					buttonPanel.add(btHilfe,BorderLayout.EAST);
				mainPanel.add(contentPanel,BorderLayout.CENTER);
				getContentPane().setLayout(new BorderLayout());
				getContentPane().add(toolbarPanel,BorderLayout.NORTH);
				getContentPane().add(mainPanel,BorderLayout.CENTER);
				getContentPane().add(buttonPanel,BorderLayout.SOUTH);
    }

    @Override
	public void setGUIComponents() {
      setTitle(rz.getVersionString() + " " + rz.getLocale().getString("tracefenster.titel"));
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE);

      mnuDatei.setText(rz.getLocale().getString("menu.datei"));
      mnuExtras.setText(rz.getLocale().getString("menu.extras"));
      mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
      mnuBearbeiten.setText(rz.getLocale().getString("menu.bearbeiten"));

      mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
      mnuDatei.add(getAction(ACTION_VORSCHAU_CODE));
      mnuDatei.addSeparator();
      mnuDatei.add(getAction(ACTION_CLOSE_CODE));

      mnuBearbeiten.add(getAction(ACTION_DOKUMENTE_ALLE_CODE));
      
      mnuExtras.add(getAction(ACTION_HIDE_CODE));

      mnuHilfe.add(getAction(ACTION_HILFE_CODE));
      
      btHilfe.setAction(getAction(ACTION_HILFE_CODE));
      btClose.setAction(getAction(ACTION_CLOSE_CODE));
      btHide.setAction(getAction(ACTION_HIDE_CODE));
      btPrint.setAction(getAction(ACTION_DRUCKEN_CODE));
      btVorschau.setAction(getAction(ACTION_VORSCHAU_CODE));
      tb1.add(getAction(ACTION_CLOSE_CODE));
      tb1.add(getAction(ACTION_HIDE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DRUCKEN_CODE));
      tb1.add(getAction(ACTION_VORSCHAU_CODE));      
      tb1.addSeparator();
      tb1.add(getAction(ACTION_DOKUMENTE_ALLE_CODE));
      tb1.addSeparator();
      tb1.add(getAction(ACTION_HILFE_CODE));

      lblLimit1.setText(rz.getLocale().getString("tracefenster.label_limit_1"));
      lblLimit2.setText(rz.getLocale().getString("tracefenster.label_limit_2"));
      chkDuplex.setText(rz.getLocale().getString("trace.duplex"));  
      
      setResizable(true);
      rz.getFontFactory().setFrameFonts(this);
      pack();
      rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }

    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
        		case MessageItem.MSG_ACTIONPERFORMED:
                switch(msg.getCode()){
                case ACTION_CLOSE_CODE:closeWindow();break;
                case ACTION_DRUCKEN_CODE:druckAction(false);break;
                case ACTION_VORSCHAU_CODE:druckAction(true);break;
                case ACTION_HILFE_CODE: hilfeAction();break;
                case ACTION_HIDE_CODE:hideAction();break;
                case ACTION_DOKUMENTE_ALLE_CODE:dokumenteAction();break;
                default :
                    break;
               }
        		break;
        		case MessageItem.MSG_SHOW_TRACE :
        			origin = msg.getOrigin();
        			trace = (TraceItem)msg.getData();
               
             break;
        		default:
        			rz.getLogFactory().logMessage(2, "adressenfenster:", "auswahlAction:" + msg.getMsgCode());
                break;
        }
    }
    
    private void dokumenteAction() {
    	if(trace!=null) {
    		String liste = rz.getDatabase().getRezeptur().getAlleRezepturen(trace.getRezeptur());
			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE_ALLE,trace.getRezeptur(),(Object)liste,this));	
    	}
    }
     @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_CLOSE_CODE),new AuswahlAction(rz,this,ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE ,0));
        actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_DRUCKEN_TEXT, KeyEvent.VK_D ,InputEvent.CTRL_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_VORSCHAU_CODE), new AuswahlAction(rz,this,ACTION_VORSCHAU_CODE,ACTION_VORSCHAU_TEXT, 0,0));
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
        actionList.put(String.valueOf(ACTION_DOKUMENTE_ALLE_CODE),new AuswahlAction(rz,this,ACTION_DOKUMENTE_ALLE_CODE,ACTION_DOKUMENTE_ALLE_TEXT, 0,0));
     }

     private void linkAction(HyperlinkEvent evt) {
		 final Document d = txtAnzeige.getDocument();
		 final HTMLDocument hd = (HTMLDocument)d;
		 final int pos = txtAnzeige.viewToModel( txtAnzeige.getMousePosition() );
		 if ( pos >= 0 ) {
		 	final Element e = hd.getCharacterElement(pos);
		 	if (e != null) {
		 		final SimpleAttributeSet se = (SimpleAttributeSet)e.getAttributes().getAttribute(HTML.Tag.A);
		 		if(se != null) {
		 			final String ziel = se.getAttribute(HTML.Attribute.HREF).toString();
		 			if(ziel.indexOf("LO:")!= -1) {
		 				rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY,0,"^" +ziel.substring(3)+ "$",this));
		 			} else if(ziel.indexOf("RZ")!=-1) {
		 				AbfrageItem abfrage = new AbfrageItem();
		 				abfrage.setMuster(rz.getDatabase().getErgebnis().getMusterString(ziel.substring(3)));
		 				abfrage.setMode(DBAbfrage.ABFRAGE_MODE_MUSTER);
		 				abfrage.setTyp(DBAbfrage.ABFRAGE_TYP_NORMAL);
		 				abfrage.setAdressListe(new StichwortListe());
		 				abfrage.setStichwortListe(new StichwortListe());
		 				try {
		 					rz.getFensterFactory().getFensterListe().getAuswahl().getMessage(new MessageItem(MessageItem.MSG_ADD_QUERY_REZEPT, 0, abfrage,this));
		 					rz.getFensterFactory().getFensterListe().getAuswahl().toFront();
		 				}catch (Exception e1) {}	
		 			} else if (ziel.indexOf("AD")!= -1) {
		 				 rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ADRESSEN,true,new MessageItem(MessageItem.MSG_SHOW_ADRESSE,0,ziel.substring(3),this));
		 			} else if (ziel.indexOf("MI") != -1) {
		 				int mischung = Integer.valueOf(ziel.substring(3));
		 				if(mischung != 0) {
		 			       rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,true,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_MISCHUNG,mischung,null,this));
		 				}
		 			} else if(ziel.indexOf("TI") != -1) {
		 				String ticket = ziel.substring(3);
		 				if(!ticket.equals("")) {
		 					rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNGSLISTE,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNGSFENSTER_TICKETS,0,ticket,this));
		 				}
		 			} else if (ziel.indexOf("BW") != -1) {
		 				BewertungsItem bwi = null;
	 					int n = Integer.valueOf(ziel.substring(3));
	 					if(n != 0) {
	 						bwi = rz.getDatabase().getBewertungen().getBewertung(n);		 						
	 					} 
	 					if(bwi != null) {
	 			    			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_BEWERTUNGEN_EINGABE,false,new MessageItem(MessageItem.MSG_SHOW_BEWERTUNGSEINGABE,0,bwi,this));
	 					} 
		 			} else if(ziel.indexOf("BI") != -1) {
		 				String nummer = ziel.substring(3);
		 				if(!nummer.equals("")) {
		 					try {
		 						int nr = Integer.parseInt(nummer);
		 						if(nr != 0) {
		 							rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_VERLAUF,false,new MessageItem(MessageItem.MSG_SHOW_HISTORY_BUCHUNGSNUMMER,0,nummer,this));
		 						}
		 					}catch (Exception e2) {}
		 				}
		 			} else if(ziel.indexOf("CH") != -1) {
		 				String nummer = ziel.substring(3);
		 				if(!nummer.equals("")) {
		 					try {
		 						int nr = Integer.parseInt(nummer);
		 						if(nr != 0) {
		 							MischungsItem mi = rz.getDatabase().getMischungen().getMischung(nr);
		 							if(mi != null) {
		 								rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_MISCHUNG_CHART,false,new MessageItem(MessageItem.MSG_SHOW_MISCHUNG_CHART,0,mi,this));
		 							}
		 						}
		 					}catch (Exception e2) {}
		 				}
		 			}else if(ziel.indexOf("doc:") != -1) {
		 				int n = Integer.parseInt(ziel.substring(4));
                		if(n > 0) {
                			rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_DOCUMENT_LISTE,false,new MessageItem(MessageItem.MSG_SHOW_DOKUMENT_LISTE,0,Integer.valueOf(n),this));
                		}
		 			}
 		 		}
		 	}
		 }
     }
     
    @Override
	public void openWindow(){
    		if(trace != null) {
    			if(!isVisible()) {
    				setVisible(true);
    			}
    			setTitle(trace.getTitel());
    			lblTitel.setText("<html><h1><b>" + trace.getLabelTitel()+ "</b></h1></html>");
    			rz.getAusgabeFactory().TraceAusgabe(txtAnzeige, trace);
    			toFront();
    			requestFocus();
      }
    }

    @Override
	public void closeWindow(){
        rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }

    private void druckAction(boolean vorschau){
    		rz.getReportFactory().TraceDrucken(trace, vorschau, this,chkDuplex.isSelected());
    }

   
    //Extras-Menü
    private void hideAction(){
        rz.getFensterFactory().getFensterListe().sperren(this);
    }

    //hilfe-menü
    private void hilfeAction(){
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"trace.html",this));
    }


}
