/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.zutatenverzeichnis;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.ReportFactory;
import de.lunqual.rzpro.database.DBMessages;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.report.ReportItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisListe;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  administrator
 */
public class Zutatenverzeichnis extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel topPanel;
    			private JLabel lblTop;
    			private JCheckBox chkZahlen;
    		private JSplitPane splText;
	    		private JPanel textPanel;
	    			private JPanel titelPanel;
	    				private JLabel lblTitel;
	    				private JSelectedTextField txtTitel;
	    			private JScrollPane scrText;
	    				private JTextPane txtText;
	    		private JPanel commentPanel;
	    			private JCheckBox chkComment;
	    			private JScrollPane scrComment;
	    				private JTextPane txtComment;
	    			private JButton btSaveComment;
		private JPanel buttonPanel;
			private JButton btClose;
			private JButton btReply;
    		private JComboBox cmbFormulare;
    		private JButton btDrucken;
    		private JButton btPDF;
    		private JButton btHilfe;


    // ActionCodes KalkulationEingabe
    public static final int         ACTION_DRUCKEN_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "zutatenverzeichnis.action_drucken";
    public static final int         ACTION_CLOSE_CODE = 1001;
    public static final String      ACTION_CLOSE_TEXT = "zutatenverzeichnis.action_close";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_SAVE_COMMENT_CODE = 1004;
    public static final String      ACTION_SAVE_COMMENT_TEXT = "zutatenverzeichnis.action_save_comment";
    public static final int         ACTION_SAVE_PDF_CODE = 1005;
    public static final String      ACTION_SAVE_PDF_TEXT = "zutatenverzeichnis.action_save_pdf";
    public static final int         ACTION_REPLY_CODE = 1006;
    public static final String      ACTION_REPLY_TEXT = "zutatenverzeichnis.action_reply";
    public static final int         ACTION_CONTENT_CODE = 1007;
    public static final String      ACTION_CONTENT_TEXT = "zutatenverzeichnis.action_content";

    ZutatenverzeichnisListe zl;
    JRzFrame			origin;
    boolean			rezepturReply = false;

    /** Creates new form AdressAuswahl */

    public Zutatenverzeichnis(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());

				topPanel=new JPanel(new BorderLayout());
					 lblTop=new JLabel();
					 	lblTop.setHorizontalAlignment(SwingConstants.CENTER);
					 topPanel.add(lblTop,BorderLayout.NORTH);
					 chkZahlen=new JCheckBox();
					  chkZahlen.addActionListener(new ActionListener() {
	        	        	public void actionPerformed(ActionEvent evt) {
	        	        	   	refreshAction();
	        	        	}
		        	    });
					 topPanel.add(chkZahlen,BorderLayout.SOUTH);
					 topPanel.setBorder(BorderFactory.createEtchedBorder());
				contentPanel.add(topPanel,BorderLayout.NORTH);

					splText = new JSplitPane();
						splText.setDividerSize(6);
					 	splText.setOrientation(JSplitPane.VERTICAL_SPLIT);
						textPanel=new JPanel(new BorderLayout());
							titelPanel=new JPanel(new BorderLayout());
								lblTitel=new JLabel();
									lblTitel.setHorizontalAlignment(SwingConstants.RIGHT);
								titelPanel.add(lblTitel,BorderLayout.WEST);
								txtTitel=new JSelectedTextField();
								titelPanel.add(txtTitel,BorderLayout.CENTER);
							textPanel.add(titelPanel,BorderLayout.NORTH);
							scrText=new JScrollPane();
								txtText=new JTextPane();
							scrText.setViewportView(txtText);
							textPanel.add(scrText,BorderLayout.CENTER);
							 textPanel.setBorder(BorderFactory.createEtchedBorder());
					 splText.setTopComponent(textPanel);
						commentPanel= new JPanel(new BorderLayout());
							chkComment=new JCheckBox();
								chkComment.setHorizontalAlignment(SwingConstants.CENTER);
							commentPanel.add(chkComment,BorderLayout.NORTH);
							scrComment= new JScrollPane();
								txtComment= new JTextPane();
							scrComment.setViewportView(txtComment);
						commentPanel.add(scrComment,BorderLayout.CENTER);
						btSaveComment = new JButton();
						commentPanel.add(btSaveComment,BorderLayout.SOUTH);
						commentPanel.setBorder(BorderFactory.createEtchedBorder());
					splText.setBottomComponent(commentPanel);

				contentPanel.add(splText,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,6));
		    	btClose = new JButton();
	    			buttonPanel.add(btClose);
	    		btReply=new JButton();
    				buttonPanel.add(btReply);
	    		cmbFormulare = new JComboBox();
			    	rz.getDatabase().getReport().dbGetReportListeCombo(cmbFormulare,ReportFactory.REPORT_TYPE_ZUTATENVERZEICHNIS);
	        	    cmbFormulare.addActionListener(new ActionListener() {
	    	        	public void actionPerformed(ActionEvent evt) {
	    	        		if(cmbFormulare.getSelectedIndex() != -1) {
	    	        			rz.getOptionFactory().setOption("report.zutatenverzeichnis",((ReportItem)cmbFormulare.getSelectedItem()).getID());
	    	        		}
	    	        	}
	                });
	    			buttonPanel.add(cmbFormulare);
    			btDrucken=new JButton();
    				buttonPanel.add(btDrucken);
    			btPDF=new JButton();
    				buttonPanel.add(btPDF);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("zutatenverzeichnis.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_DRUCKEN_CODE));
  	  	mnuDatei.add(getAction(ACTION_SAVE_PDF_CODE));
  	  	mnuDatei.addSeparator();
  	  	mnuDatei.add(getAction(ACTION_SAVE_COMMENT_CODE));
  	  	mnuDatei.add(getAction(ACTION_CONTENT_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_CLOSE_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_CLOSE_CODE));
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_DRUCKEN_CODE));
  	  	tb1.add(getAction(ACTION_SAVE_PDF_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_SAVE_COMMENT_CODE));
  	  	tb1.add(getAction(ACTION_CONTENT_CODE));
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btDrucken.setAction(getAction(ACTION_DRUCKEN_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btClose.setAction(getAction(ACTION_CLOSE_CODE));
  	  	btPDF.setAction(getAction(ACTION_SAVE_PDF_CODE));
  	  	btReply.setAction(getAction(ACTION_REPLY_CODE));
  	  	getAction(ACTION_REPLY_CODE).setEnabled(false);
  	  	
        lblTop.setText(rz.getLocale().getString("zutatenverzeichnis.label_titel"));
        lblTitel.setText(rz.getLocale().getString("zutatenverzeichnis.label_titel_text"));
        chkZahlen.setText(rz.getLocale().getString("zutatenverzeichnis.check_zahlen"));

        chkComment.setText(rz.getLocale().getString("zutatenverzeichnis.label_disclaimer"));
  	  	btSaveComment.setAction(getAction(ACTION_SAVE_COMMENT_CODE));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
        setDividerLocations();
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_CLOSE_CODE :cancelAction();break;
			case ACTION_DRUCKEN_CODE :printAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_SAVE_COMMENT_CODE:saveCommentAction();break;
            case ACTION_SAVE_PDF_CODE:savePDFAction();break;
            case ACTION_REPLY_CODE:replyAction();break;
            case ACTION_CONTENT_CODE:contentAction();break;
            default :
                break;
           }
    		break;

         case MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_REZEPTUR:
        	 rezepturReply = true;
        	 getAction(ACTION_REPLY_CODE).setEnabled(true);
         case MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS:
        	 origin = msg.getOrigin();
 			 if (msg.getData() != null) {
 				 zl = (ZutatenverzeichnisListe)msg.getData();
 	 	        if(rz.getOptionFactory().getOption("zutatenverzeichnis.zahlen",1) == 1) {
 	 	            chkZahlen.setSelected(true);
 	 	        } else {
 	 	            chkZahlen.setSelected(false);
 	 	        }
 	 	        if(rz.getOptionFactory().getOption("zutatenverzeichnis.disclaimer",1) == 1) {
 	 	            chkComment.setSelected(true);
 	 	        } else {
 	 	            chkComment.setSelected(false);
 	 	        }
 	 	        fromItem();
 			 }
	      	 break;

        default:
            rz.getLogFactory().logMessage(2, "zutatenverzeichnis_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_DRUCKEN_CODE), new AuswahlAction(rz,this,ACTION_DRUCKEN_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_CLOSE_CODE), new AuswahlAction(rz,this, ACTION_CLOSE_CODE,ACTION_CLOSE_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_SAVE_COMMENT_CODE), new AuswahlAction(rz,this, ACTION_SAVE_COMMENT_CODE,ACTION_SAVE_COMMENT_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_SAVE_PDF_CODE), new AuswahlAction(rz,this, ACTION_SAVE_PDF_CODE,ACTION_SAVE_PDF_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_REPLY_CODE), new AuswahlAction(rz,this, ACTION_REPLY_CODE,ACTION_REPLY_TEXT,0, 0));
		actionList.put(String.valueOf(ACTION_CONTENT_CODE), new AuswahlAction(rz,this, ACTION_CONTENT_CODE,ACTION_CONTENT_TEXT,0, 0));

    }

	/** speichert die Position der Splitbalken
	 */
    private void saveDividerLocations(){
        rz.getFensterFactory().setOption(this.getName() + ".splText", this.splText.getDividerLocation());
        rz.getFensterFactory().saveOptions();
    }
	/** setzt die Position der Splitbalken auf gespeicherte Positionen oder
	 * auf Standardposition, wenn keine gespeicherten vorliegen
	 *
	 */
    private void setDividerLocations() {
        splText.setDividerLocation(rz.getFensterFactory().getOption(this.getName() + ".splText",this.getHeight()/2));
    }

    private void replyAction() {
    	try {
    		origin.getMessage(new MessageItem(MessageItem.ZUTATENVERZEICHNIS_REZEPTUR_REPLY,0,this.txtText.getText().trim(),this));
    	}catch(Exception e) {}
    }
    
    private void contentAction() {
    	if(zl != null && zl.getRi().getRezeptur().getID() != 0) {
     	 	rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_REZEPTUR_CONTENT,false,new MessageItem(MessageItem.MSG_SHOW_REZEPTUR_CONTENT,zl.getRi().getRezeptur().getID(),null,this));
    	}
    }
    
    private void saveCommentAction() {
    	if(!txtComment.getText().trim().equals("")) {
    		rz.getDatabase().getMessages().saveMessage(DBMessages.TEXTMESSAGE_TYP_ZUTATENVERZEICHNIS,txtComment.getText().trim());
    	}
    }

    private void savePDFAction() {
    	if(!txtText.getText().trim().equals("")) {
            zl.setTitel(txtTitel.getText().trim());
       	 zl.setText(txtText.getText().trim() +( (chkComment.isSelected() == true)?( "\n\n\n" + this.txtComment.getText().trim()):""));
          	 rz.getReportFactory().zutatenverzeichnisReportPDF(zl,this);
       	}
    }

    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void printAction(){
    	if(!txtText.getText().trim().equals("")) {
         zl.setTitel(txtTitel.getText().trim());
    	 zl.setText(txtText.getText().trim() +( (chkComment.isSelected() == true)?( "\n\n\n" + this.txtComment.getText().trim()):""));
       	 rz.getReportFactory().zutatenverzeichnisReport(zl,this);
    	}
     }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    /**
     * Daten vom Item in die GUI übertragen
     *
     */
    private void fromItem(){
    	refreshAction();
    }

    private void refreshAction() {
    	if (zl != null) {
    		txtTitel.setText(zl.getRi().getRezeptur().getTitel());
	    	if(chkZahlen.isSelected()) {
	    		txtText.setText(getTextNumeric());
	    	}else {
	    		txtText.setText(getTextFromItem());
	    	}
	    	txtText.setCaretPosition(0);
	    	txtText.requestFocus();
    	}
    }

    private String getTextFromItem() {
    	String ret="";
    	if(zl != null) {
    		for (int i=0;i < zl.getZvk().size();i++) {
    			ret += zl.getZvk().getItem(i).getBezeichnung() + "\n";
    		}
    	}
    	return ret;
    }



    private String getTextNumeric() {
    	String ret="";
    	if(zl != null) {
    		for (int i=0;i < zl.getZvk().size();i++) {
    			ret += zl.getZvk().getItem(i).getBezeichnung() + "   ( " +rz.getLocale().formatNumber(zl.getZvk().getItem(i).getValue(),OptionFactory.NF_NORMAL) + " % )\n";
    		}
    	}
    	return ret;
    }

    /**
     * GUI-Daten in das Item übertragen
     *
     */

    @Override
	public void closeWindow(){
    	saveDividerLocations();
		if(chkZahlen.isSelected()) {
		    rz.getOptionFactory().setOption("zutatenverzeichnis.zahlen", 1);
		} else {
		    rz.getOptionFactory().setOption("zutatenverzeichnis.zahlen", 0);
		}
		if(chkComment.isSelected()) {
		    rz.getOptionFactory().setOption("zutatenverzeichnis.disclaimer", 1);
		} else {
		    rz.getOptionFactory().setOption("zutatenverzeichnis.disclaimer", 0);
		}
		rz.getOptionFactory().saveOptions();
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(zl != null) {
            lblTop.setText(rz.getLocale().getString("zutatenverzeichnis.label_titel").replaceAll("%s",zl.getRi().getRezeptur().getTitel()));
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		txtComment.setText(rz.getDatabase().getMessages().getMessage(DBMessages.TEXTMESSAGE_TYP_ZUTATENVERZEICHNIS).getMessage());
    		txtText.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"zutatenverzeichnis.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
