/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.fenster.zutatenverzeichnis;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JNumberField;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.JSelectedTextField;
import de.lunqual.rzpro.fenster.StichworteDialog;
import de.lunqual.rzpro.fenster.dialoge.DialogControl;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.action.AuswahlAction;
import de.lunqual.rzpro.items.dialog.DialogItem;
import de.lunqual.rzpro.items.einheiten.EinheitsItem;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.stichworte.StichwortItem;
import de.lunqual.rzpro.items.zutatenverzeichnis.ZutatenverzeichnisItem;
import de.lunqual.rzpro.options.OptionFactory;

/**
 *
 * @author  administrator
 */
public class ZutatenverzeichnisEingabe extends JRzFrame {

    //GUI-Variablen
	private JMenuBar mb;
    	private JMenu mnuDatei;
    	private JMenu mnuExtras;
    	private JMenu mnuHilfe;
    private JPanel mainPanel;
    	private JPanel toolbarPanel;
    		private JToolBar tb1;
    	private JPanel contentPanel;
    		private JPanel gridPanel;
    			private JPanel nPanel;
	    			private JPanel bezeichnungPanel;
	    				private JLabel lblBezeichnung;
	    				private JSelectedTextField txtBezeichnung;
	    			private JPanel stichwortPanel;
	    				private JLabel lblStichwort;
	    				private JButton btStichwort;
	    				private JLabel lblStichwortText;
	    		private JPanel sPanel;
	    			private JPanel wertPanel;
	    				private JLabel lblWert;
	    				private JComboBox cmbEinheit;
	    				private JLabel lblMal;
	    				private JNumberField txtWert;

		private JPanel buttonPanel;
    		private JButton btOK;
    		private JButton btHilfe;
    		private JButton btCancel;

    // ActionCodes KalkulationEingabe
    public static final int         ACTION_OK_CODE = 1000;
    public static final String      ACTION_OK_TEXT = "zutatenverzeichnis_eingabe.action_ok";
    public static final int         ACTION_ABBRECHEN_CODE = 1001;
    public static final String      ACTION_ABBRECHEN_TEXT = "zutatenverzeichnis_eingabe.action_abbrechen";
    public static final int         ACTION_HILFE_CODE = 1002;
    public static final String      ACTION_HILFE_TEXT = "action_hilfe";
    public static final int         ACTION_HIDE_CODE = 1003;
    public static final String      ACTION_HIDE_TEXT = "action_hide";
    public static final int         ACTION_STICHWORT_CODE = 1004;
    public static final String      ACTION_STICHWORT_TEXT = "zutatenverzeichnis_eingabe.action_stichwort";

    StichworteDialog sd=null;
    ZutatenverzeichnisItem zi;
    JRzFrame			origin;
    StichwortItem		si=null;

    /** Creates new form AdressAuswahl */

    public ZutatenverzeichnisEingabe(RzPro r, String name,Object extendedData) {
        super(r,name,extendedData);
        createActions();
        createGUIComponents();
        setGUIComponents();
        getMessage((MessageItem)extendedData);
    }

    @Override
	public void createGUIComponents() {
        mb = new JMenuBar();
		mnuDatei = new JMenu();
			mb.add(mnuDatei);
        mnuExtras = new JMenu();
        	mb.add(mnuExtras);
        mnuHilfe = new JMenu();
        	mb.add(mnuHilfe);
		setJMenuBar(mb);
		mainPanel = new JPanel(new BorderLayout());
			toolbarPanel = new JPanel(new BorderLayout());
				tb1 = new JToolBar();
				tb1.setFloatable(false);
				tb1.setRollover(true);
				toolbarPanel.add(tb1);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			contentPanel  = new JPanel(new BorderLayout());
						gridPanel =new JPanel(new BorderLayout());
							nPanel = new JPanel(new BorderLayout());
								bezeichnungPanel=new JPanel(new GridLayout(1,2));
									lblBezeichnung = new JLabel();
									lblBezeichnung.setHorizontalAlignment(SwingConstants.RIGHT);
								bezeichnungPanel.add(lblBezeichnung);
									txtBezeichnung = new JSelectedTextField();
								bezeichnungPanel.add(txtBezeichnung);
								bezeichnungPanel.setBorder(BorderFactory.createRaisedBevelBorder());
							nPanel.add(bezeichnungPanel,BorderLayout.SOUTH);

							stichwortPanel=new JPanel(new GridLayout(1,3));
							 lblStichwort = new JLabel();
								stichwortPanel.add(lblStichwort);
								btStichwort=new JButton();
								stichwortPanel.add(btStichwort);
								lblStichwortText = new JLabel();
								stichwortPanel.add(lblStichwortText);
								stichwortPanel.setBorder(BorderFactory.createRaisedBevelBorder());
							nPanel.add(stichwortPanel,BorderLayout.NORTH);
						gridPanel.add(nPanel,BorderLayout.NORTH);
					sPanel=new JPanel(new BorderLayout());
						wertPanel=new JPanel(new GridLayout(1,4));
							lblWert=new JLabel();
							wertPanel.add(lblWert);
							cmbEinheit = new JComboBox();
						    rz.getDatabase().getEinheiten().setGrundeinheitenCmb(this.cmbEinheit,-1);
							wertPanel.add(cmbEinheit);
							lblMal = new JLabel();
							lblMal.setHorizontalAlignment(SwingConstants.CENTER);
							wertPanel.add(lblMal);
							txtWert =  new JNumberField(rz.getLocale().getNumberFormat(OptionFactory.NF_NORMAL),0.0,Double.NEGATIVE_INFINITY,Double.POSITIVE_INFINITY);
							wertPanel.add(txtWert);
							wertPanel.setBorder(BorderFactory.createRaisedBevelBorder());
    				sPanel.add(wertPanel,BorderLayout.NORTH);
				gridPanel.add(sPanel,BorderLayout.SOUTH);
			contentPanel.add(gridPanel,BorderLayout.CENTER);
			buttonPanel=new JPanel(new GridLayout(1,3));
    			btOK=new JButton();
    				buttonPanel.add(btOK);
    			btHilfe = new JButton();
    				buttonPanel.add(btHilfe);
    		    btCancel = new JButton();
    		    	buttonPanel.add(btCancel);
			mainPanel.add(toolbarPanel,BorderLayout.NORTH);
			mainPanel.add(contentPanel,BorderLayout.CENTER);
			mainPanel.add(buttonPanel,BorderLayout.SOUTH);

			getContentPane().setLayout(new BorderLayout());
			getContentPane().add(mainPanel,BorderLayout.CENTER);
    }
    @Override
	public void setGUIComponents() {
        setTitle(rz.getLocale().getString("zutatenverzeichnis_eingabe.titel"));

        mnuDatei.setText(rz.getLocale().getString("menu.datei"));
        mnuExtras.setText(rz.getLocale().getString("menu.extras"));
        mnuHilfe.setText(rz.getLocale().getString("menu.hilfe"));
        mnuDatei.add(getAction(ACTION_OK_CODE));
        mnuDatei.addSeparator();
        mnuDatei.add(getAction(ACTION_ABBRECHEN_CODE));
        mnuExtras.add(getAction(ACTION_HIDE_CODE));
        mnuHilfe.add(getAction(ACTION_HILFE_CODE));

  	  	tb1.add(getAction(ACTION_OK_CODE));
  	  	tb1.add(getAction(ACTION_ABBRECHEN_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HIDE_CODE));
  	  	tb1.addSeparator();
  	  	tb1.add(getAction(ACTION_HILFE_CODE));

        btOK.setAction(getAction(ACTION_OK_CODE));
        btHilfe.setAction(getAction(ACTION_HILFE_CODE));
        btCancel.setAction(getAction(ACTION_ABBRECHEN_CODE));
        btStichwort.setAction(getAction(ACTION_STICHWORT_CODE));

        lblBezeichnung.setText( rz.getLocale().getString("zutatenverzeichnis_eingabe.label_bezeichnung"));
        lblStichwort.setText( rz.getLocale().getString("zutatenverzeichnis_eingabe.label_stichwort"));
        lblStichwortText.setText("");
        lblWert.setText( rz.getLocale().getString("zutatenverzeichnis_eingabe.label_wert"));
        lblMal.setText( rz.getLocale().getString("zutatenverzeichnis_eingabe.label_mal"));

        setResizable(true);
        rz.getFontFactory().setFrameFonts(this);
        pack();
        rz.getFensterFactory().setLocation(this,FensterFactory.POSITION_SIZE) ;
    }
    @Override
	public void getMessage(MessageItem msg) {
        switch(msg.getMsgCode()) {
    	case MessageItem.MSG_ACTIONPERFORMED:
            switch(msg.getCode()){
            case ACTION_ABBRECHEN_CODE :cancelAction();break;
			case ACTION_OK_CODE :okAction();break;
            case ACTION_HILFE_CODE: hilfeAction();break;
            case ACTION_HIDE_CODE:hideAction();break;
            case ACTION_STICHWORT_CODE:stichwortListeBearbeitenAction();break;
            default :
                break;
           }
    		break;
    	case MessageItem.MSG_STICHWORT_DIALOG_REPLY:
    		if(msg.getData() != null) {
    			si = (StichwortItem)msg.getData();
    			zi.setStichwort(si);
    			this.lblStichwortText.setText(zi.getStichwort().getName());
    			zi.setBezeichnung(si.getName());
    			txtBezeichnung.setText(si.getName());
    		}
    		break;
         case MessageItem.MSG_SHOW_ZUTATENVERZEICHNIS_EINGABE:
 			 origin = msg.getOrigin();
 			 if (msg.getData()==null) {
 				 zi = new ZutatenverzeichnisItem(rz,0,0,null,0,1.0,rz.getLocale().getString("zutatenverzeichnis_eingabe_neu"));
 			 } else {
 				 zi = ((ZutatenverzeichnisItem)msg.getData()).copyItem();
 			 }
 			 fromItem();
	      	 break;

        default:
            rz.getLogFactory().logMessage(2, "zutatenverzeichnis_eingabe", "auswahlAction:" + msg.getMsgCode());
            break;
        }
    }

    @Override
	public void createActions(){
        actionList.put(String.valueOf(ACTION_HIDE_CODE),new AuswahlAction(rz,this,ACTION_HIDE_CODE,ACTION_HIDE_TEXT, KeyEvent.VK_F5 ,InputEvent.SHIFT_DOWN_MASK));
        actionList.put(String.valueOf(ACTION_HILFE_CODE),new AuswahlAction(rz,this,ACTION_HILFE_CODE,ACTION_HILFE_TEXT, KeyEvent.VK_F1 ,0));
		actionList.put(String.valueOf(ACTION_OK_CODE), new AuswahlAction(rz,this,ACTION_OK_CODE,ACTION_OK_TEXT,KeyEvent.VK_O,	InputEvent.CTRL_DOWN_MASK));
		actionList.put(String.valueOf(ACTION_ABBRECHEN_CODE), new AuswahlAction(rz,this, ACTION_ABBRECHEN_CODE,ACTION_ABBRECHEN_TEXT,KeyEvent.VK_ESCAPE, 0));
		actionList.put(String.valueOf(ACTION_STICHWORT_CODE), new AuswahlAction(rz,this, ACTION_STICHWORT_CODE,ACTION_STICHWORT_TEXT,0, 0));
    }

	private void stichwortListeBearbeitenAction() {
		int x, y;
		x = (int) (btStichwort.getLocationOnScreen().getX());
		y = (int) (btStichwort.getLocationOnScreen().getY());
		if(sd != null) {
			sd.dispose();
			sd = null;
		}
		sd = new StichworteDialog(this,  rz, x, y,zi.getStichwort() != null ? zi.getStichwort().getName():"");
		sd.setVisible(true);
	}


    /**
     * ok gedrückt... abspeichern oder ändern
     */
    private void okAction(){
       if( toItem() == true) {
    		origin.getMessage(new MessageItem(MessageItem.MSG_ZUTATENVERZEICHNIS_EINGABE_REPLY,0,zi,this ));
        	closeWindow();
       }
     }

    /**
     * cancel
     */
    private void cancelAction(){
        closeWindow();
    }

    /**
     * Daten vom Item in die GUI übertragen
     *
     */
    private void fromItem(){
    	txtBezeichnung.setText(zi.getBezeichnung());
    	if(zi.getStichwort() == null) {
        	lblStichwortText.setText("");
    	}else {
    		lblStichwortText.setText(zi.getStichwort().getName());
    	}
    	txtWert.setValue(zi.getWert());
    	for(int i =0;i < cmbEinheit.getModel().getSize();i++) {
    		final EinheitsItem ei = (EinheitsItem)cmbEinheit.getModel().getElementAt(i);
    		if(zi.getEinheit() == ei.getID()) {
    			cmbEinheit.setSelectedIndex(i);
    			break;
    		}
    	}
    }

    /**
     * GUI-Daten in das Item übertragen
     *
     */
    private boolean toItem(){
    	boolean ret=false;
    	DialogItem di;
    	if(!txtBezeichnung.getText().trim().equals("")) {
    		if(zi.getStichwort() != null) {
    			if(!rz.isZero(txtWert.getValue())){
    				final EinheitsItem ei = (EinheitsItem)cmbEinheit.getSelectedItem();
    				zi.setEinheit(ei.getID());
    				zi.setBezeichnung(txtBezeichnung.getText().trim());
    				zi.setWert(txtWert.getValue());
    				ret= true;
    			}else {
    				//value == 0;
    				 di = new DialogItem(
    		                    DialogControl.HINWEIS_DIALOG,
    		                    "",0.0,
    		                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler"),
    		                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler"),
    		                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler_wert"),
    		                    "frage.png",
    		                    rz.getLocale().getString("string_ok"),
    							"",
    		                    this
    		            );
    		            rz.getDialogFactory().getDialog(di);
    			}
    		} else {
    			//stichwort fehlt
				 di = new DialogItem(
		                    DialogControl.HINWEIS_DIALOG,
		                    "",0.0,
		                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler"),
		                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler"),
		                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler_stichwort"),
		                    "frage.png",
		                    rz.getLocale().getString("string_ok"),
							"",
		                    this
		            );
		            rz.getDialogFactory().getDialog(di);
    		}
    	}else {
    		//Bezeichnung fehlt
			 di = new DialogItem(
	                    DialogControl.HINWEIS_DIALOG,
	                    "",0.0,
	                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler"),
	                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler"),
	                    rz.getLocale().getString("zutatenverzeichnis_eingabe.fehler_bezeichnung"),
	                    "frage.png",
	                    rz.getLocale().getString("string_ok"),
						"",
	                    this
	            );
	            rz.getDialogFactory().getDialog(di);
    	}
    	return ret;
    }

    @Override
	public void closeWindow(){
    	rz.getFensterFactory().getFensterListe().disposeFrame(this);
    }
    @Override
	public void openWindow(){
    	if(zi != null) {
    		if (!isVisible()) {
				setVisible(true);
			}
    		toFront();
    		btStichwort.requestFocus();
    	} else {
    		closeWindow();
    	}
    }

	//hilfe
	private void hilfeAction() {
        rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_HILFE,true,new MessageItem(MessageItem.MSG_HILFE,0,"zutatenverzeichnis_eingabe.html",this));
	}

    private void hideAction() {
        rz.getFensterFactory().getFensterListe().sperren(this);
    }
}
