/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.abfrage;
import java.util.Date;

import de.lunqual.rzpro.database.DBAbfrage;
import de.lunqual.rzpro.items.stichworte.StichwortListe;
/**
 *
 * @author  administrator
 */
public class AbfrageItem implements java.io.Serializable{

	int             typ;
    int             id;
    int             order;
    int             adressenMode;
    int             stichworteMode;
    String          name;
    StichwortListe  adressen;
    StichwortListe  stichworte;
    String          muster;
    Date            erstellt;
    String          user_1;
    int			  mode;
    boolean	ablage;
    boolean 	privat;
    
    /** Creates a new instance of AbfrageItem */
    public AbfrageItem() {
        typ = DBAbfrage.ABFRAGE_TYP_NORMAL;
        adressen = new StichwortListe();
        stichworte = new StichwortListe();
        name = "";
        muster = "";
        order = DBAbfrage.ABFRAGE_ORDER_AA;
        mode= DBAbfrage.ABFRAGE_MODE_MUSTER;
        ablage=false;
        privat=false;
    }

    public AbfrageItem(int aID,int aTyp,int aOrder,int aAMode,int aSMode,String aName,String aMuster,int aMode,StichwortListe aAdressen,StichwortListe aStichworte,Date aErstellt,String aUser1,boolean ablage,boolean privat){
        id = aID;
        typ = aTyp;
        order = aOrder;
        adressenMode  = aAMode;
        stichworteMode = aSMode;
        name = aName;
        muster = aMuster;
        mode = aMode;
        adressen = aAdressen;
        stichworte = aStichworte;
        erstellt = aErstellt;
        user_1 = aUser1;
        this.ablage=ablage;
        this.privat=privat;
    }



	public AbfrageItem copyItem(){
        final AbfrageItem ai = new AbfrageItem();
        ai.setID(getID());
        ai.setTyp(getTyp());
        ai.setOrder(getOrder());
       	ai.setMuster(getMuster());
        ai.setAdressListe(getAdressListe().copyList());
        ai.setStichwortListe(getStichwortListe().copyList());
        ai.setSMode(getSMode());
        ai.setAMode(getAMode());
        ai.setMode(this.getMode());
        ai.setErstellt(getErstellt());
        ai.setUser1(getUser1());
        ai.setAblage(ablage);
        ai.setPrivat(privat);
        return ai;
    }

	public boolean isPrivat() {
		return privat;
	}

	public void setPrivat(boolean privat) {
		this.privat = privat;
	}    
    
    public int  getTyp(){return typ;}
    public int getOrder(){return order;}
    public int getAMode(){return adressenMode;}
    public int getSMode(){return stichworteMode;}
    public String getName(){return name;}
    public int  getID(){return id;}
    public StichwortListe getAdressListe(){return adressen;}
    public StichwortListe getStichwortListe(){return stichworte;}
    public String getMuster(){
    	return muster;
    }
    public Date getErstellt(){return erstellt;}
    public String getUser1(){return user_1;}
    public boolean isAblage() {return ablage;}
    
    public void setOrder(int aOrder){order = aOrder;}
    public void setAMode(int aAMode){adressenMode = aAMode;}
    public void setSMode(int aSMode){stichworteMode = aSMode;}
    public void setName(String aName){name = aName;}
    public void setTyp(int t){typ = t;}
    public void setID(int i){id = i;}
    public void setMuster(String aMuster){muster = aMuster;}
    public void setAdressListe(StichwortListe si){
        adressen = null;
        adressen = si;
    }
    public void setAblage(boolean ablage) {
    	this.ablage=ablage;
    }
    public void setStichwortListe(StichwortListe si){
        stichworte = null;
        stichworte = si;
    }
    public void setErstellt(Date aErstellt){erstellt = aErstellt;}
    public void setUser1(String aUser_1){user_1 = aUser_1;}
    @Override
	public String toString(){
        return name;
    }
	/**
	 * @return Returns the mode.
	 */
	public int getMode() {
		return mode;
	}
	/**
	 * @param mode The mode to set.
	 */
	public void setMode(int mode) {
		this.mode = mode;
	}

	
}
