/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.abfrage;

import java.util.ArrayList;

/**
 *
 * @author  lunqual
 */
public class AbfrageListe extends ArrayList implements java.io.Serializable  {

    int             count;
    int             current;

    /** Creates a new instance of AbfrageListe */
    public AbfrageListe(int aCount) {
        count = aCount;
        current = -1;
    }

    
    public AbfrageItem getItem(int i) {
    	return (AbfrageItem)this.get(i);
    }


    /**------------------------------------------------------------
     * addItem(AbfrageItem fügt eine Abfrage an die Liste an
     * gibt die Nummer der eingefügten Abfrage zurück,
     * was im Moment immer die Größe der Liste ist weil Einträge
     * am Ende angefügt werden
     *-------------------------------------------------------------
     */
    
    public int addItem(AbfrageItem ai) {
    	int p = getAbfrageNummer(ai);
    	if(p != -1) {
    		AbfrageItem ai1 = this.getItem(p);
    		this.remove(ai1);
    	} 
    	return addItem2(ai);
    }
    private int addItem2(AbfrageItem ai){

        // hier wird eine Kopie des items angefertigt...
        final AbfrageItem ai1 = new AbfrageItem();
        ai1.setID(ai.getID());
        ai1.setTyp(ai.getTyp());
        ai1.setMuster(ai.getMuster());
        ai1.setAdressListe(ai.getAdressListe());
        ai1.setStichwortListe(ai.getStichwortListe());
        ai1.setOrder(ai.getOrder());
        ai1.setAMode(ai.getAMode());
        ai1.setSMode(ai.getSMode());
        ai1.setMode(ai.getMode());
        ai1.setAblage(ai.isAblage());
        this.add(ai1);
        if (this.size() > count){
            // wenn mehr als Count Einträge vorhanden sind,
            // den ersten entfernen
            this.remove(0);
       }
       current = this.size()-1;
       return current;
    }

    private int getAbfrageNummer(AbfrageItem ai) {
    	for(int i =0;i<this.size();i++) {
    		AbfrageItem ai1 = this.getItem(i);
    		if(ai.getTyp() == ai1.getTyp()) {
	    		if(ai.getMuster().equals(ai1.getMuster())){
	    			if(ai.getAdressListe().toString().equals(ai1.getAdressListe().toString())) {
	    				if(ai.getStichwortListe().toString().equals(ai1.getStichwortListe().toString())) {
	    					return i;
	    				}
	    			}
	    		}
	    	}
    	}
    	return -1;
    }
    private void moveAbfrageToEnd(int n) {
    	
    }
    
    public void removeCurrentItem(){
        if(!isEmpty()){
            this.remove(current);
            if (current >= this.size()) {
				current = this.size() -1;
			}

        }
    }
    /**
     * isListEmpty() gibt true zurück wenn die Liste entweder
     * leer ist oder nur eine einzige Abfrage enthält
     */
    public boolean isListEmpty(){
        return (this.isEmpty() || (this.size() == 1));
    }


    public int getCount() {
    	return this.size();
    }
    public AbfrageItem getCurrentItem(){
        if(!isEmpty()){
            return (AbfrageItem)this.get(current);
        } else {
			return null;
		}
    }

    public int getCurrentItemNumber(){
        return (current + 1);
    }

    public int getMaxCount(){
        return count;
    }
    public AbfrageItem moveForward(){
        if (this.size() > 0){
            if(current < (this.size()-1)){
                current++;
                return getCurrentItem();
            }
        }
        return getCurrentItem();
    }

    public AbfrageItem moveFirst(){
        if (!isListEmpty()){
            current = 0;
        }
        return getCurrentItem();
    }

    public AbfrageItem moveLast(){
        if (!isListEmpty()){
            current = this.size() - 1;
        }
        return getCurrentItem();
    }

    public AbfrageItem moveBack(){
        if (!isListEmpty()){
            if (current > 0){
                --current;
            }
        }
        return getCurrentItem();
    }

    public boolean isLast(){
        if (!isListEmpty()){
            return (current == (this.size()-1))?true:false;
        }
        return false;
    }

    public boolean isFirst(){
        if (!isListEmpty()){
            return (current == 0)?true:false;
        }
        return false;
    }
    
    public void setCurrentItem(int i) {
    	if(i <= this.size()) {
    		current=i;
    	}
    }
}
