/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.action;

import javax.swing.Icon;
import javax.swing.KeyStroke;

import de.lunqual.rzpro.RzPro;

/**
 *
 * @author  lunqual
 */
public class ActionItem {

    RzPro           rz;
    String          key;
    String          text;
    Icon            icon;
    String          description;
    Integer        mnemonic;
    KeyStroke   keystroke;
    int              code;

    /** Creates a new instance of ActionItem */
    public ActionItem(RzPro r,String aKey,KeyStroke aKs,int aCode) {
        rz = r;
        code = aCode;
        key = aKey;
        text = rz.getLocale().getString(key);
        mnemonic = rz.getLocale().getMnemonic(key + ".0");
        description = rz.getLocale().getString(key + ".1");
        icon = new javax.swing.ImageIcon(getClass().getResource("/de/lunqual/rzpro/gfx/" + key + ".png"));
        keystroke = aKs;
    }
    public String getKey(){return key;}
    public int getCode(){return code;}
    public String getText(){return text;}
    public Icon getIcon(){return icon;}
    public String getDescription(){return description;}
    public Integer getMnemonic(){return mnemonic;}
    public KeyStroke getKeyStroke(){return keystroke;}
}
