package de.lunqual.rzpro.items.auftrag;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.buchung.SaldenItem;
import de.lunqual.rzpro.items.mischungen.MischungenTankItem;
import de.lunqual.rzpro.options.OptionFactory;

public class BedarfsZutat {

	RzPro				rz;
	int					rezeptur;
	String				bezeichnung;
	SaldenItem			bedarf;
	SaldenItem			bestand;
	SaldenItem			saldo;
	boolean				bestellung;
	double				mischungLA;
	
	public BedarfsZutat(RzPro rz,int rezeptur, String bezeichnung, double liter, double kg, double la) {
		this.rz = rz;
		this.rezeptur = rezeptur;
		this.bezeichnung = bezeichnung;
		this.mischungLA = 0.0;
		bedarf = new SaldenItem(liter,kg,la,RzPro.EINHEIT_LITER);
		saldo = new SaldenItem(0,0,0,RzPro.EINHEIT_LITER);
		getBestandsSaldo();
		getBestellung();
		MischungLA();
	}

	public int getRezeptur() {
		return rezeptur;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	
	
	public void addLiter(double liter) {
		bedarf.setLiter(bedarf.getLiter() + liter);
	}

	public void addLa(double la) {
		bedarf.setLa(bedarf.getLa() + la);
	}
	
	public void addKg(double kg) {
		bedarf.setKg(bedarf.getKg() + kg);
	}
	
	private void getBestandsSaldo() {
		bestand = rz.getDatabase().getRezeptur().getBestandsSaldo(rezeptur);
	}
	
	public SaldenItem getBestand() {
		return bestand;
	}
	
	public SaldenItem getBedarf() {
		return bedarf;
	}

	public SaldenItem getSaldo() {
		saldo.setLiter(bestand.getLiter() - bedarf.getLiter());
		saldo.setLa(bestand.getLa() - bedarf.getLa());
		saldo.setKg(bestand.getKg() - bedarf.getKg());
		return saldo;
	}
	
	private void getBestellung() {
		bestellung = rz.getDatabase().getBestellung().checkBestellung(rezeptur) == null?false:true;
	}
	public boolean isBestellung() {
		return bestellung;
	}
	
	public String bedarfToString() {
		String ret = "";
		ret = rz.getLocale().formatNumber(getBedarf().getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "\n" +
				rz.getLocale().formatNumber(getBedarf().getKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") + "\n";
		if(!rz.isZero(getBedarf().getLa())){
			ret += rz.getLocale().formatNumber(getBedarf().getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");
		}
		return ret;
	}
	public String bestandToString() {
		String ret = "";
		ret = rz.getLocale().formatNumber(getBestand().getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "\n" +
				rz.getLocale().formatNumber(getBestand().getKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") + "\n";
		if(!rz.isZero(getBestand().getLa())){
			ret += rz.getLocale().formatNumber(getBestand().getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la") + "\n";
		}
		if(!rz.isZero(getMischungLA())){
			
			ret += rz.getLocale().getString("bedarfsfenster.mischung_druck").replaceAll("%l", rz.getLocale().formatNumber(getMischungLA(),OptionFactory.NF_ONE) );
		}
		return ret;
	}
	public String saldoToString() {
		String ret = "";
		ret = rz.getLocale().formatNumber(getSaldo().getLiter(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "\n" +
				rz.getLocale().formatNumber(getSaldo().getKg(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_kg") + "\n";
		if(!rz.isZero(getSaldo().getLa())){
			ret += rz.getLocale().formatNumber(getSaldo().getLa(),OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la") + "\n";
		}
		if(!rz.isZero(getMischungLA())){
			String m = rz.getLocale().formatNumber((getMischungLA() + getBestand().getLa()) - getBedarf().getLa() ,OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_la");
			ret += rz.getLocale().getString("bedarfsfenster.mischung_druck").replace("%l", m);
		}
		return ret;
	}

	public double getMischungLA() {
		return mischungLA;
	}
	
	private void MischungLA() {
    	ArrayList<MischungenTankItem>mischungen = rz.getDatabase().getMischungen().getMischungenTanksFromRezeptur(rezeptur);
    	if(mischungen != null && !mischungen.isEmpty()) {
    		for(MischungenTankItem t:mischungen) {
    			mischungLA += t.getLa();
    		}
    	}
	}
}
