package de.lunqual.rzpro.items.auftrag;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;


public class BedarfsZutatenListe extends ArrayList{

	Collator coll;
	Comparator compAlpha;
	Comparator compBedarf;
	Comparator compBestand;
	Comparator compSaldo;
	Comparator compBestellung;
	
	boolean reverseAlpha=false;
	boolean reverseBedarf=true;
	boolean reverseBestand=true;
	boolean reverseSaldo=false;
	boolean reverseBestellung=true;
	
	public BedarfsZutatenListe()  {
		coll = Collator.getInstance(Locale.getDefault());
		compAlpha = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BedarfsZutat b1 = (BedarfsZutat) o1;
				final BedarfsZutat b2 = (BedarfsZutat) o2;
				return coll.compare(b1.getBezeichnung(), b2.getBezeichnung());
			}
		};	
		compBedarf = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BedarfsZutat b1 = (BedarfsZutat) o1;
				final BedarfsZutat b2 = (BedarfsZutat) o2;
				return b1.getBedarf().getLiter() >b2.getBedarf().getLiter() ?1:-1;
			}
		};	
		compBestand = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BedarfsZutat b1 = (BedarfsZutat) o1;
				final BedarfsZutat b2 = (BedarfsZutat) o2;
				return b1.getBestand().getLiter() >b2.getBestand().getLiter() ?1:-1;
			}
		};
		compSaldo = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BedarfsZutat b1 = (BedarfsZutat) o1;
				final BedarfsZutat b2 = (BedarfsZutat) o2;
				return b1.getSaldo().getLiter() >b2.getSaldo().getLiter() ?1:-1;
			}
		};
		compBestellung = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BedarfsZutat b1 = (BedarfsZutat) o1;
				return b1.isBestellung() ?1:-1;
			}
		};
	}
	
	public void sortAlpha() {
		if (reverseAlpha) {
			Collections.sort(this, compAlpha);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compAlpha);
		}
		reverseAlpha=!reverseAlpha;
	}
	
	public void sortBedarf() {
		if (reverseBedarf) {
			Collections.sort(this, compBedarf);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBedarf);
		}
		reverseBedarf=!reverseBedarf;
	}

	public void sortBestand() {
		if (reverseBestand) {
			Collections.sort(this, compBestand);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBestand);
		}
		reverseBestand=!reverseBestand;
	}
	
	public void sortSaldo() {
		if (reverseSaldo) {
			Collections.sort(this, compSaldo);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compSaldo);
		}
		reverseSaldo=!reverseSaldo;
	}
	
	public void sortBestellung() {
		if (reverseBestellung) {
			Collections.sort(this, compBestellung);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBestellung);
		}
		reverseBestellung=!reverseBestellung;
	}
	
}
