package de.lunqual.rzpro.items.auftrag;

import java.util.Calendar;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBAuftrag;

public class RepeatSpanItem {
	RzPro			rz;
	int				mode;
	String			text;
	
	public RepeatSpanItem(RzPro rz, int mode,String text) {
		super();
		this.rz = rz;
		this.mode = mode;
		this.text = text;
	}

	public int getMode() {
		return mode;
	}

	public void setMode(int mode) {
		this.mode = mode;
	}

	public String getText() {
		return text;
	}

	public void setText(String text) {
		this.text = text;
	}
	
	public String toString() {
		return text;
	}
	
	public Calendar berechnen(Calendar faellig,int repStart,int value) {
		Calendar c = Calendar.getInstance();
		Calendar now = Calendar.getInstance();
		if(repStart == DBAuftrag.REP_MODE_FAELLIG) {
			now.setTimeInMillis(faellig.getTimeInMillis());
		}
		c.setTimeInMillis(faellig.getTimeInMillis());
		rz.roundDatum(c);
		rz.roundDatum(now);
		switch(mode) {
			case DBAuftrag.REP_SPAN_TAGE:
				c.add(Calendar.DATE,value);
				rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(c,true);
				break;
			case DBAuftrag.REP_SPAN_WOCHEN:
				c.add(Calendar.DATE,value*7);
				rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(c,true);
				break;
			case DBAuftrag.REP_SPAN_MONATE:
				c.add(Calendar.MONTH,value);
				break;
			case DBAuftrag.REP_SPAN_TAG_DES_MONATS:
				c.set(Calendar.DAY_OF_MONTH,value);
				rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(c,true);
				if(c.before(now)) {
					c.add(Calendar.MONTH,1);
				}
				break;
			case DBAuftrag.REP_SPAN_MONATSANFANG:
				c.add(Calendar.MONTH, 1);
				c.set(Calendar.DAY_OF_MONTH,1);
				rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(c,true);
				break;
			case DBAuftrag.REP_SPAN_MONATSENDE:
				c.set(Calendar.DAY_OF_MONTH,c.getActualMaximum(Calendar.DAY_OF_MONTH));
				rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(c,false);
				if(c.getTimeInMillis() == now.getTimeInMillis()){
					c.set(Calendar.DAY_OF_MONTH, 5);
					c.add(Calendar.MONTH,1);
					c.set(Calendar.DAY_OF_MONTH,c.getActualMaximum(Calendar.DAY_OF_MONTH));
					rz.getDatabase().getAuftrag().getAuftragsConfig().getValidDate(c,false);
				}
				break;
		}

		rz.roundDatum(c);
		return c;
	}
	
	public String getSpanString(AuftragsItem ai) {
		String ret = rz.getLocale().getString("repeatspanitem.rep_string_0");
		if(ai.getRepSpan() == DBAuftrag.REP_SPAN_MONATSANFANG || ai.getRepSpan()==DBAuftrag.REP_SPAN_MONATSENDE) {
			ret += " " + rz.getLocale().getString("repeatspanitem.rep_string_2");
 			ret += " " + toString();
		}else {
			ret += " " + rz.getLocale().getString("repeatspanitem.rep_string_1");
			ret += " " +String.valueOf(ai.getRepeat_value());
			ret += " " + text;
		}
		if(ai.getRepStart() == DBAuftrag.REP_MODE_ERLEDIGT) {
			ret += " " + rz.getLocale().getString("repeatspanitem.rep_string_ne");
		}else {
			ret += " " + rz.getLocale().getString("repeatspanitem.rep_string_nf");
		}
		return ret;
	}
	
}
