package de.lunqual.rzpro.items.auftrag;

import java.text.SimpleDateFormat;
import java.util.Calendar;

import de.lunqual.rzpro.RzPro;

public class TagesItem {
	RzPro rz;
	Calendar c;
	boolean feiertag;
	String	vg;
	String 	hg;
	int		count;
	SimpleDateFormat df;
	
	public TagesItem(RzPro rz,long millis,boolean feiertag) {
		this.rz=rz;
		this.feiertag=feiertag;
		c = Calendar.getInstance();
		c.setTimeInMillis(millis);
		rz.roundDatum(c);
		count=0;
		df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
	}

	public TagesItem(RzPro rz,long millis,int count) {;
		this.rz=rz;
		this.count=count;
		c = Calendar.getInstance();
		c.setTimeInMillis(millis);
		rz.roundDatum(c);
		df = new SimpleDateFormat("EEEE, dd. MMMM yyyy");
		this.feiertag=false;
	}
	
	public TagesItem copyItem() {
		TagesItem ti = new  TagesItem(rz,c.getTimeInMillis(),feiertag);
		if(ti != null) {
			ti.setMillis(c.getTimeInMillis());
			ti.setHg(hg);
			ti.setVg(vg);
			ti.setMillis(ti.getCalendar().getTimeInMillis());
			ti.setFeiertag(feiertag);
			ti.setCount(count);
		}
		return ti;
	}


	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public String toString() {
		return df.format(c.getTime());
	}

	public RzPro getRz() {
		return rz;
	}

	public void setRz(RzPro rz) {
		this.rz = rz;
	}

	public long getMillis() {
		return c.getTimeInMillis();
	}

	public void setMillis(long milliseconds) {
		c.setTimeInMillis(milliseconds);
	}

	public Calendar getCalendar() {
		return c;
	}

	public void setCalendar(Calendar c) {
		this.c = c;
	}


	public void setFeiertag(boolean feiertag) {
		this.feiertag = feiertag;
	}

	public String getVg() {
		return vg;
	}

	public void setVg(String vg) {
		this.vg = vg;
	}

	public String getHg() {
		return hg;
	}

	public void setHg(String hg) {
		this.hg = hg;
	}

	public SimpleDateFormat getDf() {
		return df;
	}

	public void setDf(SimpleDateFormat df) {
		this.df = df;
	}

	
	
}
