package de.lunqual.rzpro.items.auftrag;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

import de.lunqual.rzpro.RzPro;

public class TagesListe extends ArrayList {

	RzPro 								rz;
    private final Collator        		coll;
    private final Comparator      		compValue;
    boolean 							saturday;
	
	public TagesListe(RzPro rz,boolean saturday) {
		super();
		this.rz=rz;
		this.saturday=saturday;
		coll = Collator.getInstance(Locale.getDefault());
	       compValue = new Comparator()
	       {
	           public int compare(Object o1,Object o2){
	           	TagesItem ti1=(TagesItem)o1;
	           	TagesItem ti2=(TagesItem)o2;
	           	int r=0;
				if (ti1.getMillis() >= ti2.getMillis()) {
					r = 1;
				} else {
					if (ti1.getMillis() < ti2.getMillis()) {
							r = -1;
						}
					}
					return r;
	            }
	        };
	}
	
	public void setFeiertagsListe(String liste) {
		this.clear();
		String[] l=liste.split(";");
		for(int i=0;i<l.length;i++) {
			try {
				this.addItem(new TagesItem(rz,Long.parseLong(l[i]),true));
			}catch(NumberFormatException e) {}
		}
	}
	
	public boolean isInList(long millis) {
		boolean ret=false;
		for(int i=0;i<this.size();i++) {
			if(this.getItem(i).getMillis()==millis) {
				return true;
			}
		}
		
		return ret;
	}
	
	public TagesListe copyList() {
		TagesListe ret=new TagesListe(rz,saturday);
		for(int i=0;i<this.size();i++) {
			ret.addItem(this.getItem(i).copyItem());
		}
		return ret;
	}
	
	public void sort() {
		Collections.sort(this,compValue);
	}
	
	public void addItem(TagesItem ti) {
		this.add(ti);
		sort();
	}
	
	public boolean removeItem(long millis) {
		for(int i=0;i<this.size();i++) {
			if(this.getItem(i).getMillis()==millis) {
				this.remove(i);
				sort();
				return true;
			}
		}
		return false;
	}
	
	public TagesItem getItem(int i) {
		return (TagesItem)this.get(i);
	}
	
	public String getDatabaseString() {
		String ret="";
		sort();
		for(int i=0;i<this.size();i++) {
			ret+=Long.toString(getItem(i).getMillis()) + ";";
		}
		if(ret.endsWith(";")){
			ret=ret.substring(0,ret.length()-1);
		}
		return ret;
	}
}
