package de.lunqual.rzpro.items.bewertungen;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.JDialog;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.DBBewertungen;
import de.lunqual.rzpro.options.OptionFactory;

public class BewertungsItem {
	RzPro								rz;
	int									id;
	String								bezeichnung;
	String								losnummer;
	double								bewertung;
	double								divisor;
	String								comment;
	Date								erstellt;
	String								erstellt_user;
	Date								geaendert;
	String								geaendert_user;
	ArrayList<KategorieItem> 			kategorien;
	SimpleDateFormat					df;
	JDialog								parentDialog;
	String							kontrolle;
	Date								kontrolle_datum;
	
	
	public BewertungsItem(RzPro rz) {
		this.rz = rz;
		this.id = 0;
		this.divisor = 1;
		df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
		kategorien = new ArrayList<KategorieItem>();
	}
	
	public BewertungsItem(RzPro rz, int id, String bezeichnung, String losnummer, double bewertung, String comment, Date erstellt, String erstellt_user, Date geaendert, String geaendert_user,String kontrolle,Date kontrolle_datum) {
		this.rz = rz;
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.losnummer = losnummer;
		this.bewertung = bewertung;
		this.comment = comment;
		this.erstellt = erstellt;
		this.erstellt_user = erstellt_user;
		this.geaendert = geaendert;
		this.geaendert_user = geaendert_user;
		this.kontrolle = kontrolle;
		this.kontrolle_datum = kontrolle_datum;
		this.divisor = 1;
		df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
		initListe();
	}
	
	public String getSummenZeile() {
		String ret = "";
		double summe = 0.0;
		double div = 0.0;
		for(KategorieItem ki:kategorien) {
			summe += ki.getGewichtung() * ki.getBewertung();
			div += ki.getGewichtung();
			ret += ki.getBezeichnung() + " (" + rz.getLocale().getString("bewertungsitem.string_gewichtung") +" "+ rz.getLocale().formatNumber(ki.getGewichtung(), OptionFactory.NF_TWO) + ") * " + 
					rz.getLocale().formatNumber(ki.getBewertung(), OptionFactory.NF_TWO) + " " + rz.getLocale().getString("bewertungsitem.string_punkte") + " = " + rz.getLocale().formatNumber(ki.getGewichtung()*ki.getBewertung(), OptionFactory.NF_TWO) + 
					" " +rz.getLocale().getString("bewertungsitem.string_punkte") + "\n";
		}
		ret += "\n" +rz.getLocale().getString("bewertungsitem.string_gesamtsumme") +" :" + rz.getLocale().formatNumber(summe, OptionFactory.NF_TWO) + " / " +rz.getLocale().formatNumber(div, OptionFactory.NF_TWO) + " = " + 
				rz.getLocale().formatNumber(bewertung, OptionFactory.NF_TWO) + " " + rz.getLocale().getString("bewertungsitem.string_punkte") ;
		return ret;
	}
	public JDialog getParentDialog() {
		return parentDialog;
	}

	public void setParentDialog(JDialog parentDialog) {
		this.parentDialog = parentDialog;
	}

	public String getErstelltToString() {
		return df.format(erstellt);
	}
	
	public String getGeaendertToString() {
		return df.format(geaendert);
	}
	
	public String getKontrolleDatumToString() {
		return df.format(kontrolle_datum);
	}
	
	private void initListe() {
		if(id == 0) {
			kategorien = rz.getDatabase().getBewertungen().getDefaultKategorien();
		}else {
			kategorien = new ArrayList<KategorieItem>();
		}
	}
	
	public void okAction() {
		for(KategorieItem ki:kategorien) {
			ki.setBewertung(DBBewertungen.MAX_BEWERTUNG);
			for(int i = 0;i < ki.getOriginalListe().size();i++) {
				ki.getOriginalListe().getItem(i).setBewertung(DBBewertungen.BEWERTUNG_INVALID);
			}
		}
	}
	
	public void clearAction() {
		for(KategorieItem ki:kategorien) {
			ki.setBewertung(DBBewertungen.BEWERTUNG_INVALID);
			for(int i = 0;i < ki.getOriginalListe().size();i++) {
				ki.getOriginalListe().getItem(i).setBewertung(DBBewertungen.BEWERTUNG_INVALID);
			}
		}
	}
	
	public void clearUnterkategorieAction() {
		for(KategorieItem ki:kategorien) {
			for(int i = 0;i < ki.getOriginalListe().size();i++) {
				ki.getOriginalListe().getItem(i).setBewertung(DBBewertungen.BEWERTUNG_INVALID);
			}
		}
	}
	
	public void clearUnterkategorieAction(KategorieItem ki) {
		if(ki != null) {
			for(int i = 0;i < ki.getOriginalListe().size();i++) {
				ki.getOriginalListe().getItem(i).setBewertung(DBBewertungen.BEWERTUNG_INVALID);
			}
		}
	}
	
	
	public boolean isValid() {
		for(KategorieItem ki:kategorien) {
			if(!ki.isValid()) {
				return false;
			}
		}
		return true;
	}
	
	public void rechnen() {
		bewertung = 0;
		double divisor = 0;
		for(KategorieItem ki:kategorien) {
			divisor += ki.getGewichtung();
			if(ki.getBewertung() >= 0) {
				bewertung += ki.getBewertung() * ki.getGewichtung();
			}
		}
		try {
			bewertung = bewertung  / divisor;
		}catch(Exception e) {}
	}
	
	public ArrayList<KategorieItem> getKategorienListe(){
		return kategorien;
	}
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public String getLosnummer() {
		return losnummer;
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	public double getBewertung() {
		return bewertung;
	}

	public void setBewertung(double bewertung) {
		this.bewertung = bewertung;
	}

	public double getDivisor() {
		return divisor;
	}

	public void setDivisor(double divisor) {
		this.divisor = divisor;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}

	public String getErstellt_user() {
		return erstellt_user;
	}

	public void setErstellt_user(String erstellt_user) {
		this.erstellt_user = erstellt_user;
	}

	public Date getGeaendert() {
		return geaendert;
	}

	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}

	public String getGeaendert_user() {
		return geaendert_user;
	}

	public void setGeaendert_user(String geaendert_user) {
		this.geaendert_user = geaendert_user;
	
	}
	
	public String getText() {
		String ret = "";//bwe:
       	BewertungenColorItem  c = rz.getDatabase().getBewertungen().getColorItem();
       	ret += rz.getLocale().getString("bewertungsitem.bewertung_text")
					.replaceAll("%p",c.getValue(bewertung))
					.replaceAll("%c",c.getText(bewertung))
					.replaceAll("%i",String.valueOf(id))
					.replaceAll("%n", String.valueOf(id))
					.replaceAll("%g", rz.getAusgabeFactory().insertGfx("bewertung.png"))
					.replaceAll("%x", rz.getAusgabeFactory().insertGfx("bewertung_delete.png"))
					.replaceAll("%u", getKontrollUser())
					;
		return ret;
	}

	
	public String getLink() {
		String ret = "";//bwe:
       	BewertungenColorItem  c = rz.getDatabase().getBewertungen().getColorItem();
       	ret += rz.getLocale().getString("bewertungsitem.bewertung_valid_link")
					.replaceAll("%p",c.getValue(bewertung))
					.replaceAll("%c",c.getText(bewertung))
					.replaceAll("%i",String.valueOf(id))
					.replaceAll("%n", String.valueOf(id))
					.replaceAll("%g", rz.getAusgabeFactory().insertGfx("bewertung.png"))
					.replaceAll("%x", rz.getAusgabeFactory().insertGfx("bewertung_delete.png"))
					.replaceAll("%u", getKontrollUser())
					;
		return ret;
	}

	public String getKontrolle() {
		return kontrolle;
	}

	public void setKontrolle(String kontrolle) {
		this.kontrolle = kontrolle;
	}

	public Date getKontrolle_datum() {
		return kontrolle_datum;
	}

	public void setKontrolle_datum(Date kontrolle_datum) {
		this.kontrolle_datum = kontrolle_datum;
	}
	
	public String getKontrollUser() {
		String ret = erstellt_user;
		if(!kontrolle.trim().equals("")) {
			ret += " / "+kontrolle;
		}
		return ret;
	}
	
	public String getKontrollText() {
		if(!kontrolle.trim().equals("")) {
			return  rz.getLocale().getString("bewertungseingabe.label_bestaetigung")
					.replaceAll("%u", kontrolle)
					.replaceAll("%d", getKontrolleDatumToString());
		}else {
			return rz.getLocale().getString("bewertungseingabe.label_bestaetigung_null");
		}
	}
}
