package de.lunqual.rzpro.items.bewertungen;

import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class BewertungsKategorieItem {
	RzPro							rz;
	int 							id;
	String							bezeichnung;
	double							gewichtung;
	String							rawListe;
	Date							erstellt;
	String							erstellt_user;
	Date							geaendert;
	String							geaendert_user;
	UnterkategorieListe				liste;
	
	public BewertungsKategorieItem(RzPro rz, int id, String bezeichnung, double gewichtung, String rawListe, Date erstellt, String erstellt_user, Date geaendert, String geaendert_user) {
		this.rz = rz;
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.gewichtung = gewichtung;
		this.rawListe = rawListe;
		this.erstellt = erstellt;
		this.erstellt_user = erstellt_user;
		this.geaendert = geaendert;
		this.geaendert_user = geaendert_user;
	}
	
	
	public void setUnterkategorieListe(UnterkategorieListe liste) {
		this.liste = liste;
	}
	
	public UnterkategorieListe getListe() {
		return liste;
	}
	
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getBezeichnung() {
		return bezeichnung;
	}
	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}
	public double getGewichtung() {
		return gewichtung;
	}
	public void setGewichtung(double gewichtung) {
		this.gewichtung = gewichtung;
	}
	public String getRawListe() {
		return rawListe;
	}
	public void setRawListe(String rawListe) {
		this.rawListe = rawListe;
	}
	public Date getErstellt() {
		return erstellt;
	}
	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}
	public String getErstellt_user() {
		return erstellt_user;
	}
	public void setErstellt_user(String erstellt_user) {
		this.erstellt_user = erstellt_user;
	}
	public Date getGeaendert() {
		return geaendert;
	}
	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}
	public String getGeaendert_user() {
		return geaendert_user;
	}
	public void setGeaendert_user(String geaendert_user) {
		this.geaendert_user = geaendert_user;
	}
	
	public String toString() {
		return rz.getLocale().getString("bewertungen.item.tostring")
				.replaceAll("%b", bezeichnung)
				.replaceAll("%f", rz.getLocale().formatNumber(gewichtung,OptionFactory.NF_TWO));
	}
	
	
	
}
