package de.lunqual.rzpro.items.bewertungen;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

import de.lunqual.rzpro.RzPro;

public class BewertungsListe extends ArrayList<BewertungsShortItem>{
	RzPro					rz;
	Collator 				coll;
	Comparator 				compID;
	Comparator				compBezeichnung;
	Comparator				compLosnummer;
	Comparator				compErstellt;
	Comparator				compGeaendert;
	Comparator				compBewertung;
	
	boolean					reverseID = true;
	boolean					reverseBezeichnung = true;
	boolean					reverseLosnummer = true;
	boolean					reverseErstellt = true;
	boolean					reverseGeaendert = true;
	boolean					reverseBewertung = true;
	
	public BewertungsListe(RzPro rz) {
		this.rz = rz;
		coll = Collator.getInstance(Locale.getDefault());
		compID = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final BewertungsShortItem b1 = (BewertungsShortItem) o1;
				final BewertungsShortItem b2 = (BewertungsShortItem) o2;
				try {
					if(b1.getId() == b2.getId()) {
						r = 0;
					} else {
						if (b1.getId() > b2.getId()) {
							r = -1;
						} else {
							r = 1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		
		compBewertung = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				int r = 0;
				final BewertungsShortItem b1 = (BewertungsShortItem) o1;
				final BewertungsShortItem b2 = (BewertungsShortItem) o2;
				try {
					if(b1.getBewertung() == b2.getBewertung()) {
						r = 0;
					} else {
						if (b1.getBewertung() > b2.getBewertung()) {
							r = -1;
						} else {
							r = 1;
						}
					}
				}catch(Exception e) {}
				return r;
			}
		};
		
		compBezeichnung = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BewertungsShortItem b1 = (BewertungsShortItem) o1;
				final BewertungsShortItem b2 = (BewertungsShortItem) o2;
				return coll.compare(b1.getBezeichnung(), b2.getBezeichnung());
			}
		};
		
		compLosnummer = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BewertungsShortItem b1 = (BewertungsShortItem) o1;
				final BewertungsShortItem b2 = (BewertungsShortItem) o2;
				return coll.compare(b1.getLosnummer(), b2.getLosnummer());
			}
		};
		
		compErstellt = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BewertungsShortItem b1 = (BewertungsShortItem) o1;
				final BewertungsShortItem b2 = (BewertungsShortItem) o2;
				return b1.getErstellt().compareTo(b2.getErstellt());
			}
		};
		
		compGeaendert = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final BewertungsShortItem b1 = (BewertungsShortItem) o1;
				final BewertungsShortItem b2 = (BewertungsShortItem) o2;
				return b1.getGeaendert().compareTo(b2.getGeaendert());
			}
		};
		
		
	}

	public void addItem(BewertungsShortItem bwi) {
		this.add(bwi);
	}
	
	public BewertungsShortItem getItem(int i) {
		return this.get(i);
	}

	public void sortID() {
		if (reverseID) {
			Collections.sort(this, compID);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compID);
		}
		reverseID=!reverseID;
	}
	
	public void sortBewertung() {
		if (reverseID) {
			Collections.sort(this, compBewertung);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBewertung);
		}
		reverseID=!reverseID;
	}

	public void sortBezeichnung() {
		if (reverseBezeichnung) {
			Collections.sort(this, compBezeichnung);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBezeichnung);
		}
		reverseBezeichnung=!reverseBezeichnung;
	}
	

	public void sortLosnummer() {
		if (reverseLosnummer) {
			Collections.sort(this, compLosnummer);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compLosnummer);
		}
		reverseLosnummer=!reverseLosnummer;
	}

	public void sortErstellt() {
		if (reverseErstellt) {
			Collections.sort(this, compErstellt);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compErstellt);
		}
		reverseErstellt=!reverseErstellt;
	}
	
	public void sortGeaendert() {
		if (reverseGeaendert) {
			Collections.sort(this, compGeaendert);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compGeaendert);
		}
		reverseGeaendert=!reverseGeaendert;
	}
	

	
	
}
