package de.lunqual.rzpro.items.bewertungen;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class BewertungsShortItem {
	RzPro								rz;
	int									id;
	String								bezeichnung;
	String								losnummer;
	double								bewertung;
	String								comment;
	Date								erstellt;
	String								erstellt_user;
	Date								geaendert;
	String								geaendert_user;
	SimpleDateFormat					df;
	
	
	public BewertungsShortItem(RzPro rz, int id, String bezeichnung, String losnummer, double bewertung, String comment, Date erstellt, String erstellt_user, Date geaendert, String geaendert_user) {
		this.rz = rz;
		this.id = id;
		this.bezeichnung = bezeichnung;
		this.losnummer = losnummer;
		this.bewertung = bewertung;
		this.comment = comment;
		this.erstellt = erstellt;
		this.erstellt_user = erstellt_user;
		this.geaendert = geaendert;
		this.geaendert_user = geaendert_user;
		df = new SimpleDateFormat(RzPro.DATEFORMAT_HOUR);
	}
	
	public String getErstelltToString() {
		return df.format(erstellt);
	}
	
	public String getGeaendertToString() {
		return df.format(geaendert);
	}
	
	
	public int getId() {
		return id;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public String getLosnummer() {
		return losnummer;
	}

	public double getBewertung() {
		return bewertung;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public String getErstellt_user() {
		return erstellt_user;
	}

	public Date getGeaendert() {
		return geaendert;
	}

	public String getGeaendert_user() {
		return geaendert_user;
	}
}
