/*
 * Created on 07.10.2004
 *
 */
package de.lunqual.rzpro.items.buchung;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;


/**
 * @author labor
 *
 */
public class LosnummerListe extends ArrayList {


	RzPro rz;

    public LosnummerListe(RzPro rz) {
        super();
        this.rz=rz;
    }

    public void addItem(LosnummerItem li) {
        this.add(li);
    }

    public LosnummerItem getItem(int i) {
       return (LosnummerItem)this.get(i);
    }
    @Override
	public String toString() {
        String ret = "";
        for(int i =0;i < this.size();i++) {
            ret += this.getItem(i).getLosnummer() ;
            ret += " ";
        }
        ret = ret.trim();
        return ret;
    }
    
	public String toMhdString() {
        String ret = "";
        for(int i =0;i < this.size();i++) {
            ret += "["+this.getItem(i).getLosnummer() ;
            if(this.getItem(i).getMhd() != 0) {
            	ret += " (" + rz.getLocale().getString("losnummerliste.mhd") + rz.getDatabase().getBuchungen().getMhdString(this.getItem(i).getMhd())+")";
            }
            ret += "] ";
        }
        ret = ret.trim();
        return ret;
    }
	
	public String toTankString() {
		String ret ="";
        for(int i =0;i < this.size();i++) {
            ret += rz.getDatabase().getTank().getTankFromLosnummer(getItem(i).getLosnummer().trim()) + ",";
        }
        if(ret.endsWith(","))ret = ret.substring(0, ret.length()-1);
		return ret.trim();
	}
}
