package de.lunqual.rzpro.items.buchung;

/*
 * Created on 04.11.2008
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */


import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import de.lunqual.rzpro.fenster.buchungsfenster.HerstellungsFenster;
import de.lunqual.rzpro.items.lager.LagerListe;
import de.lunqual.rzpro.RzPro;
/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class StatistikRezepturListe extends ArrayList{

	RzPro rz;
	int mode;
	Date von;
	Date bis;
	String bezeichnung;
	String invers;
	String losnummer;
	LagerListe lager;
    /**
     *
     */
    public StatistikRezepturListe(RzPro rz) {
        super();
        this.rz=rz;
    }



    public void addItem(StatistikRezepturItem sri) {
        this.add(sri);
    }

    public StatistikRezepturItem getItem(int i) {
        return (StatistikRezepturItem)this.get(i);
    }



	public int getMode() {
		return mode;
	}



	public void setMode(int mode) {
		this.mode = mode;
	}



	public Date getVon() {
		return von;
	}



	public void setVon(Date von) {
		this.von = von;
	}



	public Date getBis() {
		return bis;
	}



	public void setBis(Date bis) {
		this.bis = bis;
	}



	public String getBezeichnung() {
		return bezeichnung;
	}



	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}



	public String getInvers() {
		return invers;
	}



	public void setInvers(String invers) {
		this.invers = invers;
	}



	public String getLosnummer() {
		return losnummer;
	}



	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}



	public LagerListe getLager() {
		return lager;
	}



	public void setLager(LagerListe lager) {
		this.lager = lager;
	}


	/**
	 * gibt den String für die X-Achse zurück,
	 * wird erzeugt aus der der zugrundeliegenden Auswahl
	 * @param mode
	 * @param von
	 * @param bis
	 * @param inhalt
	 * @param losnummer
	 * @return String mit der Auswahl
	 */
	public String getAuswahlString() {
		final SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
		String strVon="-";
		String strBis="-";
		String ret = rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.0");
		switch(getMode()) {
			case HerstellungsFenster.AUSWAHL_ALLE: ret += rz.getLocale().getString("StatistikRezepturFenster.auswahl_alle") + " ";
				break;
			case HerstellungsFenster.AUSWAHL_ERLEDIGT: ret += rz.getLocale().getString("StatistikRezepturFenster.auswahl_erledigt") + " ";
				break;
			case HerstellungsFenster.AUSWAHL_UNERLEDIGT: ret += rz.getLocale().getString("StatistikRezepturFenster.auswahl_unerledigt") + " ";
				break;
		}
		 ret += rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.1") +" ";
		if((getVon() != null) && (getBis() != null)) {
			strVon = df.format(getVon());
			strBis = df.format(getBis());
		}
		ret += strVon + " " +  rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.2") + " " + strBis + " " + rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.3") +" ";
		if(getBezeichnung() != null ) {
			if(getBezeichnung().trim().equals("")){
				ret += "- ";
			} else {
				ret += getBezeichnung() + " " ;
			}
		} else {
			ret += "- ";
		}
		ret += rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.4") + " " ;
		if(getLosnummer() != null ) {
			if(getLosnummer().trim().equals("")){
				ret += "- ";
			} else {
				ret += getLosnummer() + " ";
			}
		} else {
			ret += "- ";
		}
		ret += rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.5")+ " ";
		if(getLager() != null ) {
			ret += getLager().toPlainString() + " ";
		} else {
			ret += rz.getLocale().getString("lager.liste_alle") + " ";
		}

		ret += rz.getLocale().getString("StatistikRezepturFenster.string_auswahl.6");
		if(getInvers() != null ) {
			if(getInvers().trim().equals("")){
				ret += "- ";
			} else {
				ret += getInvers() + " ";
			}
		} else {
			ret += "- ";
		}
		return ret ;
	}

}
