/*
 * Created on 16.09.2004
 *
 */
package de.lunqual.rzpro.items.container;

import java.util.Date;
import de.lunqual.rzpro.RzPro;
/**
 * @author labor
 *
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class ContainerItem {

	RzPro			rz;
    int				id;
    int 				out;
    String			name;
    int				nummer;
    double			tara;
    String 			comment;
    Date				erstellt;
    Date				geaendert;
    String			user_1;
    String			user_2;
    String			ordner;
    String 			ordnerBezeichnung;
    String			letzteFuellung;
    String			letzteAdresse;
    Date			letztesDatum;

    public ContainerItem(RzPro rz,int id,int out,String ordner,String ordnerBezeichnung,String name,double tara,String comment,Date erstellt,Date geaendert,String user_1,String user_2,String adresse,String fuellung,Date letztesDatum) {
        this.rz = rz;
    	this.id=id;
    	this.out=out;
        this.ordner=ordner;
        setName(name);
        this.tara=tara;
        this.comment=comment;
        this.erstellt=erstellt;
        this.geaendert=geaendert;
        this.user_1=user_1;
        this.user_2=user_2;
        this.ordnerBezeichnung=ordnerBezeichnung;
        this.letzteFuellung=fuellung;
        this.letzteAdresse=adresse;
        this.letztesDatum=letztesDatum;
    }

    
    
    public String getComment() {
        return comment;
    }
    public void setComment(String comment) {
        this.comment = comment;
    }
    public Date getErstellt() {
        return erstellt;
    }
    public void setErstellt(Date erstellt) {
        this.erstellt = erstellt;
    }
    public Date getGeaendert() {
        return geaendert;
    }
    public void setGeaendert(Date geaendert) {
        this.geaendert = geaendert;
    }
    public int getID() {
        return id;
    }
    public void setID(int id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
        final String n = name.replaceAll("\\s*","").replaceAll("\\D","");
        try {
        	nummer = Integer.parseInt(n);
        } catch (final NumberFormatException ne) {
        	nummer = 0;
        }
    }
    public double getTara() {
        return tara;
    }
    public void setTara(double tara) {
        this.tara = tara;
    }
    public String getUser_1() {
        return user_1;
    }
    public void setUser_1(String user_1) {
        this.user_1 = user_1;
    }
    public String getUser_2() {
        return user_2;
    }
    public void setUser_2(String user_2) {
        this.user_2 = user_2;
    }

    public String getOrdner() {
        return ordner;
    }
    public void setOrdner(String ordner) {
        this.ordner = ordner;
    }
    @Override
	public String toString() {
        return name;
    }

    public int getNummer() {
    	return nummer;
    }
    public String getOrdnerBezeichnung() {
        return ordnerBezeichnung;
    }
    public void setOrdnerBezeichnung(String ordnerBezeichnung) {
        this.ordnerBezeichnung = ordnerBezeichnung;
    }


	public String getLetzteFuellung() {
		return letzteFuellung;
	}


	public void setLetzteFuellung(String letzteFuellung) {
		this.letzteFuellung = letzteFuellung;
	}


	public String getLetzteAdresse() {
		return letzteAdresse;
	}


	public void setLetzteAdresse(String letzteAdresse) {
		this.letzteAdresse = letzteAdresse;
	}


	public Date getLetztesDatum() {
		return letztesDatum;
	}


	public void setLetztesDatum(Date letztesDatum) {
		this.letztesDatum = letztesDatum;
	}


	public int getOut() {
		return out;
	}


	public void setOut(int out) {
		this.out = out;
	}


}
