/*
 * Created on 16.09.2004
 */
package de.lunqual.rzpro.items.container;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;



/**
 * @author labor
 */
public class ContainerListe extends ArrayList {

	Collator coll;
	Comparator compOut;
	Comparator compNummer;
	Comparator compAdresse;
	Comparator compInhalt;
	Comparator compDatum;
	Comparator compTara;
	Comparator compBemerkungen;
	Comparator	compOrdner;
	
	boolean reverseOut=false;
	boolean reverseNummer = false;
	boolean reverseAdresse = false;
	boolean reverseInhalt = false;
	boolean reverseDatum = false;
	boolean reverseTara = false;
	boolean reverseBemerkungen = false;
	boolean reverseOrdner = false;
	
	HashMap liste;
	
    /**
     *
     */
    public ContainerListe() {
        super();
        liste = new HashMap();
		coll = Collator.getInstance(Locale.getDefault());
		compOut = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				int r = 0;
				if (b1.getOut() >= b2.getOut()) {
					r = -1;
				} else {
					if (b1.getOut() < b2.getOut()) {
						r = 1;
					}
				}
				return r;
			}
		};
		compNummer = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				final String s1 = b1.getName()==null?"":b1.getName();
				final String s2 = b2.getName()==null?"":b2.getName();
				if(b1.getName() != null && b2.getName() != null) {
					return coll.compare(s1, s2);
				} else {
					return 0;
				}
			}
		};
		compAdresse = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				final String s1 = b1.getLetzteAdresse()==null?"":b1.getLetzteAdresse();
				final String s2 = b2.getLetzteAdresse()==null?"":b2.getLetzteAdresse();
				return coll.compare(s1,s2);
			}
		};
		compInhalt = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				final String s1 = b1.getLetzteFuellung()==null?"":b1.getLetzteFuellung();
				final String s2 = b2.getLetzteFuellung()==null?"":b2.getLetzteFuellung();
				return coll.compare(s1,s2);
			}
		};
		compDatum = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				Date neu = new Date();
				Date eins = b1.getLetztesDatum() == null?neu:b1.getLetztesDatum();
				Date zwei = b2.getLetztesDatum() == null?neu:b2.getLetztesDatum();
				return eins.compareTo(zwei);
			}
		};
		compTara = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				int r = 0;
				if (b1.getTara() >= b2.getTara()) {
					r = -1;
				} else {
					if (b1.getTara() < b2.getTara()) {
						r = 1;
					}
				}
				return r;
			}
		};
		compBemerkungen = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				final String s1 = b1.getComment()==null?"":b1.getComment();
				final String s2 = b2.getComment()==null?"":b2.getComment();
				return coll.compare(s1,s2);
			}
		};
		compOrdner = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final ContainerItem b1 = (ContainerItem) o1;
				final ContainerItem b2 = (ContainerItem) o2;
				final String s1 = b1.getOrdnerBezeichnung()==null?"":b1.getOrdnerBezeichnung();
				final String s2 = b2.getOrdnerBezeichnung()==null?"":b2.getOrdnerBezeichnung();
				return coll.compare(s1,s2);
			}
		};
    }
    /** einen Ordner hinzufügen
     *
     * @param bi  behälterordneritem
     */
    public void addItem(ContainerItem ci) {
        this.add(ci);
        liste.put(ci.getName(),ci);
    }

    /** einen ordner holen
     *
     */
    public ContainerItem getItem(int id) {
        for(int i = 0;i < this.size();i++) {
            if(((ContainerOrdnerItem)this.get(i)).getID() == id) {
                return (ContainerItem)this.get(i);
            }
        }
         return null;
    }
    
    public ContainerItem hasNummer(String n) {
    	if (liste.containsKey(n)) {
    		return (ContainerItem)liste.get(n);
    	}
    	return null;
    }
    /**
     * ein Item nicht nach id, sondern nach der Reihenfolge in der Liste holen
     * @param n  Reihenfolge
     * @return ContainerItem
     */
    public ContainerItem getItemOrder(int n) {
    	return (ContainerItem)this.get(n);
    }
    
	public void sortout() {
		if (reverseOut) {
			Collections.sort(this, compOut);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compOut);
		}
		reverseOut=reverseOut?false:true;
	}
    
	public void sortNummer() {
		if (reverseNummer) {
			Collections.sort(this, compNummer);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compNummer);
		}
		reverseNummer=reverseNummer?false:true;
	}
	
	public void sortAdresse() {
		if (reverseAdresse) {
			Collections.sort(this, compAdresse);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compAdresse);
		}
		reverseAdresse=reverseAdresse?false:true;
	}
	
	public void sortInhalt() {
		if (reverseInhalt) {
			Collections.sort(this, compInhalt);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compInhalt);
		}
		reverseInhalt=reverseInhalt?false:true;
	}
	
	
	public void sortDatum() {
		if (reverseDatum) {
			Collections.sort(this, compDatum);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compDatum);
		}
		reverseDatum=reverseDatum?false:true;
	}
	public void sortTara() {
		if (reverseTara) {
			Collections.sort(this, compTara);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compTara);
		}
		reverseTara=reverseTara?false:true;
	}
	public void sortBemerkungen() {
		if (reverseBemerkungen) {
			Collections.sort(this, compBemerkungen);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compBemerkungen);
		}
		reverseBemerkungen=reverseBemerkungen?false:true;
	}
	public void sortOrdner() {
		if (reverseOrdner) {
			Collections.sort(this, compOrdner);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compOrdner);
		}
		reverseOrdner=reverseOrdner?false:true;
	}
}