/*
 *  Copyright (C) 2004/2005 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.deklarationen;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class DeklarationsItem {

	private int		id;
	String				name;
	String				deklaration;
	String				user_1;
	String				user_2;
	Date					erstellt;
	Date					geaendert;

	public DeklarationsItem(int id, String name, String deklaration, String user_1, String user_2, Date erstellt, Date geaendert) {
		this.id = id;
		this.name = name;
		this.deklaration = deklaration;
		this.user_1 = user_1;
		this.user_2 = user_2;
		this.erstellt = erstellt;
		this.geaendert = geaendert;
	}

	public DeklarationsItem copyItem() {
		return new DeklarationsItem(id,name,deklaration,user_1,user_2,erstellt,geaendert);
	}

	public String getDeklaration() {
		return deklaration;
	}

	public void setDeklaration(String deklaration) {
		this.deklaration = deklaration;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}

	public Date getGeaendert() {
		return geaendert;
	}

	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getUser_1() {
		return user_1;
	}

	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}

	public String getUser_2() {
		return user_2;
	}

	public void setUser_2(String user_2) {
		this.user_2 = user_2;
	}

    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }

	@Override
	public String toString() {
		return name;
	}

}
