package de.lunqual.rzpro.items.documents;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;


public class DocumentHeaderListe extends ArrayList<DocumentHeaderItem> {
	
	Collator 	coll;
	Comparator 	compName;
	Comparator 	compFileName;
	Comparator 	compErstellt;
	Comparator 	compGeaendert;
	Date 		nullDatum;
	boolean 	reverseName=true;
	boolean 	reverseFileName=true;
	boolean 	reverseErstellt=true;
	boolean 	reverseGeaendert=true;
	
	public DocumentHeaderListe() {
		super();
    	nullDatum = new Date();
    	nullDatum.setTime(0);
		coll = Collator.getInstance(Locale.getDefault());
		compName = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DocumentHeaderItem b1 = (DocumentHeaderItem) o1;
				final DocumentHeaderItem b2 = (DocumentHeaderItem) o2;
				// alphabetische Ordnung
				return coll.compare(b1.getName(), b2.getName());
			}
		};
		compFileName = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DocumentHeaderItem b1 = (DocumentHeaderItem) o1;
				final DocumentHeaderItem b2 = (DocumentHeaderItem) o2;
				// alphabetische Ordnung
				return coll.compare(b1.getFilename(), b2.getFilename());
			}
		};
		compErstellt = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DocumentHeaderItem b1 = (DocumentHeaderItem) o1;
				final DocumentHeaderItem b2 = (DocumentHeaderItem) o2;
				Date b1d = b1.getErstellt() == null?nullDatum:b1.getErstellt();
				Date b2d = b2.getErstellt() == null?nullDatum:b2.getErstellt();
				return b1d.compareTo(b2d);
			}
		};
		compGeaendert = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DocumentHeaderItem b1 = (DocumentHeaderItem) o1;
				final DocumentHeaderItem b2 = (DocumentHeaderItem) o2;
				Date b1d = b1.getGeaendert() == null?nullDatum:b1.getGeaendert();
				Date b2d = b2.getGeaendert() == null?nullDatum:b2.getGeaendert();
				return b1d.compareTo(b2d);
			}
		};
		
	}
	public DocumentHeaderItem geItem(int i) {
		return this.get(i);
	}
	
	public void sortName() {
		if (reverseName) {
			Collections.sort(this, compName);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compName);
		}
		reverseName=!reverseName;
	}

	public void sortFileName() {
		if (reverseName) {
			Collections.sort(this, compFileName);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compFileName);
		}
		reverseFileName=!reverseFileName;
	}
	public void sortErstellt() {
		if (reverseErstellt) {
			Collections.sort(this, compErstellt);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compErstellt);
		}
		reverseErstellt=!reverseErstellt;
	}
	public void sortGeaendert() {
		if (reverseGeaendert) {
			Collections.sort(this, compGeaendert);
			Collections.reverse(this);
		} else {
			Collections.sort(this, compGeaendert);
		}
		reverseGeaendert=!reverseGeaendert;
	}
	public DocumentHeaderItem getItem(int i) {
		return this.get(i);
	}
}
