package de.lunqual.rzpro.items.documents;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DocumentItem {

	int						id;
	int						rezeptur;
	String					name;
	String					filename;
	String					bemerkungen;
	byte[]					daten;
	Date						erstellt;
	Date						geaendert;
	String					user1;
	String					user2;
	int						typ;
	int						pages;
	int						zoom;
	SimpleDateFormat df;

	


	public DocumentItem(int id,int typ, int rezeptur, String name, String filename, String bemerkungen, byte[] daten, Date erstellt, Date geaendert, String user1, String user2,int pages,int zoom) {
		this.id = id;
		this.typ = typ;
		this.rezeptur = rezeptur;
		this.name = name;
		this.filename = filename;
		this.bemerkungen = bemerkungen;
		this.daten = daten;
		this.erstellt = erstellt;
		this.geaendert = geaendert;
		this.user1 = user1;
		this.user2 = user2;
		this.pages = pages;
		this.zoom = zoom;
		df = new SimpleDateFormat("EEEE dd.MM YYYY");
	}

	
	
	public int getZoom() {
		return zoom;
	}



	public void setZoom(int zoom) {
		this.zoom = zoom;
	}



	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getRezeptur() {
		return rezeptur;
	}

	public void setRezeptur(int rezeptur) {
		this.rezeptur = rezeptur;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}

	public String getBemerkungen() {
		return bemerkungen;
	}

	public void setBemerkungen(String bemerkungen) {
		this.bemerkungen = bemerkungen;
	}

	public byte[] getDaten() {
		return daten;
	}

	public void setDaten(byte[] daten) {
		this.daten = daten;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}

	public Date getGeaendert() {
		return geaendert;
	}

	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}

	public String getUser1() {
		return user1;
	}

	public void setUser1(String user1) {
		this.user1 = user1;
	}

	public String getUser2() {
		return user2;
	}

	public void setUser2(String user2) {
		this.user2 = user2;
	}
	
	public String toString() {
		return name + " ("+df.format(getErstellt())+")";
	}

	public int getTyp() {
		return typ;
	}

	public void setTyp(int typ) {
		this.typ = typ;
	}

	public int getSeiten() {
		return pages;
	}
	

}
