/*
 * Created on 08.10.2004
 *
 */
package de.lunqual.rzpro.items.einheiten;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class MengenItem {

    RzPro					rz;
    EinheitsItem			einheit;
    double					staerke;
    double					litergewicht;
    double					value;
    double					liter;
    double					kg;
    double					la;

    public MengenItem(RzPro rz,double value,double staerke,double litergewicht,int einheit,boolean grundeinheit) {
        this.rz=rz;
        this.value=value;
        this.staerke=staerke;
        this.litergewicht=litergewicht;
        this.einheit = (grundeinheit== true) ? rz.getDatabase().getEinheiten().getGrundeinheit(einheit) :rz.getDatabase().getEinheiten().getEinheit(String.valueOf(einheit));
        rechnen();
    }

    public MengenItem(RzPro rz,double value,double staerke,double litergewicht,EinheitsItem einheit) {
        this.rz=rz;
        this.value=value;
        this.staerke=staerke;
        this.litergewicht=litergewicht;
        this.einheit=einheit;
        rechnen();
    }

    public void rechnen() {
        liter = rz.getDatabase().getEinheiten().convert(value,staerke, litergewicht,einheit, rz.getDatabase().getEinheiten().getEinheit("liter"));
        kg = rz.getDatabase().getEinheiten().convert(value,staerke,litergewicht,einheit, rz.getDatabase().getEinheiten().getEinheit("kg"));
        la = rz.getDatabase().getEinheiten().convert(value,staerke,litergewicht,einheit, rz.getDatabase().getEinheiten().getEinheit("la"));
    }


    public EinheitsItem getEinheit() {
        return einheit;
    }
    public void setEinheit(EinheitsItem einheit) {
        this.einheit = einheit;
        rechnen();
    }
    public double getKg() {
        return kg;
    }
    public double getLa() {
        return la;
    }
    public double getLiter() {
        return liter;
    }
    public double getLitergewicht() {
        return litergewicht;
    }
    public void setLitergewicht(double litergewicht) {
        this.litergewicht = litergewicht;
        rechnen();
    }
    public double getStaerke() {
        return staerke;
    }
    public void setStaerke(double staerke) {
        this.staerke = staerke;
        rechnen();
    }
    public double getValue() {
        return value;
    }
    public void setValue(double value) {
        this.value = value;
        rechnen();
    }
}
