/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.ergebnis;

import de.lunqual.rzpro.RzPro;

public class DependencyItem {

	public static final int STATUS_NONE=0;
	public static final int STATUS_OK = 1;

	RzPro		 	rz;
	int 				id;
	String 			name;
	int				typ;
	int 				status;
	String			ok_string = "OK";
	String			not_ok= "---";
	String			lager;
	String 			steuer_lager;
	String			steuer_artikel;
	int 			order;

	public DependencyItem(RzPro rz,int id,String name,int typ,String ok_string,String not_ok,String lager,String steuer_lager,String steuer_artikel,int order) {
		this.rz = rz;
		this.id=id;
		this.name=name;
		status=STATUS_NONE;
		this.ok_string = ok_string;
		this.not_ok=not_ok;
		this.typ = typ;
		this.lager = lager;
		this.steuer_lager = steuer_lager;
		this.steuer_artikel = steuer_artikel;
		this.order=order;
	}

	
	public int getOrder() {
		return order;
	}


	public String getOk_string() {
		return ok_string;
	}


	public void setOk_string(String ok_string) {
		this.ok_string = ok_string;
	}


	public String getNot_ok() {
		return not_ok;
	}


	public void setNot_ok(String not_ok) {
		this.not_ok = not_ok;
	}


	public String getLager() {
		return lager;
	}



	public void setLager(String lager) {
		this.lager = lager;
	}



	public String getSteuer_lager() {
		return steuer_lager;
	}



	public void setSteuer_lager(String steuer_lager) {
		this.steuer_lager = steuer_lager;
	}



	public String getSteuer_artikel() {
		return steuer_artikel;
	}



	public void setSteuer_artikel(String steuer_artikel) {
		this.steuer_artikel = steuer_artikel;
	}



	public static int getStatusNone() {
		return STATUS_NONE;
	}



	public static int getStatusOk() {
		return STATUS_OK;
	}



	public void setTyp(int typ) {
		this.typ = typ;
	}



	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public int getTyp() {
		return typ;
	}
	
	

	@Override
	public String toString() {
		return  "<html>" + (status == STATUS_NONE? "<font color=\"red\"><b>" + not_ok +"</b></font>" :"<font color=\"green\"><b>" + ok_string +"</b></font>") +"&nbsp;"  + name + 
				"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + 
				rz.getLocale().getString("dependency.liste")
					.replaceAll("%g", lager)
					.replaceAll("%l", steuer_lager)
					.replaceAll("%a", steuer_artikel) +
				"</html>";
	}
}
