/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.ergebnis;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.database.ItemNotFoundException;

public class DependencyListe extends ArrayList {

	RzPro 			rz;
	int				rezepturID;
	String			titel;
	
	Collator coll;
	Comparator compAlpha;
	Comparator compLager;
	Comparator compSteuerLager;
	Comparator compSteuerArtikel;
	Comparator compOrder;
	
	public DependencyListe(RzPro rz,int rezepturID) {
		super();
		this.rz = rz;
		this.rezepturID = rezepturID;
		this.titel = "";
		try {
			this.titel = rz.getDatabase().getRezeptur().dbGetRezepturName(rezepturID);
		} catch (ItemNotFoundException e) {
			e.printStackTrace();
		}
		coll = Collator.getInstance(Locale.getDefault());
		compAlpha = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DependencyItem b1 = (DependencyItem) o1;
				final DependencyItem b2 = (DependencyItem) o2;
				return coll.compare(b1.getName(), b2.getName());
			}
		};	
		compLager = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DependencyItem b1 = (DependencyItem) o1;
				final DependencyItem b2 = (DependencyItem) o2;
				return coll.compare(b1.getLager(), b2.getLager());
			}
		};	
		compSteuerLager = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DependencyItem b1 = (DependencyItem) o1;
				final DependencyItem b2 = (DependencyItem) o2;
				return coll.compare(b1.getSteuer_lager(), b2.getSteuer_lager());
			}
		};	
		
		compSteuerArtikel = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DependencyItem b1 = (DependencyItem) o1;
				final DependencyItem b2 = (DependencyItem) o2;
				return coll.compare(b1.getSteuer_artikel(), b2.getSteuer_artikel());
			}
		};
		
		compOrder = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final DependencyItem b1 = (DependencyItem) o1;
				final DependencyItem b2 = (DependencyItem) o2;
				return Integer.compare(b1.getOrder(), b2.getOrder());
			}
		};	
		
	}

	public void Sort(String sort) {
		if(sort.equals(rz.getLocale().getString("dependency.sort.alpha"))) {
			SortAlpha();
		} else {
			if(sort.equals(rz.getLocale().getString("dependency.sort.lager"))) {
				SortLager();
			} else if(sort.equals(rz.getLocale().getString("dependency.sort.steuer_lager"))) {
				SortSteuerLager();
			} else if(sort.equals(rz.getLocale().getString("dependency.sort.steuer_artikel"))) {
				SortSteuerArtikel();
			} else if(sort.equals(rz.getLocale().getString("dependency.sort.order"))) {
				SortOrder();
			}
		}
	}
	
	public DependencyListe clone() {
		DependencyListe ret = new DependencyListe(rz,rezepturID);
		for(int i= 0;i < this.size();i++){
			DependencyItem di = this.getItem(i);
			ret.addItem(new DependencyItem(
					rz,
					di.getId(),
					di.getName(),
					di.getTyp(),
					di.getOk_string(),
					di.getNot_ok(),
					di.getLager(),
					di.getSteuer_lager(),
					di.getSteuer_artikel(),
					di.getOrder()
					));
			
		}
		return ret;
	}
	public void SortAlpha() {
		Collections.sort(this, compAlpha);
	}
	
	public void SortLager() {
		Collections.sort(this, compLager);
	}
	
	public void SortSteuerLager() {
		Collections.sort(this, compSteuerLager);
	}
	
	public void SortSteuerArtikel() {
		Collections.sort(this, compSteuerArtikel);
	}
	public DependencyItem getItem(int i) {
		return (DependencyItem)this.get(i);
	}

	public void SortOrder() {
		Collections.sort(this, compOrder);
	}
	public void addItem(DependencyItem di) {
		this.add(di);
	}
	
	public String getTitel() {
		return titel;
	}
	
	
}
