/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * db ist die zentrale Schnittstelle zur Datenbank. Hier wird die Verbindung
 * zur Datenbank aufgebaut, abgebaut und alle Datentransfers laufen �ber
 * diese Klasse. Keine andere Klasse im Programm nimmt eigenst�ndige
 * Verbindungen zur Datenbank auf
 *
 */
package de.lunqual.rzpro.items.etiketten;

import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.log.LogFactory;

/**
 * @author lunqual
 *
 */
public class EtikettenBogenItem {

	RzPro					rz;
	int						id;
	String					name;
	String					picture;
	int						columns;
	int 						rows;
	int 						anzahl;
	Image					image;
	double					height;
	double					width;
	int						report;

	public EtikettenBogenItem(
		RzPro rz,
		int id,
		String name,
		String picture,
		int     columns,
		int 	 rows,
		double width,
		double height,
		int report
		) {
		this.rz = rz;
		this.id=id;
		this.name = name;
		this.picture = picture;
		this.columns=columns;
		this.rows = rows;
		this.height=height;
		this.width=width;
		this.report = report;

		anzahl=columns * rows;

		if(!picture.equals("")) {
			try {
		        final URL url = this.getClass().getResource(rz.getOptionFactory().getOption("report.basedir")+picture);
		         if ( url  != null ) {
		           image = Toolkit.getDefaultToolkit().getImage(url);
		         }
			} catch(final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN,"EtikettenBogenItem.getURL:" + picture + ":", e.getLocalizedMessage());
			}
		}
	}

	public int getAnzahl() {
		return anzahl;
	}

	public int getColumns() {
		return columns;
	}

	public String getName() {
		return name;
	}
	public String getPicture() {
		return picture;
	}
	public int getRows() {
		return rows;
	}
	@Override
	public String toString() {
		return name;
	}
	public Image getImage() {
		return image;
	}

    public int getId() {
        return id;
    }

    public double getHeight() {
        return height;
    }
    public double getWidth() {
        return width;
    }

    public int getReport() {
        return report;
    }
}
