/*
 *  Copyright (C) Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.etiketten;
import java.awt.Image;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.barcodes.Strichcode;

/**
 */
public class EtikettenItem {
	public static final int		ETIKETTENZEILEN 	= 5;

	String[]								zeilen;
	String								losnummer;
	Image								image;
	boolean								emptyLabel;
	RzPro                                rz;
    int                                    maxCount;
    String                                extChar;
    String								  ean;
    int										rezepturID;

    public static final String  EXTENSION_CHAR=".";
    public static final int      MAX_EXTENSION=4;

	public EtikettenItem(RzPro r) {
        rz = r;
        maxCount = rz.getOptionFactory().getOption("code-extension.count",MAX_EXTENSION);
        extChar = rz.getOptionFactory().getOption("code-extension.char");
        if(extChar.equals("")) {
			extChar = EXTENSION_CHAR;
		}

		zeilen =  new String[ETIKETTENZEILEN];
		for(int i =0;i < ETIKETTENZEILEN;i++) {
			zeilen[i] = null;
		}
		this.emptyLabel=false;
		this.losnummer= null;
		this.image=null;
		this.ean = null;
		this.rezepturID = 0;
	}
	
	public EtikettenItem(RzPro r,String[] zeilen,String losnummer) {
        rz = r;
        maxCount = rz.getOptionFactory().getOption("code-extension.count",MAX_EXTENSION);
        extChar = rz.getOptionFactory().getOption("code-extension.char");
        if(extChar.equals("")) {
			extChar = EXTENSION_CHAR;
		}

		this.zeilen =  new String[ETIKETTENZEILEN];
		for(int i =0;i < ETIKETTENZEILEN;i++) {
			this.zeilen[i] = zeilen[i] == null?"":zeilen[i];
		}
		this.emptyLabel=false;
		this.losnummer= losnummer;
		this.image=null;
		this.ean = null;
		this.rezepturID = 0;
	}
	

	public int getRezepturID() {
		return rezepturID;
	}

	public void setRezepturID(int rezepturID) {
		this.rezepturID = rezepturID;
	}

	private int safeValue(int n) {
		int ret = n;
		if(ret < 0) {
			ret=0;
		} else if(ret > (ETIKETTENZEILEN -1)){
			ret = (ETIKETTENZEILEN -1);
		}
		return ret;
	}

	public String getZeile(int n) {
		return zeilen[safeValue(n)];
	}

	public void setZeile(int n,String z) {
		zeilen[safeValue(n)] = z;
	}
	public void setLosnummer(String losnummer) {
		this.losnummer=losnummer;
	}

    /**
     *
     * @return liefert den Barcode (Code 128 B) der Losnummer
     */
    public Image getCode128() {
    	Image img = null;
        if(losnummer != null && !losnummer.equals("")) {
        	Strichcode s = new Strichcode();
        	try {
        		if(ean != null && !ean.equals("")) {
        			img = s.getCode128(rz,ean+losnummer);
        		} else {
        			img = s.getCode128(rz,losnummer);
        		}
        	}
				catch (Exception e) {
				e.printStackTrace();
        	}
        } else {
            return null;
        }
        return img;
    }

      
    public String getEan() {
		return ean;
	}

	public void setEan(String ean) {
		this.ean = ean;
	}
	public String getLosnummerSingle() {
		return losnummer;
	}
	public  String getLosnummer() {
		String ret ="";
		if(ean != null && !ean.equals("")) {
			ret = ean+losnummer;
		} else {
			ret = losnummer;
		}
		return ret;
    }

    public void setImage(Image image) {
        this.image = image;
    }
    public Image getImage() {
        return image;
    }

    public void setEmptyLabel(boolean what) {
    	this.emptyLabel = what;
    }

    public boolean isEmptyLabel() {
    	return emptyLabel;
    }

	@Override
	public String toString() {
		String ret = "<html><center>";
		for(int i = 0;i < ETIKETTENZEILEN;i++) {
			if(i == 0) {
				ret += "<b>" + zeilen[i] +  "</b><br>";
			} else {
				ret += zeilen[i] + "<br>";
			}
		}
		return ret + "</center></html>";
	}

	public boolean isEmpty() {
	    boolean ret = true;
	    for(int i =0;i < ETIKETTENZEILEN;i++) {
	        if(getZeile(i) != null) {
	            ret = false;
	            break;
	        }
	    }
	    return ret;
	}

}
