/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.fenster;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import javax.swing.SwingUtilities;

/**
 * repräsentiert ein Fenster in der Fensterliste.
 * Diese wird von RzPro verwaltet
 * @author  administrator
 */
public class FensterItem {

    JRzFrame      	fenster;
    int				typ;
    boolean 	    visible=false;
    String 			user;

    /** Creates a new instance of FensterItem */
    public FensterItem(JRzFrame f,int typ,String user) {
        fenster = f;
        this.typ = typ;
        this.user=user;
    }
    
    
    public String getUser() {
		return user;
	}


	public void setUser(String user) {
		this.user = user;
	}


	/** den typ zurückgeben
     *
     * @return int typ des Fensters
     */
    public int getTyp() {
    	return typ;
    }

    /** das Fenster zurückgeben
     *
     * @return JRzFrame das Fenster
     */
    public JRzFrame getFrame(){
        return fenster;
    }

    /** das Fenster schliessen und den status vor dem schliessen
     * festhalten
     */
    public void closeFenster(){
        //visible = fenster.isVisible();
        //if (visible) {
			fenster.setVisible(false);
		//}
    }

    /** das Fenster öffnen, wenn vorher geschlossen war
     *
     */
    public void openFenster(){
    	SwingUtilities.updateComponentTreeUI(fenster);
        if (!fenster.isVisible()){
            //if (visible){
            	fenster.getRz().getFensterFactory().setLocation(fenster,FensterFactory.POSITION_SIZE);
        		fenster.getRz().getFontFactory().setFrameFonts(fenster);
                fenster.setVisible(true);
            //}
        }
        fenster.getContentPane().invalidate();
        fenster.getContentPane().repaint();
    }
}
