/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

package de.lunqual.rzpro.items.fenster;
import java.util.ArrayList;

import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fenster.JRzFrame;
import de.lunqual.rzpro.fenster.Stammbaumfenster.StammbaumFenster;
import de.lunqual.rzpro.fenster.about.AboutFenster;
import de.lunqual.rzpro.fenster.acidfenster.AcidEingabe;
import de.lunqual.rzpro.fenster.acidfenster.AcidListenFenster;
import de.lunqual.rzpro.fenster.acidfenster.AcidRechner;
import de.lunqual.rzpro.fenster.adressenfenster.AdressAuswahl;
import de.lunqual.rzpro.fenster.adressenfenster.AdressAuswahlEinfach;
import de.lunqual.rzpro.fenster.adressenfenster.AdressEingabe;
import de.lunqual.rzpro.fenster.adressenfenster.AdressenFenster;
import de.lunqual.rzpro.fenster.anmeldefenster.AnmeldeEinstellungen;
import de.lunqual.rzpro.fenster.anmeldefenster.AnmeldeFenster;
import de.lunqual.rzpro.fenster.auftragsfenster.AuftragsFenster;
import de.lunqual.rzpro.fenster.auftragsfenster.AuftragslistenFenster;
import de.lunqual.rzpro.fenster.ausbeutefenster.Ausbeute;
import de.lunqual.rzpro.fenster.ausbeutefenster.AusbeuteEingabe;
import de.lunqual.rzpro.fenster.auswahlfenster.AbfrageFenster;
import de.lunqual.rzpro.fenster.auswahlfenster.AbgangsClientAuswahl;
import de.lunqual.rzpro.fenster.auswahlfenster.Auswahl;
import de.lunqual.rzpro.fenster.auswahlfenster.DependencyFenster;
import de.lunqual.rzpro.fenster.auswahlfenster.Vergleichsfenster;
import de.lunqual.rzpro.fenster.auswahlfenster.ZugangsClientAuswahl;
import de.lunqual.rzpro.fenster.bestellungsfenster.BestellungsFenster;
import de.lunqual.rzpro.fenster.bestellungsfenster.BestellungsListenFenster;
import de.lunqual.rzpro.fenster.bewertungsfenster.BewertungsAnzeigeFenster;
import de.lunqual.rzpro.fenster.bewertungsfenster.BewertungsEingabeFenster;
import de.lunqual.rzpro.fenster.bewertungsfenster.BewertungsKategorieEingabeFenster;
import de.lunqual.rzpro.fenster.bewertungsfenster.BewertungsListenFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.AbgangsFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.HerstellungBearbeitenFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.HerstellungsFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikGrafik;
import de.lunqual.rzpro.fenster.buchungsfenster.StatistikRezepturFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.VerbrauchsFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.VerlaufsFenster;
import de.lunqual.rzpro.fenster.buchungsfenster.ZugangFenster;
import de.lunqual.rzpro.fenster.containerfenster.Container;
import de.lunqual.rzpro.fenster.containerfenster.ContainerEingabe;
import de.lunqual.rzpro.fenster.datenblatt.DatenblattFenster;
import de.lunqual.rzpro.fenster.deklarationsfenster.DeklarationsAuswahl;
import de.lunqual.rzpro.fenster.deklarationsfenster.DeklarationsEingabe;
import de.lunqual.rzpro.fenster.deklarationsfenster.DeklarationsListenFenster;
import de.lunqual.rzpro.fenster.dm.DMListenFenster;
import de.lunqual.rzpro.fenster.dokumente.DokumentEingabeFenster;
import de.lunqual.rzpro.fenster.dokumente.DokumentenListeFenster;
import de.lunqual.rzpro.fenster.druckformulare.DruckformulareFenster;
import de.lunqual.rzpro.fenster.einstellungsfenster.Einstellungen;
import de.lunqual.rzpro.fenster.einstellungsfenster.EinstellungenClient;
import de.lunqual.rzpro.fenster.einstellungsfenster.SortenEingabeFenster;
import de.lunqual.rzpro.fenster.etikettenfenster.EtikettenFenster;
import de.lunqual.rzpro.fenster.gewichtsfenster.GewichtsFenster;
import de.lunqual.rzpro.fenster.hilfefenster.Hilfe;
import de.lunqual.rzpro.fenster.inventurfenster.InventurEingabe;
import de.lunqual.rzpro.fenster.inventurfenster.InventurFenster;
import de.lunqual.rzpro.fenster.inventurfenster.InventurListenFenster;
import de.lunqual.rzpro.fenster.kalenderfenster.Kalender;
import de.lunqual.rzpro.fenster.kalenderfenster.TerminEingabeFenster;
import de.lunqual.rzpro.fenster.kalkulationsfenster.Kalkulation;
import de.lunqual.rzpro.fenster.kalkulationsfenster.KalkulationEingabe;
import de.lunqual.rzpro.fenster.konformfenster.KonformFenster;
import de.lunqual.rzpro.fenster.kontraktFenster.KontrakteFenster;
import de.lunqual.rzpro.fenster.kontraktFenster.kontraktEingabe;
import de.lunqual.rzpro.fenster.laborwertfenster.LaborwertBerechnungsFenster;
import de.lunqual.rzpro.fenster.laborwertfenster.LaborwertListenFenster;
import de.lunqual.rzpro.fenster.laborwertfenster.LaborwertlisteEingabe;
import de.lunqual.rzpro.fenster.lagerfenster.Lager;
import de.lunqual.rzpro.fenster.lagerfenster.LagerEingabe;
import de.lunqual.rzpro.fenster.lieferscheinfenster.LieferscheinFenster;
import de.lunqual.rzpro.fenster.lieferscheinfenster.LieferscheinListenFenster;
import de.lunqual.rzpro.fenster.loggingfenster.LoggingFenster;
import de.lunqual.rzpro.fenster.losnummervorlagefenster.LosnummerListenFenster;
import de.lunqual.rzpro.fenster.losnummervorlagefenster.LosnummerVorlageFenster;
import de.lunqual.rzpro.fenster.mhdfenster.MhdFenster;
import de.lunqual.rzpro.fenster.mischungsfenster.MischungsEingabeFenster;
import de.lunqual.rzpro.fenster.mischungsfenster.MischungBearbeitenFenster;
import de.lunqual.rzpro.fenster.mischungsfenster.MischungChartFenster;
import de.lunqual.rzpro.fenster.mischungsfenster.MischungsListenFenster;
import de.lunqual.rzpro.fenster.mischungsfenster.TicketEingabe;
import de.lunqual.rzpro.fenster.notizfenster.NotizFenster;
import de.lunqual.rzpro.fenster.palettenfenster.PalettenEingabe;
import de.lunqual.rzpro.fenster.palettenfenster.PalettenListenFenster;
import de.lunqual.rzpro.fenster.palettenfenster.PalettenRechner;
import de.lunqual.rzpro.fenster.probenfenster.ProbenEingabe;
import de.lunqual.rzpro.fenster.probenfenster.ProbenFenster;
import de.lunqual.rzpro.fenster.rechenfenster.Rechenfenster;
import de.lunqual.rzpro.fenster.rechenfenster.rezepturContentFenster;
import de.lunqual.rzpro.fenster.rechenfenster.RezepturEditFenster;
import de.lunqual.rzpro.fenster.rezepturfenster.Ausstattung;
import de.lunqual.rzpro.fenster.rezepturfenster.Changes;
import de.lunqual.rzpro.fenster.rezepturfenster.ChangesListenFenster;
import de.lunqual.rzpro.fenster.rezepturfenster.Rezeptur;
import de.lunqual.rzpro.fenster.staerkefenster.Staerke;
import de.lunqual.rzpro.fenster.stichwortfenster.StichwortAuswahl;
import de.lunqual.rzpro.fenster.stichwortfenster.StichwortEingabe;
import de.lunqual.rzpro.fenster.tafelfenster.AlkoholTafel;
import de.lunqual.rzpro.fenster.tankfenster.OrtEingabeFenster;
import de.lunqual.rzpro.fenster.tankfenster.TankAuswahlFenster;
import de.lunqual.rzpro.fenster.tankfenster.TankEingabeFenster;
import de.lunqual.rzpro.fenster.tankfenster.TanklistenFenster;
import de.lunqual.rzpro.fenster.temperaturzonenfenster.TemperaturzonenFenster;
import de.lunqual.rzpro.fenster.zutatenverzeichnis.Zutatenverzeichnis;
import de.lunqual.rzpro.fenster.zutatenverzeichnis.ZutatenverzeichnisEingabe;
import de.lunqual.rzpro.fenster.zutatenverzeichnis.ZutatenverzeichnisEinstellungen;
import de.lunqual.rzpro.fenster.auftragsfenster.BedarfsFenster;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.mischungen.MischungsAbfrageItem;
import de.lunqual.rzpro.fenster.tracefenster.TraceFenster;

/**
 *
 * @author  lunqual
 */



public class FensterListe extends ArrayList {

    RzPro               rz;
   /* Das Fenster, von dem aus die anderen Fenster geschlossen wurden und
    * das als letztes wieder in den Vordergrund gebracht wird.
    */
    triggerListe	    	triggerliste;
    JRzFrame		   		auswahl;
    ArrayList<JDialog>		dialoge;
    /*
     * Fenster, die auch nach dem Wiedereröffnen nicht angezeigt werden
     */
    private static final int[] DO_NOT_OPEN = {FensterFactory.FENSTER_LOSNUMMER_VORLAGE,FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH,FensterFactory.FENSTER_ADRESSAUSWAHL}; 

    /** Creates a new instance of FensterListe
     * @param RzPro
     * */
    public FensterListe(RzPro r) {
        super();
        this.triggerliste = new triggerListe();
        rz = r;
        dialoge = new ArrayList<JDialog>();
    }

    public FensterItem getItem(int i) {
    	return (FensterItem)this.get(i);
    }
    public void addDialog(JDialog dlg) {
    	this.dialoge.add(dlg);
    }
    
    /**
     * Alle Fenster sperren und das Loginfenster wieder anzeigen...
     * @param trigger Das Fenster, dass das Schließen verursacht
     */
    public void sperren(JRzFrame trigger){
    	String user = rz.getDatabase().dbGetUser();
        rz.getLogFactory().logMessage(1, "FensterListe.sperren", trigger.getName());
        for(int i = 0;i < this.size();i++) {
			((FensterItem)this.get(i)).closeFenster();
		}
        for(JDialog dlg:dialoge) {
        	try {
        		dlg.dispose();
        	}catch(Exception e) {};
        }
        triggerliste.addItem(new triggerItem(trigger,user));
        try {
        	this.getFensterItem(FensterFactory.FENSTER_AUSWAHL).getFrame().getMessage(new MessageItem(MessageItem.MSG_AUSWAHL_SAVE_HISTORY,0,null,null));
        } catch (final Exception e) {}
        rz.getDatabase().dbClose();
        createWindow(FensterFactory.FENSTER_LOGIN,true,null);
    }

    /**
     * Fenster entsprerren und Trigger aktivieren
     */
    
    private boolean doNotOpen(FensterItem fi) {
    	for(int i:DO_NOT_OPEN) {
    		if(i == fi.getTyp()) {
    			return true;
    		}
    	}
    	return false;
    }
    
    public void entSperren(){
    	String user=rz.getDatabase().dbGetUser();
    	triggerItem ti = triggerliste.getTrigger(user);
        for(int i = 0;i < this.size();i++) {
        	FensterItem fi = (FensterItem)this.get(i); 
        	if(fi.getFrame() != auswahl && fi.getUser().equals(user)) {
        		if(!doNotOpen(fi))fi.openFenster();
        	}
		}

        try {
        	if(ti != null) {
        		rz.getLogFactory().logMessage(1, "FensterListe.entsperren", ti.getFrame().getName());
        	}
        	auswahl.setVisible(true);
        	this.getFensterItem(FensterFactory.FENSTER_AUSWAHL).getFrame().getMessage(new MessageItem(MessageItem.MSG_REFRESH_CAPTION,0,null,null));
        } catch (final Exception e) {

        }
        try {
        	if(ti!=null) {
	            this.getFensterItem(ti.getFrame()).openFenster();
	            ti.getFrame().toFront();
	            ti.getFrame().requestFocus();
        	}
        }catch(Exception e) {}
    }
    /**
     * erzeugt ein Fenster vom gewünschten Typ
     * @param typ int   FensterKey in  de.lunqual.rzpro.fenstercontrol.rzfenster definiert
     * @param single boolean wenn true, darf nur eine Instanz des Fensters existieren
     * @param extendedData Object , zusätzliche Daten
     */
    public JRzFrame createWindow(int typ,boolean single,Object extendedData){
    	String fensterName;
    	FensterItem fi;
    	JRzFrame f = null;
    	String user = rz.getDatabase().dbGetUser();
    	if(single) {
    	  	// es darf nur eine Instanz existieren
    		fensterName = String.valueOf(typ) +  FensterFactory.WINDOW_SEPARATOR + "0";
    		fi = this.getFensterItem(typ);
    		if(fi != null) {
    		   fi.getFrame().getMessage((MessageItem)extendedData);
               fi.getFrame().openWindow();
               return fi.getFrame();
    		}
    	} else {
    		/* fensternamen 1. Teil erzeugen
    		 * Der Fenstername besteht aus dem Typ, gefolgt von einem unterstrich,
    		 * gefolgt von der Nummer der Instanz, z.B. "1_0"
    		 */
    		fensterName = String.valueOf(typ) +FensterFactory.WINDOW_SEPARATOR + getWindowSerial(typ);
    	}
    	/* das Fenster ist noch nicht vorhanden oder es darf
    	 * mehrmals instanziert werden...
    	 */
    	switch(typ)
		{
    		case FensterFactory.FENSTER_LOGIN :
    			f = new AnmeldeFenster(rz,fensterName,extendedData);
    			break;
    		case FensterFactory.FENSTER_LOGIN_EINSTELLUNGEN :
    			f = new AnmeldeEinstellungen(rz,fensterName,extendedData);
    			break;
              case FensterFactory.FENSTER_AUSWAHL:
                  f = new Auswahl(rz,fensterName,extendedData);
                  auswahl = f;
              	  break;
              case FensterFactory.FENSTER_ADRESSAUSWAHL:
                  f = new AdressAuswahl(rz,fensterName,extendedData);
              		break;
              case FensterFactory.FENSTER_STICHWORTAUSWAHL:
                  f = new StichwortAuswahl(rz,fensterName,extendedData);
              	break;
              case FensterFactory.FENSTER_HILFE:
                  f = new Hilfe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ADRESSEN:
                  f = new AdressenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ADRESSEINGABE:
                  f = new AdressEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_REZEPTUR:
                  f = new Rezeptur(rz,fensterName,extendedData);
              	break;
              case FensterFactory.FENSTER_NOTIZ:
                  f = new NotizFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_KALKULATION:
                  f = new Kalkulation(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_LAGER:
                  f = new Lager(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_RECHNEN:
                  f = new Rechenfenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_EINSTELLUNGEN:
                  f = new Einstellungen(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_KALKULATION_EINGABE:
                  f = new KalkulationEingabe(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_LAGER_EINGABE:
                  f = new LagerEingabe(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_STAERKE:
                  f = new Staerke(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_BEHAELTER:
                  f = new Container(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_CONTAINER_EINGABE:
                  f = new ContainerEingabe(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_LIEFERSCHEIN:
                  f = new LieferscheinFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_LIEFERSCHEIN_LISTE:
                  f = new LieferscheinListenFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_ADRESSAUSWAHL_EINFACH:
                  f = new AdressAuswahlEinfach(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_ETIKETTEN:
                  f = new EtikettenFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_TAFEL:
                  f = new AlkoholTafel(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_ZUGANG:
                  f = new ZugangFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_ABGANG:
                  f = new AbgangsFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_STATISTIK:
                  f = new StatistikFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_HERSTELLUNG:
                  f = new HerstellungsFenster(rz,fensterName,extendedData);
              	  break;
              case FensterFactory.FENSTER_HERSTELLUNG_EDIT:
                f = new HerstellungBearbeitenFenster(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_ABGANGCLIENT_AUSWAHL:
                  f = new AbgangsClientAuswahl(rz,fensterName,extendedData);
                  auswahl=f;
              	  break;
              case FensterFactory.FENSTER_VERLAUF:
                f = new VerlaufsFenster(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_ABOUT:
                f = new AboutFenster(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_LOGGING:
                f = new LoggingFenster(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_CLIENT_EINSTELLUNGEN:
                f = new EinstellungenClient(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_AUSBEUTE:
                f = new Ausbeute(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_STICHWORT_BEARBEITEN:
                f = new StichwortEingabe(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_AUSBEUTE_EINGABE:
                f = new AusbeuteEingabe(rz,fensterName,extendedData);
            	  break;
              case FensterFactory.FENSTER_ZUGANGCLIENT_AUSWAHL:
                  f = new ZugangsClientAuswahl(rz,fensterName,extendedData);
                  auswahl=f;
                  break;
              case FensterFactory.FENSTER_ST_GRAFIK:
                  f = new StatistikGrafik(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DEPENDENCY:
                  f = new DependencyFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_PALETTENLISTE:
                  f = new PalettenListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_PALETTENEINGABE:
                  f = new PalettenEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_PALETTENRECHNER:
                  f = new PalettenRechner(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ABFRAGE_ERWEITERT:
                  f = new AbfrageFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_INVENTURLISTE:
                  f = new InventurListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_INVENTUREINGABE:
                  f = new InventurEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_INVENTURFENSTER:
                  f = new InventurFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ACIDLISTENFENSTER:
                  f = new AcidListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ACIDEINGABE:
                  f = new AcidEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ACIDRECHNER:
                  f = new AcidRechner(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DEKLARATIONSLISTE:
                  f = new DeklarationsListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DEKLARATIONS_EINGABE:
                  f = new DeklarationsEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DEKLARATIONS_AUSWAHL:
                  f = new DeklarationsAuswahl(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_AUSSTATTUNG:
                  f = new Ausstattung(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DATENBLATT:
                  f = new DatenblattFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_BESTELLUNGEN:
                  f = new BestellungsFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_BESTELLUNGSLISTE:
                  f = new BestellungsListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_LABORWERTLISTE:
                  f = new LaborwertListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_LABORWERTLISTE_EINGABE:
                  f = new LaborwertlisteEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_LABORWERT_BERECHNEN:
                  f = new LaborwertBerechnungsFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_STATISTIK_REZEPTUR:
                  f = new StatistikRezepturFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_PROBE:
                  f = new ProbenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_PROBEN_EINGABE:
                  f = new ProbenEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ZUTATENVERZEICHNIS_EINSTELLUNGEN:
                  f = new ZutatenverzeichnisEinstellungen(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ZUTATENVERZEICHNIS_EINGABE:
                  f = new ZutatenverzeichnisEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ZUTATENVERZEICHNIS:
                  f = new Zutatenverzeichnis(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_VERBRAUCH:
                  f = new VerbrauchsFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_GEWICHT:
                  f = new GewichtsFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_LOSNUMMER_VORLAGE:
                  f = new LosnummerVorlageFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_KALENDER:
                  f = new Kalender(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_AUFTRAG:
                  f = new AuftragsFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_CHANGES:
                  f = new Changes(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_CHANGESLISTE:
                  f = new ChangesListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_MHD:
                  f = new MhdFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_TEMPERATURZONEN:
                  f = new TemperaturzonenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_AUFTRAGSLISTE:
                  f = new AuftragslistenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_TERMINEINGABE:
                  f = new TerminEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DMLISTE:
                  f = new DMListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_TANKLISTE:
                  f = new TanklistenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_ORTEINGABE:
                  f = new OrtEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_TANKEINGABE:
                  f = new TankEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_TANKAUSWAHL:
                  f = new TankAuswahlFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_KONFORM:
                  f = new KonformFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_SORTEN_EINGABE:
                  f = new SortenEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_MISCHUNG_EINGABE:
                  f = new MischungsEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_MISCHUNGSLISTE:
                  f = new MischungsListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_BEWERTUNGEN_KATEGORIE_EINGABE:
                  f = new BewertungsKategorieEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_BEWERTUNGEN_EINGABE:
                  f = new BewertungsEingabeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_BEWERTUNGEN_ANZEIGE:
                  f = new BewertungsAnzeigeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_BEWERTUNGSLISTE:
                  f = new BewertungsListenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_MISCHUNG:
                  f = new MischungBearbeitenFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_TICKETEINGABE:
                  f = new TicketEingabe(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_STAMMBAUM:
                  f = new StammbaumFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_VERGLEICH:
                  f = new Vergleichsfenster(rz,fensterName,extendedData);
                  break;          
              case FensterFactory.FENSTER_BEDARF:
                  f = new BedarfsFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_TRACE:
                  f = new TraceFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_LOSNUMMERLISTE:
                  f = new LosnummerListenFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_DRUCKFORMULARE:
                  f = new DruckformulareFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_MISCHUNG_CHART:
                  f = new MischungChartFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_DOCUMENT_LISTE:
                  f = new DokumentenListeFenster(rz,fensterName,extendedData);
                  break;
              case FensterFactory.FENSTER_DOCUMENT_EINGABE:
                  f = new DokumentEingabeFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_REZEPTUR_CONTENT:
                  f = new rezepturContentFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_RECHNEN_EDIT_CONTENT:
                  f = new RezepturEditFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_KONTRAKTE:
                  f = new KontrakteFenster(rz,fensterName,extendedData);
                  break;   
              case FensterFactory.FENSTER_EDIT_KONTRAKT :
                  f = new kontraktEingabe(rz,fensterName,extendedData);
                  break;                     
                  
		}
    	if(f != null) {
    	    f.setIconImage(new ImageIcon(getClass().getResource(FensterFactory.ICON_PATH)).getImage() );
        	this.add(new FensterItem(f,typ,user));
        	f.setComponentProperties();
        	f.openWindow();
    	}
        return f;
    }

    
    public JRzFrame getActive() {
    	for(int i = 0;i<this.size();i++) {
    		JRzFrame frame = this.getItem(i).getFrame();
    		if(frame != null && frame.isActive()) {
    			return frame;
    		}
    	}
    	return auswahl;
    }
    /**
     * zeichnet alle Fenster der Liste neu, nach Änderung des Designs
     */
    public void changeDesign() {
        for(int i=0;i < this.size();i++) {
        	((FensterItem)this.get(i)).getFrame().updateFrameDesign();
        }
    }

    /**
     * zeichnet alle Fenster der Liste neu, nach Änderung der Schriftgrößen
     */
    public void redrawFrames() {
        for(int i=0;i < this.size();i++) {
        	((FensterItem)this.get(i)).getFrame().redrawFrame();
        }
    }
    /** liefert eine Seriennummer für Fenster, die mehrfach existieren dürfen
     * @param typ int der Typ des Fensters
     * @return int die Seriennummer
     */
    private String getWindowSerial(int typ) {
        int n = 0;
        for(int i=0;i < this.size();i++) {
            final FensterItem fi = (FensterItem)this.get(i);
            final String s = fi.getFrame().getName().split(FensterFactory.WINDOW_SEPARATOR)[0];
            n += s.equals(String.valueOf(typ)) ? 1 : 0;
        }
        return String.valueOf(n);
    }

    /**
     *  gibt das FensterItem des gewünschten Frames zurück
     */
    public FensterItem getFensterItem(JRzFrame f){
        for(int i = 0;i < this.size();i++){
            if (((FensterItem)this.get(i)).getFrame() == f) {
				return (FensterItem)this.get(i);
			}
        }
        return null;
    }

    /** gibt das (erste) Fensteritem mit dem gesuchten Typ zurück
     *
     * @param typ
     * @return FensterItem
     */
    public FensterItem getFensterItem(int typ){
        for(int i = 0;i < this.size();i++){
            if (((FensterItem)this.get(i)).getTyp() == typ) {
				return (FensterItem)this.get(i);
			}
        }
        return null;
    }
    
    public void disposeAllWindows() {
        for(int i = 0;i < this.size();i++){
        	final FensterItem fi = (FensterItem)this.get(i);
    		fi.getFrame().setVisible(false);
    		fi.getFrame().dispose();
        }
        this.clear();
    }
    /** entfernt ein Fenster aus der Liste und wirft es auf den Müll
     * @param JRzFrame frame   das zu löschende Fenster
     * @author lunqual
     */
    public void disposeFrame(JRzFrame frame) {
        for(int i = 0;i < this.size();i++){
        	final FensterItem fi = (FensterItem)this.get(i);
        	if (fi.getFrame().equals(frame)) {
        		fi.getFrame().setVisible(false);
        		fi.getFrame().dispose();
        		this.remove(i);
        		continue;
            }
        }
    }

    /** entfernt ein Fenster aus der Liste und wirft es auf den Müll
     * @param String name der Name des zu löschenden Fensters
     * @author lunqual
     */
    public void disposeFrame(String name) {
        for(int i = 0;i < this.size();i++){
        	final FensterItem fi = (FensterItem)this.get(i);
        	if (fi.getFrame().getName().equals(name)) {
        		fi.getFrame().setVisible(false);
        		fi.getFrame().dispose();
        		this.remove(i);
        		continue;
            }
        }
    }
    
    public boolean getVergleichHasItem2() {
    	boolean ret = false;
    	FensterItem fi = this.getFensterItem(FensterFactory.FENSTER_VERGLEICH);
		if(fi != null) {
			try {
				ret  = ((Vergleichsfenster)fi.getFrame()).hasItem2();
			}catch(Exception e) {}
		}
		return ret;
    }
    
    public boolean getVergleichHasItem1() {
    	boolean ret = false;
    	FensterItem fi = this.getFensterItem(FensterFactory.FENSTER_VERGLEICH);
		if(fi != null) {
			try {
				ret  = ((Vergleichsfenster)fi.getFrame()).hasItem1();
			}catch(Exception e) {}
		}
		return ret;
    }
    
    public void propagateProbe(JRzFrame parent,int probe) {
    	for(int i=0;i < this.size();i++) {
    		if(this.getItem(i).getFrame() != parent) {
    			this.getItem(i).getFrame().getMessage(new MessageItem(MessageItem.MSG_PROPAGATE_PROBEN,probe,null,null));
    		}
    	}
    }
    
    /**
     * Ein Bestand wurde geändert
     * Alle offenen Berechnungsfenster erhalten die Aufforderung
     * zur Neuberechnung
     */
    public void propagateBestand(JRzFrame frame,int[] rezepturen) {
    	propagate(frame,0,rezepturen);
    }
    
    public void propagateBestand(JRzFrame frame,int rezeptur) {
    	propagate(frame,rezeptur,null);
    }
    
    public void propagateBestand(JRzFrame frame) {
    	propagate(frame,0,null);	
    }
    
    private void propagate(JRzFrame frame,int rezeptur,int[] rezepturen) {
    	for(int i=0;i < this.size();i++) {
    		if ((getItem(i).getTyp() == FensterFactory.FENSTER_TANKLISTE)||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_KALENDER)||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_ABGANGCLIENT_AUSWAHL)||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_ZUGANGCLIENT_AUSWAHL)||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_RECHNEN) || 
    				(getItem(i).getTyp() == FensterFactory.FENSTER_AUSWAHL) ||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_LIEFERSCHEIN)||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_MISCHUNGSLISTE)||
    				(getItem(i).getTyp() == FensterFactory.FENSTER_HERSTELLUNG)) {
    			//if((frame != null) && (frame != getItem(i).getFrame())) {
    			if (frame != null) {
	    			try { //vorsichtshalber
	    				this.getItem(i).getFrame().getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,rezeptur,rezepturen,frame));
	    			}catch(final Exception e) {
	    				//muss man nix dagegen tun
	    			}
    			}
    		}
    	}
    }
    
    public void propagateMischung(JRzFrame frame,int mischung) {
    	if(mischung != 0) {
	    	MischungsAbfrageItem mai = new MischungsAbfrageItem(rz,mischung);
	    	for(int i=0;i < this.size();i++) {
	    		if ((getItem(i).getTyp() == FensterFactory.FENSTER_TANKLISTE) || 
	    				(getItem(i).getTyp() == FensterFactory.FENSTER_MISCHUNGSLISTE)||
	    				(getItem(i).getTyp() == FensterFactory.FENSTER_MISCHUNG)
	    				) 
	    		{
	    			try { //vorsichtshalber
	    				this.getItem(i).getFrame().getMessage(new MessageItem(MessageItem.MSG_REFRESH_AUSGABE,mischung,mai,frame));
	    			}catch(final Exception e) {
	    				//muss man nix dagegen tun
	    			}
	    		}
	    	}
    	}
    }
    
    public void closeLosnummerVorlageFenster() {
    	for(int i=0;i < this.size();i++) {
    		if ((getItem(i).getTyp() == FensterFactory.FENSTER_LOSNUMMER_VORLAGE)) {
    			JFrame frame = getItem(i).getFrame();
    			if (frame != null) {
	    			try { //vorsichtshalber
	    				frame.dispose();
	    				this.remove(i);
	    			}catch(final Exception e) {
	    				//muss man nix dagegen tun
	    			}
    			}
    		}
    	}
    }
    public void closeBewertungsFenster() {
    	for(int i=0;i < this.size();i++) {
    		if ((getItem(i).getTyp() == FensterFactory.FENSTER_BEWERTUNGEN_EINGABE)) {
    			JFrame frame = getItem(i).getFrame();
    			if (frame != null) {
	    			try { //vorsichtshalber
	    				frame.dispose();
	    				this.remove(i);
	    			}catch(final Exception e) {
	    				//muss man nix dagegen tun
	    			}
    			}
    		}
    	}
    }
    /**
     * gibt das Hauptfenster zurück
     */
    public JRzFrame getAuswahl() {
    	return auswahl;
    }
    

}
