package de.lunqual.rzpro.items.icons;


import java.awt.Image;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

import de.lunqual.rzpro.RzPro;

public class IconItem {
	
	RzPro 			rz;
	int				id;
	String			filename;
	BufferedImage	img;
	ImageIcon		icon;
	float			ratio = 1;
	
	public IconItem(RzPro rz,int id,String filename,BufferedImage img) {
		this.rz = rz;
		this.id = id;
		this.filename = filename;
		this.img = img;
		this.ratio = (float)img.getHeight()/(float)img.getWidth();
	}

	public BufferedImage getImage() {
		return img;
	}
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
	public ImageIcon getIcon(int size) {
		Image img1 = img.getScaledInstance(size, (int)(size * ratio),  java.awt.Image.SCALE_SMOOTH);   
        icon = new ImageIcon(img1); 
		return icon;
	}

	public String getFilename() {
		return filename;
	}
	
	public String toString() {
		return filename;
	}
	
}
