package de.lunqual.rzpro.items.kalender;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.ausgabe.AusgabeFactory;
import de.lunqual.rzpro.database.DBKalender;
import de.lunqual.rzpro.items.auftrag.AuftragsItem;
import de.lunqual.rzpro.items.auftrag.Auftragsliste;
import de.lunqual.rzpro.items.auftrag.TagesListe;
import de.lunqual.rzpro.options.OptionFactory;


public class KalenderItem {
	
	public static final int DETAIL_AUFTRAG 	= 0;
	public static final int DETAIL_TERMIN	= 1;
	public static final int DEFAULT_FONTSIZE = 12;
	
	private static final String TABLE_BACKGROUND_NORMAL="#ffffff";
	private static final String TABLE_BACKGROUND_FEIERTAG="#ffdddd";
	private static final String TABLE_BACKGROUND_AKTUELL="#ffffaa";
	private static final String TABLE_BACKGROUND_TODAY="#ffce70";

	private static final String COLOR_TERMIN_ERLEDIGT_BG="eeeeff";
	private static final String COLOR_TERMIN_ERLEDIGT_FG="000000";
	
	private static final String TABLE_BORDER_STYLE="style=\""+
					"border-width: medium;"+
					"border-spacing: 2px;"+
					"border-style: outset;"+
					"border-color: gray;"+
					"border-collapse: separate;"+
					"background-color: "+ TABLE_BACKGROUND_NORMAL+ ";";
	
	private static final String TABLE_CELL_STYLE="style=\""+
					"border-width: thin;"+
					"padding: 1px;"+
					"border-style: inset;"+		
					"border-color: gray;";
	
	
	RzPro 				rz;
	Calendar			today;
	Calendar			show;
	TagesListe			feiertagsliste;
	int					typ;
	boolean				anzeige;
	SimpleDateFormat	df;
    String[] 			monate = new DateFormatSymbols().getMonths();
    String[] 			tage = new DateFormatSymbols().getWeekdays();
    int					auftragsID;
    int					terminID;
    TerminListe			termine;
    int 				fontsize;
    
	public KalenderItem(RzPro rz,int typ) {
		this.rz=rz;
		today = Calendar.getInstance();
		rz.roundDatum(today);
		show = (Calendar)today.clone();
		this.typ = typ;
		anzeige=rz.getOptionFactory().getOption("kalender.anzeige",DBKalender.KALENDER_ANZEIGE_TERMIN_DEFAULT)==1?true:false;
		refresh();
		this.fontsize=rz.getOptionFactory().getOption("kalender.fontsize",DEFAULT_FONTSIZE);
	}
	
	public void setFontsize(int fontsize) {
		this.fontsize = fontsize;
	}
	
	public Calendar getToday() {
		return today;
	}
	public void refresh() {
		feiertagsliste=rz.getDatabase().getKalender().getFeiertage();
	}
	
	public void setShowDate(int field,int value) {
		show.set(field, value);
		rz.roundDatum(show);
	}
	
	public void setShowDate(long milliseconds) {
		show.setTimeInMillis(milliseconds);
		rz.roundDatum(show);
	}
	
	public void setTyp(int typ){
		this.typ=typ;
	}
	public void setAnzeige(boolean anzeige) {
		this.anzeige=anzeige;
	}
	
	public Date getDate() {
		return show.getTime();
	}

	public Calendar getShow() {
		return show;
	}
	
	public void setShowAdd(int field,int amount) {
		show.add(field, amount);
	}
	
	public void setShowDayToday() {
		show=(Calendar)today.clone();
	}
	
	public void setShowDate(Date datum) {
		show.setTime(datum);
		rz.roundDatum(show);
	}
	public void setShowKw(int kw) {
		if(kw > show.getActualMaximum(Calendar.WEEK_OF_YEAR)) {
			kw=show.getActualMaximum(Calendar.WEEK_OF_YEAR);
		}
		show.set(Calendar.WEEK_OF_YEAR,kw);
		show.set(Calendar.DAY_OF_WEEK,Calendar.MONDAY);
	}
	
	public void setShowJulianDay(int day) {
		if(day > show.getActualMaximum(Calendar.DAY_OF_YEAR)) {
			day = show.getActualMaximum(Calendar.DAY_OF_YEAR);
		}
		show.set(Calendar.DAY_OF_YEAR,day);
	}
	
	public void terminErledigen(int id,boolean erledigt) {
		for(int i=0;i<termine.size();i++){
			if(termine.getItem(i).getId()==id) {
				termine.getItem(i).setErledigt(erledigt);
				break;
			}
		}
	}
		
	//-------------------------------------------------------------getter-------------
	public int getTyp() {
		return typ;
	}
	public int getShowDay() {
		return show.get(Calendar.DAY_OF_MONTH);
	}
	public int getShowMonth() {
		return show.get(Calendar.MONTH);
	}
	public int getShowYear() {
		return show.get(Calendar.YEAR);
	}
	public String getShow20() {
		return rz.getDatabase().getKalender().getDate20(show);
	}
	public int getShowKw() {
		return show.get(Calendar.WEEK_OF_YEAR);
	}
	public int getShowDayJulian() {
		return show.get(Calendar.DAY_OF_YEAR);
	}
	public boolean isAnzeige() {
		return anzeige;
	}
	

	/*
	 * Anzeige Strings....
	 */
	
	public void setDetail(int what,int id) {
		switch (what) {
			case DETAIL_AUFTRAG:
				auftragsID = id;
				terminID = 0;
				break;
			case DETAIL_TERMIN:
				auftragsID = 0;
				terminID = id;
				break;
		}
	}
	
	public String getHtml() {
		String ret="<html><head>" +
				"<style type=\"text/css\">"+
				"a { text-decoration:none; color:#000000; }" +
				"</style>" +	
				"</head><body>";
		ret+=getHeader();
		ret+=getTabellenHeader();
		ret += getKalender();
		ret += getDetail();
		ret += getTabellenFooter();
		ret += "</body></html>";
		return ret;
	}
	
	public String getDetail() {
		String ret="";
		if(auftragsID != 0) {
			AuftragsItem ai = rz.getDatabase().getAuftrag().getAuftragSingle(auftragsID);
			if(ai != null) {
				ret += "<br><table border=\"0\"><center><tr>";
				ret+="<td style=\"background-color:#" + ai.getHg()+   ";color:#" +ai.getVg()+";border:none;border-width:1px;\">";	
		           	ret += "<div " + rz.getAusgabeFactory().insertStyle(AusgabeFactory.DIV_ERSTELLT,12) + ">";
		       		ret += rz.getLocale().getString("string_erstellt").replaceAll("%s",ai.getErstelltToString()).replaceAll("%v",ai.getErstellt_user()) ;
		       	ret += "</div>";
		       	//geändert
		       	ret += "<div " + rz.getAusgabeFactory().insertStyle(AusgabeFactory.DIV_GEAENDERT,12) + ">";
		       		ret += rz.getLocale().getString("string_geaendert").replaceAll("%s",ai.getGeaendertToString()).replaceAll("%v",ai.getGeaendert_user()) ;
		       	ret += "</div>";  
		       	if(ai.isErledigt()) {
			       	ret += "<div " + rz.getAusgabeFactory().insertStyle(AusgabeFactory.DIV_ADRESSEN,12) + "><center>";
					ret += rz.getLocale().getString("kalender.label_erledigt").replaceAll("%d", ai.getErledigtToString()).replaceAll("%s",ai.getErledigt_user());
					ret +="</center></div>";
				}
		       	ret+="<br><br>";
				if(rz.isMain() && ai.isEigen()) {
					ret += rz.getAusgabeFactory().insertGfx("kalender.icon_eigen.png");
				}
				if(rz.isMain() && ai.isInarbeit()) {
					ret += rz.getAusgabeFactory().insertGfx("kalender.icon_inarbeit.png");
				}
				if(rz.isMain() && !ai.getGruppe().equals("")) {
					ret += rz.getAusgabeFactory().insertGfx("kalender.icon_gruppe.png");
					ret += ai.getGruppe()+"<br>";
				}
				if(!ai.isArbeitsAuftrag()) {
					ret += rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + " "+ ai.getBezeichnung() + "</b><br>";
				} else {
					ret += ai.getBezeichnung() + "</b><br>";
				}
				if(ai.isRepeat()) {
					ret += rz.getDatabase().getAuftrag().getRepeatSpanListe().get(ai.getRepSpan()).getSpanString(ai) + "<br>";
				}
				ret += rz.getLocale().getString("kalender.string_faellig_detail").replaceAll("%x", ai.getFaelligToString()).replaceAll("%z",rz.getDatabase().getAuftrag().getAuftragsConfig().getColors(ai,0)[2])+"<br>";
				ret += rz.getLocale().getString("kalender.auftrag_label_user").replaceAll("%s",ai.getArbeit_user()) + "<br>";
				if(ai.isInarbeit()) {
					ret += rz.getLocale().getString("kalender.auftrag_label_inarbeit").replaceAll("%s",ai.getInArbeitToString()) + "<br>";
				}
				ret += rz.getLocale().getString("kalender.auftrag_label_comment").replaceAll("%s",ai.getComment());
				
			ret += "</td>";
				ret +="</tr></center><br><br>";
			}
		}
		if(terminID != 0) {
			TerminItem ti = rz.getDatabase().getKalender().getTermin(terminID);
			if(ti != null) {
				ret += "<br><table border=\"0\"><center><tr>";
				ret+="<td style=\"background-color:#" + (ti.isErledigt()?COLOR_TERMIN_ERLEDIGT_BG:ti.getHg())+   ";color:#" +(ti.isErledigt()?COLOR_TERMIN_ERLEDIGT_FG:ti.getVg())+"border:none;border-width:1px;\">";	
		           	ret += "<div " + rz.getAusgabeFactory().insertStyle(AusgabeFactory.DIV_ERSTELLT,12) + ">";
		       		ret += rz.getLocale().getString("string_erstellt").replaceAll("%s",ti.getErstelltToString()).replaceAll("%v",ti.getErstellt_user()) ;
		       	ret += "</div>";
		       	//geändert
		       	ret += "<div " + rz.getAusgabeFactory().insertStyle(AusgabeFactory.DIV_GEAENDERT,12) + ">";
		       		ret += rz.getLocale().getString("string_geaendert").replaceAll("%s",ti.getGeaendertToString()).replaceAll("%v",ti.getGeaendert_user()) ;
		       	ret += "</div>";  
		       	//erledigt
		       	if(ti.isErledigt()) {
			       	ret += "<div " + rz.getAusgabeFactory().insertStyle(AusgabeFactory.DIV_ADRESSEN,12) + ">";
		       		ret += rz.getLocale().getString("kalender.string_erledigt").replaceAll("%s",ti.getErledigtToString()).replaceAll("%v",ti.getErledigt_user()) ;
		       	ret += "</div>"; 
		       	}
				if(rz.isMain() && ti.isEigen()) {
					ret += rz.getAusgabeFactory().insertGfx("kalender.icon_eigen.png");
				}
				ret += "<center>" + rz.getLocale().getString("kalender.termin_label_faellig").replaceAll("%x", ti.getFaelligToString())+"</center><br>";
				ret += "<b><center>" + ti.getBezeichnung() + "</center></b><br>";
				ret += rz.getLocale().getString("kalender.termin_label_comment").replaceAll("%x",ti.getComment()).replaceAll("\\n","<br>");
				
			ret += "</td>";
				ret +="</tr></center><br><br>";
			}
		}
		return ret;
	}
	
	
	private String getEmptyCell() {
    	return "<td " + TABLE_CELL_STYLE +  "\"></td>";
	}
	
	private String getTD() {
		return "<td "  + TABLE_CELL_STYLE  + "\">";
	}
	private String getTD(String background) {
		return "<td "  + TABLE_CELL_STYLE  + "background-color:" + background+ ";\">";
	}
	private String getTabellenFooter() {
		String ret="";
    	ret +="<center><table border=\"1\"><tr>";
    	int jahr=show.get(Calendar.YEAR) - 10;
    	for(int i=jahr;i<(jahr+20);i++) {
    		String tdcolor;
    		if(i==show.get(Calendar.YEAR)) {
    			tdcolor = " color=#0000ff bgcolor=" + TABLE_BACKGROUND_AKTUELL + ">";
    		}else {
    			tdcolor = " color=#ff8800 bgcolor=#ffffff>";
    		}
    		ret += "<td " + tdcolor +"<center><h4>" +String.valueOf(i) +  "</h4><b>" + rz.getDatabase().getKalender().getYear20(i) + "</b>" + "</center></td>";
    	}
    	ret+="</tr></table></center>";
    	ret+="</body></html>";
		return ret;
	}
	
	
	
	/*
	 * Header mit dem Tag:
	 */
	private  String getHeader() {
		String ret="";
		ret+="<center><b><h1>" + tage[show.get(Calendar.DAY_OF_WEEK)]+ ", "+ show.get(Calendar.DAY_OF_MONTH) + ". "+  monate[show.get(Calendar.MONTH)] +" "+ show.get(Calendar.YEAR) + "&nbsp;</h1>";
    	ret += "<h2><font color = \"blue\">" +rz.getLocale().getString("kalenderitem.label_tag")  + show.get(Calendar.DAY_OF_YEAR) + "</font>";
    	ret += "&nbsp;<font color = \"green\">&nbsp;&nbsp;(" + rz.getDatabase().getKalender().getDate20(show) + ", </font>&nbsp;&nbsp;";
    	ret += "<font color=#ff8800>" +rz.getDatabase().getKalender().getYear20(show)+"</font>" + "<font color = \"green\">" + rz.getDatabase().getKalender().getDate20(show) + ")</font></b></h2></center><br>";
		return ret;
	}
	/*
	 * Tabellenheader
	 */
	private String getTabellenHeader() {
		String ret="";
		ret+="<center><table " + TABLE_BORDER_STYLE + "\"><tr>";
			ret += getEmptyCell();
			ret+=getTD() + "<b>" + tage[Calendar.MONDAY]+"</b></td>";
			ret+=getTD() + "<b>" + tage[Calendar.TUESDAY]+"</b></td>";
			ret+=getTD() + "<b>" + tage[Calendar.WEDNESDAY]+"</b></td>";
			ret+=getTD() + "<b>" + tage[Calendar.THURSDAY]+"</b></td>";
			ret+=getTD() + "<b>" + tage[Calendar.FRIDAY]+"</b></td>";
			if(rz.getDatabase().getKalender().isSaturday()){
				ret += getTD() + "<b>" + tage[Calendar.SATURDAY]+"</b></td>";
			}else {
				ret+=getTD() + "<b><font color=#ff0000>" + tage[Calendar.SATURDAY]+"</font></b></td>";			
			}
			ret+=getTD() + "<b><font color=#ff0000>" + tage[Calendar.SUNDAY]+"</font></b></td>";
		ret+="</tr>";
		return ret;
	}
	/*
	 * Monatskalender
	 */
	private String getKalender() {
		String ret="";
		int i,start;
		Calendar lfdDatum;
		Calendar firstDate = (Calendar)show.clone();
		int	length=7;
		switch(typ) {
			case DBKalender.KALENDER_MONAT:
				firstDate.set(Calendar.DAY_OF_MONTH,1);
				length = show.getActualMaximum(Calendar.DAY_OF_MONTH);
				break;
			case DBKalender.KALENDER_WOCHE:
				if(show.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY) {
					firstDate.add(Calendar.DATE,-6);
				}else {
					firstDate.add(Calendar.DATE, -show.get(Calendar.DAY_OF_WEEK)+2);
				}
				length=7;
				break;
			case DBKalender.KALENDER_2WOCHEN: 
				if(show.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY) {
					firstDate.add(Calendar.DATE,-6);
				}else {
					firstDate.add(Calendar.DATE, -show.get(Calendar.DAY_OF_WEEK)+2);
				}
				length=14;
				break;

		}
    	if(firstDate.get(Calendar.DAY_OF_WEEK)==Calendar.SUNDAY) {
    		start=6;
    	}else {
    		start=firstDate.get(Calendar.DAY_OF_WEEK)-2;
    	}
    	ret += getTD() + rz.getLocale().getString("kalenderitem.label_kw").replaceAll("%s",String.valueOf(firstDate.get(Calendar.WEEK_OF_YEAR))) +"</td>";
		for(i=0;i<start;i++) {
			ret+=getEmptyCell();
		}
		lfdDatum = (Calendar)firstDate.clone();
		Calendar lastDate=(Calendar)firstDate.clone();
		lastDate.add(Calendar.DATE,length);

		rz.getDatabase().getAuftrag().refreshDatumsListe(firstDate.getTimeInMillis(),lastDate.getTimeInMillis());
		rz.getDatabase().getKalender().refreshTerminListe(firstDate.getTimeInMillis(),lastDate.getTimeInMillis(),today.getTimeInMillis());
		
		for(i=1;i<=length;i++) {
			if(start==7) {
				ret += "</tr>";				
		    	ret += getTD() + rz.getLocale().getString("kalenderitem.label_kw").replaceAll("%s",String.valueOf(lfdDatum.get(Calendar.WEEK_OF_YEAR)));
		    	ret += "</td>";
				start = 0;
			}
			// TD
			String bg="ffffff";
			if(rz.getDatabase().getKalender().isFeiertag(lfdDatum)) {
				bg=TABLE_BACKGROUND_FEIERTAG;
			} else {
				bg=TABLE_BACKGROUND_NORMAL;
			}
			if(lfdDatum.equals(show)) {
				bg=TABLE_BACKGROUND_AKTUELL;
			}
			if(lfdDatum.equals(today)) {
				bg=TABLE_BACKGROUND_TODAY;
			}
			ret += getTD(bg);
			ret += getCell(lfdDatum);
			
			
			ret += "</td>";
			start++;
			lfdDatum.add(Calendar.DATE,1);
		}
		for(i=start;i<7;i++) {
			ret += getEmptyCell();
		}
    	ret +="</tr></table>";
		return ret;
	}
	
	private String getCell(Calendar lfdDatum) {
		String ret="<table><tr>";
			ret += "<td>";
			if(rz.getDatabase().getKalender().isFeiertag(lfdDatum)) {
				ret += "<center><b><h1><font color=\"red\">" + lfdDatum.get(Calendar.DAY_OF_MONTH) + "</font></h1></b></center>";
			}else {
				ret += "<center><b><h1><a href=\"std:" + Long.toString(lfdDatum.getTimeInMillis()) + "\">" + lfdDatum.get(Calendar.DAY_OF_MONTH) + "</a></h1></b></center>";
			}
			if(rz.isMain() && anzeige) {
				if(lfdDatum.getTimeInMillis()>=today.getTimeInMillis() && !rz.getDatabase().getKalender().isFeiertag(lfdDatum)) {
					ret += "<table style=\"border-style:solid;border-width:1px;\"><tr>";
					ret += "<td><a href=\"tne:" + lfdDatum.getTimeInMillis() +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_termin.png") + "</a></td>";
					ret += "<td><a href=\"af0:" + lfdDatum.getTimeInMillis() +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_auftrag_neu.png") + "</a></td>";
					ret += "<td><a href=\"an0:" + lfdDatum.getTimeInMillis() +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_anfrage_neu.png") + "</a></td>";
					ret += "</tr></table>";
				}				
			}else {
				if(!rz.isMain() && anzeige) {
					if(lfdDatum.getTimeInMillis()>=today.getTimeInMillis() && !rz.getDatabase().getKalender().isFeiertag(lfdDatum)) {
						ret += "<table style=\"border-style:solid;border-width:1px;\"><tr>";
						ret += "<td><a href=\"an0:" + lfdDatum.getTimeInMillis() +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_anfrage_neu.png") + "</a></td>";
						ret += "</tr></table>";
					}
				}
			}
			ret += "</td>";
				ret += "<table><tr>";
					ret += "<td align=\"right\"><b><font color=#0000ff>" + lfdDatum.get(Calendar.DAY_OF_YEAR) + "</font></td></b><tr>";
 					ret += "<td align=\"right\"><b><font color=#ff8800>" + rz.getDatabase().getKalender().getYear20(lfdDatum)+"</font>"+
 						   "<font color=#008800>" + rz.getDatabase().getKalender().getDate20(lfdDatum) + "</font><br></b></td>";
 				ret += "</tr></table>";
		ret += "</tr></table>";
		ret += getTerminCell(lfdDatum);
		ret += getAuftragCell(lfdDatum);
		return ret;
	}
	
	private String getTerminCell(Calendar lfdDatum) {
		String ret = "";
		if(rz.isMain() && anzeige) {
			if(rz.getDatabase().getKalender().getTermine() != null) {
				termine = rz.getDatabase().getKalender().getTermine();
				if(!termine.isEmpty()) {
					ret+="<table style=\"font-size:" + String.valueOf(fontsize) +"pt;\">";
					for(int k =0;k< termine.size();k++) {
						if(lfdDatum.getTimeInMillis() == termine.getItem(k).getFaellig().getTimeInMillis()) {
							TerminItem ti = termine.getItem(k);
							ret +="<tr>";
							if(rz.isMain()) {
								ret+="<table style=\"border-style:solid;border-width:1px;background-color:#" +(ti.isErledigt()?COLOR_TERMIN_ERLEDIGT_BG:ti.getHg())+   ";color:#" +(ti.isErledigt()?COLOR_TERMIN_ERLEDIGT_FG:ti.getVg())+"\"><tr>";
								ret+="<td><a href=\"ted:" + String.valueOf(ti.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_edit_termin.png") + "</a></td>";
								ret+="<td><a href=\"txx:" + String.valueOf(ti.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_delete_termin.png") + "</a></td>";
								if(!ti.isErledigt()) {
									ret+="<td><a href=\"ter:" + String.valueOf(ti.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_termin_erledigen.png") + "</a></td>";
								} else {
									ret+="<td><a href=\"teu:" + String.valueOf(ti.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_termin_unerledigen.png") + "</a></td>";
								}
								ret+="</table>";
							}
							ret+="<td style=\"background-color:#" + (ti.isErledigt()?COLOR_TERMIN_ERLEDIGT_BG:ti.getHg())+   ";color:#" +(ti.isErledigt()?COLOR_TERMIN_ERLEDIGT_FG:ti.getVg())+"border:solid;border-width:1px;text-align:center;\">";	
							if(rz.isMain() && ti.isEigen()) {
								ret += rz.getAusgabeFactory().insertGfx("kalender.icon_eigen.png");
							}
							ret += "<a href=\"tsh:" + String.valueOf(ti.getId()) +"\">"  ;
							ret +=  ti.getBezeichnung() + "<br></b></a>";
							ret += "</td>";
							ret +="</tr>";
						}
					}
					ret+="</table>";
				}
			}
		}
		return ret;
	}
	
	private String getAuftragCell(Calendar lfdDatum) {
		String ret="";
		if(anzeige) {
			if(rz.getDatabase().getAuftrag().getAuftraege() !=null) {
				Auftragsliste liste = rz.getDatabase().getAuftrag().getAuftraege().getAuftraege(lfdDatum.getTimeInMillis());
				if(!liste.isEmpty()) {
					ret+="<table style=\"border-style:solid;border-width:1px;font-size:" + String.valueOf(fontsize) +"pt;\">";
					for(int j=0;j<liste.size();j++) {
						AuftragsItem ai=liste.getItem(j);
						ret +="<tr>";
							if(rz.isMain()) {
								ret+="<table style=\"border-style:solid;border-width:1px;background-color:#" + ai.getHg()+   ";color:#" +ai.getVg()+"\"><tr>";	
								if(!ai.isErledigt()) {
									if(!ai.isArbeitsAuftrag()) {
										ret+="<td><a href=\"rec:" + String.valueOf(ai.getRezeptur_id()) +"§" + Double.toString(Math.floor(ai.getLiter())) +"§"+ai.getBezeichnung() +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_rechnen.png") + "</a></td><";
									}
								}
								if(ai.isAnfrage()) {
									ret+="<td><a href=\"auf:" + String.valueOf(ai.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_anfrage_bearbeiten.png") + "</a></td>";
								}else {
									ret+="<td><a href=\"auf:" + String.valueOf(ai.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_auftrag_bearbeiten.png") + "</a></td>";
								}
								
								if(ai.isRepeat()) {
									ret+="<td>" + rz.getAusgabeFactory().insertGfx("kalender.icon_repeat.png") + "</td>";		
								} else {
									ret+="<td><a href=\"ade:" + String.valueOf(ai.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_delete_anfrage.png") + "</a></td>";		
								}
								ret+="</tr></table>";
							} else {
								ret+="<table style=\"border-style:none;border-width:0px;background-color:#" + ai.getHg()+   ";color:#" +ai.getVg() +"\"><tr><td></td><td></td></tr></table>";
								if(ai.isAnfrage()) {
									ret+="<table style=\"border-style:solid;border-width:1px;background-color:#" + ai.getHg()+   ";color:#" +ai.getVg()+"\"><tr>";
									ret+="<td><a href=\"auf:" + String.valueOf(ai.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_anfrage_bearbeiten.png") + "</a></td>";	
									ret+="<td><a href=\"ade:" + String.valueOf(ai.getId()) +"\">" + rz.getAusgabeFactory().insertGfx("kalender.icon_delete_anfrage.png") + "</a></td>";		
									ret+="</tr></table>";
								}
							}
							ret+="<td style=\"background-color:#" + ai.getHg() +   ";color:#" +ai.getVg()+";border:solid;border-width:1px;text-align:center;\">";	
							if(rz.isMain() && !ai.getGruppe().equals("")) {
								ret += rz.getAusgabeFactory().insertGfx("kalender.icon_gruppe.png");
								ret += ai.getGruppe()+"<br>";
							}
							if(rz.isMain() && ai.isEigen()) {
								ret += rz.getAusgabeFactory().insertGfx("kalender.icon_eigen.png");
							}
							if(ai.isInarbeit()) {
								ret += rz.getAusgabeFactory().insertGfx("kalender.icon_inarbeit.png");
							}
							ret += "<a href=\"adp:" + String.valueOf(ai.getId()) +"\">"  ;
							if(rz.isMain()) {
								if(!ai.isArbeitsAuftrag()) {
									ret += "<font color=#"+ai.getVg() +">"+rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "<br>"+ ai.getBezeichnung() + "</b></font></a>";
								} else {
									ret += "<b><font color=#" +ai.getVg()+";background-color=#"+ai.getHg() +">" + ai.getBezeichnung() + "</font></b></a>";
								}
							}else{
								if(!ai.isArbeitsAuftrag()) {
									ret += rz.getLocale().formatNumber(ai.getLiter(), OptionFactory.NF_ONE) + " " + rz.getLocale().getString("string_liter") + "<br>"+ ai.getBezeichnung() + "</b></a>";
								}
							}
							if(ai.isAnfrage() && !ai.isErledigt()) {
								ret +="<br>" + rz.getLocale().getString("kalender.string_anfrage").replaceAll("%s",ai.getErstellt_user()) + "";
							}
							if(ai.isErledigt()) {
								ret += "<br><b>" + rz.getAusgabeFactory().insertGfx("kalender.icon_erledigt.png") + " " + ai.getErledigtToString() + "</b>";
							} else {
								if (!ai.getArbeit_user().trim().equals("")) {
									ret += "<br>(" + ai.getArbeit_user() + ")</b>";
								}
								if(!ai.getTank().equals("")) {
									ret += "<br>" + rz.getLocale().getString("kalender.auftragliste.tank") + ai.getTank();
								}
							}
						ret += "</td>";
						ret+="</tr>";
					}
					ret+="</table>";
				}
			}
		}
		return ret;
	}
	
	/*
	 * Wochenkalender
	 */
	private String getWochenKalender() {
		String ret="";
		
		return ret;
	}
	/*
	 * 2wochenkalender
	 */
	private String get2WochenKalender() {
		String ret="";
		
		return ret;
	}
}
