package de.lunqual.rzpro.items.konform;

import java.text.SimpleDateFormat;
import java.util.Date;


public class konformItem {

	boolean					konform;
	int 							rezeptur_id;
	String						rezepturBezeichnung;
	Date							datum;
	String						bemerkungen;
	SimpleDateFormat	df;
	
	private static final String DATE_FORMAT = "EEEE, dd. MMMM yyyy";
	
	public konformItem() {
		df = new SimpleDateFormat(DATE_FORMAT);
		this.rezeptur_id = 0;
		this.rezepturBezeichnung = "";
		this.datum = null;
		this.bemerkungen = "";
	}
	
	public konformItem(boolean konform, int rezeptur_id,String rezepturBezeichnung, Date datum, String bemerkungen) {
		super();
		df = new SimpleDateFormat(DATE_FORMAT);
		this.konform = konform;
		this.rezeptur_id = rezeptur_id;
		this.rezepturBezeichnung = rezepturBezeichnung;
		this.datum = datum;
		this.bemerkungen = bemerkungen;
	}

	public boolean isKonform() {
		return konform;
	}
	public int getRezeptur_id() {
		return rezeptur_id;
	}
	public String getRezepturBezeichnung() {
		return rezepturBezeichnung;
	}
	public Date getDatum() {
		return datum;
	}
	public String getBemerkungen() {
		return bemerkungen;
	}

	public void setKonform(boolean konform) {
		this.konform = konform;
	}

	public void setRezeptur_id(int rezeptur_id) {
		this.rezeptur_id = rezeptur_id;
	}

	public void setRezepturBezeichnung(String rezepturBezeichnung) {
		this.rezepturBezeichnung = rezepturBezeichnung;
	}

	public void setDatum(Date datum) {
		this.datum = datum;
	}

	public void setBemerkungen(String bezeichnung) {
		this.bemerkungen = bezeichnung;
	}
	
	public String getDatumString() {
		return datum == null?"":df.format(datum);
	}
	
}
