package de.lunqual.rzpro.items.kontrakt;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class kontraktStatistikItem {
	RzPro rz;
	kontraktItem ki;
	ArrayList<kontraktStatistikZeilenItem> liste;
	
	public kontraktStatistikItem(RzPro rz, kontraktItem ki) {
		super();
		this.rz = rz;
		this.ki = ki;
		liste = rz.getDatabase().getKontrakte().getAbgerufenStatistik(ki);
	}
	
	public boolean hasElements() {
		return (liste != null && liste.size()>0)?true:false;
	}
	
	public String getHTMLString() {
		String ret = "<html><br>";
		if(liste != null && liste.size() > 0) {
			ret += "<table border=\"1\"><tr>";
			for(kontraktStatistikZeilenItem kz: liste) {
				ret += "<td align=\"right\">" + kz.getMonatString() + "</td>";
				ret += "<td>" + kz.getJahr() + "</td>";
				ret += "<td align=\"right\">" + rz.getLocale().formatNumber(kz.getValue(), OptionFactory.NF_ONE) + "</td>";
				ret += "<td>" + ki.getEinheitsItem().getName() + "</td>"; 
				ret += "</tr><tr>";
			}
			ret +="</tr></table>";
		}
		return ret + "<br></html>";
		
	}
	
	
	
}
