package de.lunqual.rzpro.items.laborwerte;

import java.math.BigDecimal;
import java.math.RoundingMode;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class LaborwertValueItem {
		RzPro		rz;
		int 		id;
		int			laborwert;
		int			rezeptur;
		double 		value;
		String 		rezepturBezeichnung;
		String 		lbwBezeichnung;
		int 		einheit1;
		int 		einheit2;
		String		strEinheit1;
		String     	strEinheit2;
		double 		menge;
		double 		liter;
		double 		kg;
		double 		la;
		boolean		spezifikation;
		int			ausgabeeinheit;
		boolean		fix;
		boolean		berechnet;

		public LaborwertValueItem(RzPro rz,int id, int laborwert, int rezeptur,
				double value, String rezepturBezeichnung, String lbwBezeichnung,
				int einheit1, int einheit2,boolean spezifikation,int ausgabeeinheit,boolean fix) {
			super();
			this.rz = rz;
			this.id = id;
			this.laborwert = laborwert;
			this.rezeptur = rezeptur;
			this.value = value;
			this.rezepturBezeichnung = rezepturBezeichnung;
			this.lbwBezeichnung = lbwBezeichnung;
			this.einheit1 = einheit1;
			this.einheit2 = einheit2;
			this.strEinheit1=rz.getDatabase().getEinheiten().getEinheit(this.einheit1).getName();
			this.strEinheit2=rz.getDatabase().getEinheiten().getGrundEinheit(this.einheit2).getName();
			this.spezifikation=spezifikation;
			this.ausgabeeinheit=ausgabeeinheit;
			this.fix=fix;
			this.berechnet  = false;
		}

		
		
		
		public boolean isBerechnet() {
			return berechnet;
		}




		public void setBerechnet(boolean berechnet) {
			this.berechnet = berechnet;
		}




		public boolean isFix() {
			return fix;
		}




		public void setFix(boolean fix) {
			this.fix = fix;
		}




		public int getAusgabeeinheit() {
			return ausgabeeinheit;
		}

		public String getStrAusgabeeinheit() {
			return rz.getDatabase().getEinheiten().getEinheit(this.ausgabeeinheit).getName();
		}


		public void setAusgabeeinheit(int ausgabeeinheit) {
			this.ausgabeeinheit = ausgabeeinheit;
		}




		public boolean isSpezifikation() {
			return spezifikation;
		}

		public void setSpezifikation(boolean spezifikation) {
			this.spezifikation = spezifikation;
		}

		public int getId() {
			return id;
		}

		public void setId(int id) {
			this.id = id;
		}

		public int getLaborwert() {
			return laborwert;
		}

		public void setLaborwert(int laborwert) {
			this.laborwert = laborwert;
		}

		public int getRezeptur() {
			return rezeptur;
		}

		public void setRezeptur(int rezeptur) {
			this.rezeptur = rezeptur;
		}

		public double getValue() {
		    BigDecimal bd = new BigDecimal(Double.toString(value));
		    bd = bd.setScale(rz.getOptionFactory().getOption("laborwerte.decimal_digits",OptionFactory.LABORWERTE_DECIMAL_DIGITS), RoundingMode.HALF_UP);
		    return bd.doubleValue();
		}

		public void setValue(double value) {
			this.value = value;
		}

		public String getRezepturBezeichnung() {
			return rezepturBezeichnung;
		}

		public void setRezepturezeichnung(String rezepturBezeichnung) {
			this.rezepturBezeichnung = rezepturBezeichnung;
		}

		public String getLbwBezeichnung() {
			return lbwBezeichnung;
		}

		public void setLbwBezeichnung(String lbwBezeichnung) {
			this.lbwBezeichnung = lbwBezeichnung;
		}

		public int getEinheit1() {
			return einheit1;
		}

		public void setEinheit1(int einheit1) {
			this.einheit1 = einheit1;
			this.strEinheit1=rz.getDatabase().getEinheiten().getEinheit(this.einheit1).getName();
		}

		public int getEinheit2() {
			return einheit2;
		}

		public void setEinheit2(int einheit2) {
			this.einheit2 = einheit2;
			this.strEinheit2=rz.getDatabase().getEinheiten().getGrundEinheit(this.einheit2).getName();
		}

		public String getStrEinheit1() {
			return strEinheit1;
		}

		public void setStrEinheit1(String strEinheit1) {
			this.strEinheit1 = strEinheit1;
		}

		public String getStrEinheit2() {
			return strEinheit2;
		}

		public void setStrEinheit2(String strEinheit2) {
			this.strEinheit2 = strEinheit2;
		}

		public void setRezepturBezeichnung(String rezepturBezeichnung) {
			this.rezepturBezeichnung = rezepturBezeichnung;
		}

		public void setMenge(double menge) {
			this.menge = menge;
		}

		public double getMenge() {
			return menge;
		}

		public double getLiter() {
			return liter;
		}

		public void setLiter(double liter) {
			this.liter = liter;
		}

		public double getKg() {
			return kg;
		}

		public void setKg(double kg) {
			this.kg = kg;
		}

		public double getLa() {
			return la;
		}

		public void setLa(double la) {
			this.la = la;
		}

		public double getRezepturMenge() {
			double v=0.0;
			switch (this.einheit2) {
				case RzPro.EINHEIT_KG:v= this.kg;break;
				case RzPro.EINHEIT_LITER:v= this.liter;break;
				case RzPro.EINHEIT_LA:v= this.la;break;
			}
			return v;
		}

}
