package de.lunqual.rzpro.items.laborwerte;

import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.rechnen.RechenItem;
public class LaborwertValueListe extends ArrayList{

	RzPro 	rz;
	RechenItem ri;
	int einheit;
	String	laborwert;
	double summe_liter;
	double summe_kg;
	double summe_la;

	double value_liter;
	double value_kg;
	double value_la;
	

	public LaborwertValueListe(RzPro rz,RechenItem ri,int einheit,String laborwert) {
		super();
		this.rz = rz;
		this.ri = ri;
		this.einheit=einheit;
		this.laborwert=laborwert;
	}

	public LaborwertValueItem getItem(int i) {
		return (LaborwertValueItem)this.get(i);
	}

	public void addItem(LaborwertValueItem l) {
		this.add(l);
	}

	public LaborwertValueItem getItemByID(int rezeptur) {
		LaborwertValueItem ret = null;
		for(int i=0;i < this.size();i++) {
			if(this.getItem(i).getRezeptur() == rezeptur) {
				ret = this.getItem(i);
				break;
			}
		}
		return ret;
	}

	public String getLaborwert() {
		return laborwert;
	}
	
	public String getRezepturBezeichnung() {
		return ri.getRezeptur().getTitel();
	}
	
	public int getRezeptur() {
		return ri.getRezeptur().getID();
	}

	public void rechnen() {
		summe_liter=ri.getGesamtLiter();
		summe_kg = ri.getGesamtKg();
		summe_la=ri.getGesamtLA();
		value_liter =0.0;
		value_kg=0.0;
		value_la=0.0;
		/**
		 * Rezeptur == -1 bedeutet das Verschnittwasser
		 */
		for (int i = 0;i < this.size();i++) {
			final LaborwertValueItem vi = this.getItem(i);
			if(vi.isFix()) {
				value_liter=0;
				value_la=0;
				value_kg=0;
			} else {
				switch(einheit) {
					case RzPro.EINHEIT_LITER:
						vi.setMenge(vi.getLiter() * vi.getValue());
							value_liter+=vi.getMenge();
						break;
					case RzPro.EINHEIT_LA:
						vi.setMenge(vi.getLa() * vi.getValue());
							value_la+=vi.getMenge();
						break;
					case RzPro.EINHEIT_KG:
						vi.setMenge(vi.getKg() * vi.getValue());
							value_kg += vi.getMenge();
						break;
				}
		}
		}
	}

	public int getEinheit() {
		return einheit;
	}

	public void setEinheit(int einheit) {
		this.einheit = einheit;
	}

	public double getSumme_liter() {
		return summe_liter;
	}

	public void setSumme_liter(double summe_liter) {
		this.summe_liter = summe_liter;
	}

	public double getSumme_kg() {
		return summe_kg;
	}

	public void setSumme_kg(double summe_kg) {
		this.summe_kg = summe_kg;
	}

	public double getSumme_la() {
		return summe_la;
	}

	public void setSumme_la(double summe_la) {
		this.summe_la = summe_la;
	}

	public double getValue_liter() {
		return value_liter;
	}

	public void setValue_liter(double value_liter) {
		this.value_liter = value_liter;
	}

	public double getValue_kg() {
		return value_kg;
	}

	public void setValue_kg(double value_kg) {
		this.value_kg = value_kg;
	}

	public double getValue_la() {
		return value_la;
	}

	public void setValue_la(double value_la) {
		this.value_la = value_la;
	}

}
