/*
 * Created on 29.11.2004
 *
 */
package de.lunqual.rzpro.items.lager;

import java.math.BigDecimal;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */

public class LagerBestandsListe extends ArrayList {
    String lager;
    double summe_liter;
    double summe_kg;
    double summe_la;
    BigDecimal summe_kalkulation;

    public LagerBestandsListe(String lager) {
        super();
        this.lager=lager;
        summe_kalkulation = new BigDecimal(0);
    }

    public void addItem(LagerBestandsItem lb) {
        this.add(lb);
    }

    public LagerBestandsItem getItem(int i) {
        return (LagerBestandsItem)this.get(i);
    }


    public void addLiter(double liter) {
        summe_liter += liter;
    }
    public void addKg(double kg) {
        summe_kg += kg;
    }
    public void addLa(double la) {
        summe_la += la;
    }
    public void addPreis(BigDecimal preis) {
       summe_kalkulation = summe_kalkulation.add(preis);
    }
    public double getSumme_liter() {
        return summe_liter;
    }
    public double getSumme_kg() {
        return summe_kg;
    }
    public double getSumme_la() {
        return summe_la;
    }

    public BigDecimal getSumme_kalkulation() {
        return summe_kalkulation.setScale(RzPro.CURRENCY_DEFAULT_SCALE,java.math.BigDecimal.ROUND_HALF_UP);
    }

    public String getLager() {
        return lager;
    }
}
