/*
 * Created on 22.09.2004
 *
 */
package de.lunqual.rzpro.items.lieferschein;

import java.rmi.server.UID;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;

/**
 * @author labor
 *
 */
public class AuftragsListe extends ArrayList {

    public static final int			MODE_ALLE = 0;
    public static final int			MODE_NEUE = 1;

    RzPro									rz;
    /**
     *
     */
    public AuftragsListe(RzPro rz) {
        super();
        this.rz = rz;
    }

    public void addContainer(LieferscheinZeile zl) {
        if(this.size() == 0) {
            addAuftrag(zl);
        }else {
            boolean added = false;
            for(int i = 0;i < this.size();i++) {
                if((this.getItem(i).getBezeichnung().equalsIgnoreCase(zl.getBezeichnung()))&&(this.getItem(i).getStaerke() == zl.getStaerke())) {
                    this.getItem(i).addContainer(zl);
                    added=true;
                    break;
                }
            }
            if(!added) {
                addAuftrag(zl);
            }
        }
    }

    @Override
	public void clear() {
        for(int i =0;i < this.size();i++) {
            this.getItem(i).getZeilenListe().clear();
        }
        super.clear();
    }
    public LieferscheinAuftrag getItem(int i) {
        return (LieferscheinAuftrag)this.get(i);
    }

    private void addAuftrag(LieferscheinZeile zl) {
        final LieferscheinAuftrag la = new LieferscheinAuftrag(rz);
        la.setBezeichnung(zl.getBezeichnung());
        if((la.getStaerke() == 0) && (zl.getTyp() == LieferscheinZeile.ZEILE_CONTAINER)) {
            la.setStaerke(zl.getStaerke());
        }
        la.addContainer(zl);
        this.add(la);
    }

    public int getRowCount() {
        int count = 0;
        if(this.size() != 0) {
            for(int i = 0;i < this.size();i++) {
                count += this.getItem(i).getZeilenListe().size()+1;
            }
        }
        return count;
    }

    public LieferscheinZeile getRow(int row) {
        int r = 0;
        for(int i = 0;i < this.size();i++) {
            for(int j=0;j < this.getItem(i).getZeilenListe().size();j++) {
                r++;
                if(r==row) {
                    return this.getItem(i).getZeilenListe().getItem(j);
                }
            }
        }
        return null;
    }

    public void removeContainer(LieferscheinZeile zl) {
        int i;
        int numContainer = 0;
        for( i = 0;i < this.size();i++) {
            final LieferscheinAuftrag z = this.getItem(i);
                if( z.getZeilenListe().remove(zl)) {
                    z.rechnen();
    	            for(i = 0;i < z.getZeilenListe().size();i++) {
    	                if((z.getZeilenListe().getItem(i)).getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
							numContainer++;
						}
    	            }
    	            if(numContainer == 0) {
    	                removeAuftrag(z.getUid());
    	            }
                }
            }
        }

    public LieferscheinAuftrag getAuftrag(UID uid) {
    	for(int i = 0;i < this.size();i++) {
    		if((this.getItem(i)).getUid().equals(uid)) {
    			return this.getItem(i);
    		}
    	}
    	return null;
    }

    public void removeAuftrag(UID uid) {
        for(int i = 0;i < this.size();i++) {
            final LieferscheinAuftrag z = this.getItem(i);
            if (z.getUid() == uid) {
                this.remove(z);
            }
        }
    }

    public ArrayList getContainerListe(int mode) {
        final ArrayList al = new ArrayList();
        for (int i = 0;i < this.size();i++) {
            final LieferscheinAuftrag auftrag = this.getItem(i);
            for(int j = 0;j < auftrag.getZeilenListe().size();j++) {
                if(auftrag.getZeilenListe().getItem(j).getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
                    switch(mode) {
                    	case MODE_ALLE :
                    	    al.add(auftrag.getZeilenListe().getItem(j));
                    	    break;
                    	case MODE_NEUE:
                    	    if(auftrag.getZeilenListe().getItem(j).getId() == 0) {
                    	        al.add(auftrag.getZeilenListe().getItem(j));
                    	    }
                    	    break;
                    }
                }
            }
        }
        return al;
    }

    /**
     * gibt den Container mit der id ID zurück, oder null, wenn die id nicht existiert;
     * @param id
     * @return LieferscheinZeile oder null
     */
    public LieferscheinZeile getContainer(int id) {
        for (int i = 0;i < this.size();i++) {
            final LieferscheinAuftrag auftrag = this.getItem(i);
            for(int j = 0;j < auftrag.getZeilenListe().size();j++) {
                if(auftrag.getZeilenListe().getItem(j).getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
                   if(id == auftrag.getZeilenListe().getItem(j).getId()) {
                       return auftrag.getZeilenListe().getItem(j);
                   }
                }
            }
        }
        return null;
    }

}
