/*
 * Created on 22.09.2004
 *
 */
package de.lunqual.rzpro.items.lieferschein;

import java.math.BigDecimal;
import java.rmi.server.UID;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.fensterfactory.FensterFactory;
import de.lunqual.rzpro.items.etiketten.EtikettenItem;
import de.lunqual.rzpro.items.etiketten.EtikettenListe;
import de.lunqual.rzpro.items.message.MessageItem;
import de.lunqual.rzpro.items.rezeptur.RezepturItem;
import de.lunqual.rzpro.options.OptionFactory;


/**
 * @author labor
 *
 */
public class LieferscheinAuftrag {

    LieferscheinZeilenListe		zeilenListe;
    LieferscheinZeile					summe;
    LieferscheinZeile					kopf;
    RezepturItem							rezeptur;
    String											bezeichnung;
    double										staerke;
    double										litergewicht;
    Collator        								coll;
    Comparator      						comp;
    UID												uid;
    RzPro											rz;
    boolean									bestandWarnung;
    double										bestand;
    double 										openLiter;
    boolean										probe;
    Date												erstellt;
    /**
     *
     */
    public LieferscheinAuftrag(RzPro rz) {
    	this.rz = rz;
        uid = new UID();
        this.erstellt=new Date();
        zeilenListe = new LieferscheinZeilenListe();

        kopf = new LieferscheinZeile(rz);
        kopf.setTyp(LieferscheinZeile.ZEILE_KOPF);
        kopf.setUid(uid);

        summe = new LieferscheinZeile(rz);
        summe.setTyp(LieferscheinZeile.ZEILE_SUMME);
        summe.setUid(uid);

        final LieferscheinZeile zl = new LieferscheinZeile(rz);
        zl.setTyp(LieferscheinZeile.ZEILE_LEER);
        zeilenListe.addItem(kopf);
        zeilenListe.addItem(summe);
        zeilenListe.addItem(zl);
        coll = Collator.getInstance(Locale.getDefault());
        comp = new Comparator(){
            public int compare(Object o1,Object o2){
                int n1,n2;
                final LieferscheinZeile z1 = (LieferscheinZeile)o1;
                final LieferscheinZeile z2 = (LieferscheinZeile)o2;
                if((z1.getTyp() == LieferscheinZeile.ZEILE_CONTAINER) && (z2.getTyp() == LieferscheinZeile.ZEILE_CONTAINER)) {
	                try {
	                    n1 = Integer.parseInt( z1.getContainerS().replaceAll("\\D","").replaceAll("\\s", ""));
	                } catch (final NumberFormatException e) {
	                    n1=0;
	                }
	                try {
	                    n2 = Integer.parseInt( z2.getContainerS().replaceAll("\\D","").replaceAll("\\s", ""));
	                } catch (final NumberFormatException e) {
	                    n2=0;
	                }
	                return n1-n2;
                } else {
                    return 0;
                }
            }
        };
        probe=false;
    }

	public boolean isProbe() {
		return probe;
	}



	public void setProbe(boolean probe) {
		this.probe = probe;
	}



	public void addContainer(LieferscheinZeile zl){
        zl.setUid(uid);
        final LieferscheinZeile z = getContainer(zl.getContainerS());
        if(z != null) {
            zl.copyToItem(z);
        } else {
            zeilenListe.addItem(zl);
        }
        rechnen();
    }

    private LieferscheinZeile getContainer(String nummer) {
        if(nummer != null) {
	        for(int i = 0;i < zeilenListe.size();i++) {
	            if(zeilenListe.getItem(i).getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
		            if(zeilenListe.getItem(i).getContainerS().equalsIgnoreCase(nummer.trim())) {
		                return zeilenListe.getItem(i);
		            }
	            }
	        }
        }
        return null;
    }

    public void deleteContainer(String nummer) {
        for(int i = 0;i < zeilenListe.size();i++) {
            if(zeilenListe.getItem(i).getContainerS().trim().equalsIgnoreCase(nummer.trim())) {
                zeilenListe.remove(i);
                break;
            }
        }
        rechnen();
    }

    public void rechnen() {
    	rezeptur =null;
    	bestand=0.0;
    	openLiter=0.0;
        Collections.sort(zeilenListe, comp);
        BigDecimal brutto = new BigDecimal(0.0);
        BigDecimal netto= new BigDecimal(0.0);
        BigDecimal tara= new BigDecimal(0.0);
        BigDecimal liter= new BigDecimal(0.0);
        BigDecimal kg= new BigDecimal(0.0);
        BigDecimal la= new BigDecimal(0.0);
        for(int i = 0; i < zeilenListe.size();i++) {
            if(zeilenListe.getItem(i).getTyp() == LieferscheinZeile.ZEILE_CONTAINER) {
            	if(rezeptur == null) {
					rezeptur = zeilenListe.getItem(i).getRezeptur();
				}
	            brutto = brutto.add(new BigDecimal(zeilenListe.getItem(i).getBrutto())).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP);
	            netto = netto.add(new BigDecimal(zeilenListe.getItem(i).getNetto())).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP);
	            tara = tara.add(new BigDecimal(zeilenListe.getItem(i).getTara())).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP);
	            liter = liter.add(new BigDecimal(zeilenListe.getItem(i).getLiter())).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP);
	            kg = kg.add(new BigDecimal(zeilenListe.getItem(i).getKg())).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP);
	            la = la.add(new BigDecimal(zeilenListe.getItem(i).getLa())).setScale(rz.getLocale().getNumberFormat(OptionFactory.NF_LIEFERSCHEIN).getMaximumFractionDigits(),BigDecimal.ROUND_HALF_UP);
	            openLiter += zeilenListe.getItem(i).getOpenLiter();
            }
        }
        summe.setBrutto(brutto.doubleValue());
        summe.setNetto(netto.doubleValue());
        summe.setTara(tara.doubleValue());
        summe.setLiter(liter.doubleValue());
        summe.setKg(kg.doubleValue());
        summe.setLa(la.doubleValue());
        summe.setOpenLiter(openLiter); 
        if(rezeptur != null) {
        	if(rezeptur.getID() != 0) {
        		rezeptur = rz.getDatabase().getRezeptur().dbGetRezeptur(rezeptur.getID(),true);
	        	summe.setRezeptur(rezeptur);
	 		   	bestand = rz.getDatabase().getEinheiten().toLiter(rezeptur.getBestand(),staerke,litergewicht, rz.getDatabase().getEinheiten().getGrundeinheit(rezeptur.getBestandseinheit()));
	 		   	//rezeptur.setBestand(bestand);
	 		   	if(  (bestand - summe.getOpenLiter()) <0) {
	 		   		if(rz.isZero(bestand - summe.getOpenLiter())) {
	 		   			bestandWarnung=false;
	 		   		} else {
	 		   			bestandWarnung=true;
	 		   		}
	 		   	} else {
	 		   		bestandWarnung= false;
	 		   }
        	}
        }
    }

    public void etikettenDruck(boolean abfuelltag) {
    	final EtikettenListe ei = new EtikettenListe();
    	ei.setBogen(rz.getDatabase().getEtiketten().getBogen(rz.getOptionFactory().getOption("etiketten.bogen",1)));
		for(int j = 0;j < this.getZeilenListe().size();j++) {
			final LieferscheinZeile zl = this.getZeilenListe().getItem(j);
			if((zl != null) && (zl.getTyp() == LieferscheinZeile.ZEILE_CONTAINER)) {
				final EtikettenItem eti = new EtikettenItem(rz);
				eti.setZeile(0,zl.getBezeichnung() + " (" +
					rz.getLocale().formatNumber(zl.getStaerke(),OptionFactory.NF_STAERKE) + " " +
					rz.getLocale().getString("string_prozentvol") + ")");
				eti.setZeile(1,rz.getLocale().getString("etiketten.string_nummer") + zl.getContainerS() + " " +
						rz.getLocale().getString("etiketten.string_losnummer") + zl.getLosnummer(erstellt,abfuelltag));
				eti.setZeile(2,rz.getLocale().getString("string_brutto") + " " + rz.getLocale().formatNumber(zl.getBrutto(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg") + ", " +
						 rz.getLocale().getString("string_tara") + " " + rz.getLocale().formatNumber(zl.getTara(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg"));
				eti.setZeile(3,rz.getLocale().getString("string_netto") + " " + rz.getLocale().formatNumber(zl.getNetto(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_kg"));
				eti.setZeile(4,rz.getLocale().formatNumber(zl.getLiter(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_liter") +", " +
					 rz.getLocale().formatNumber(zl.getLa(),OptionFactory.NF_LIEFERSCHEIN) + rz.getLocale().getString("string_la"));
				eti.setLosnummer(zl.getLosnummer(erstellt,abfuelltag));
				eti.setImage(ei.getBogen().getImage());
				eti.setEan(zl.getEan());
				ei.addItem(eti);
			}
    	}
    	if(ei.size() != 0) {
            rz.getFensterFactory().getFensterListe().createWindow(FensterFactory.FENSTER_ETIKETTEN, true,new MessageItem(MessageItem.MSG_ADD_ETIKETTENLISTE,0,ei,null));
    	}
    }

    public LieferscheinZeile getSumme() {
        return summe;
    }
    public void setSumme(LieferscheinZeile summe) {
        this.summe = summe;
    }
    public LieferscheinZeilenListe getZeilenListe() {
        return zeilenListe;
    }
    public void setZeilenListe(LieferscheinZeilenListe zeilenListe) {
        this.zeilenListe = zeilenListe;
    }

    public String getBezeichnung() {
        return bezeichnung;
    }
    public void setBezeichnung(String bezeichnung) {
        this.bezeichnung = bezeichnung;
    }
    public double getStaerke() {
        return staerke;
    }
    public void setStaerke(double staerke) {
        this.staerke = staerke;
    }

    public UID getUid() {
        return uid;
    }
    public void setUid(UID uid) {
        this.uid =uid;
    }

	public boolean isBestandWarnung() {
		return bestandWarnung;
	}

	public double getLitergewicht() {
		return litergewicht;
	}
	public void setLitergewicht(double litergewicht) {
		this.litergewicht = litergewicht;
	}
	public RezepturItem getRezeptur() {
		return rezeptur;
	}
	
	public double getBestand() {
		return bestand;
	}
}
