/*
 * Created on 02.01.2005
 *
 */
package de.lunqual.rzpro.items.log;

import java.util.Date;

import de.lunqual.rzpro.RzPro;

/**
 * @author lunqual
 *
 */
public class LoggingItem {

	RzPro			rz;
	Date				timestamp;
	int 				level;
	String			origin;
	String			message;

	public LoggingItem(RzPro r,int level,String origin,String message) {
		rz=r;
		this.timestamp = new Date();
		this.level=level;
		this.origin=origin;
		this.message=message;
	}


	public int getLevel() {
		return level;
	}
	public String getMessage() {
		return message;
	}
	public String getOrigin() {
		return origin;
	}
	public Date getTimestamp() {
		return timestamp;
	}
	public String getLevelString() {
		switch (level) {
			case 0: return rz.getLocale().getString("logging.string_0");
			case 1: return rz.getLocale().getString("logging.string_1");
			case 2: return rz.getLocale().getString("logging.string_2");
			case 3: return rz.getLocale().getString("logging.string_3");
			default: return rz.getLocale().getString("logging.string_0");
		}
	}
}
