package de.lunqual.rzpro.items.mischungen;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

public class TicketItem {

	public static final int			TYP_INVALID 			= 0;
	public static final int			TYP_WARE		 		= 1;
	public static final int			TYP_TEXT				= 2;
	public static final int			TYP_GESPERRT			= 3;
	public static final int			TYP_ENTSPERRT			= 4;
	public static final int			TYP_FREIGABE			= 5;
	public static final int			TYP_FREIGABE_AUFHEBEN	= 6;	
	public static final int			TYP_ABSCHLUSS			= 7;
	public static final int			TYP_ENTNAHME			= 8;
	public static final int			TYP_UMPUMPEN			= 9;
	public static final int			TYP_ZUSAMMENFASSUNG 	= 10;
	public static final int			TYP_REST						=11;
	
	RzPro				rz;
	int					id;
	String				nummer;
	int					transaktion;
	int					typ;
	int					mischung;
	String				bezeichnung;
	int					rezeptur_id;
	String				bemerkungen;
	int					sorte;
	double 				la;
	double				staerke;
	Date				erstellt;
	String				erstellt_user;
	Date 				geaendert;
	String				geaendert_user;
	String				losnummer;
	String 				losnummer_original;
	SimpleDateFormat	df;
	double 				la_minus;
	String				adresse;
	int					adresse_id;
	double				percentage;
	double				negativePercentage;
	int						probe;
	int						bewertung;
	double				bewertungValue;
	boolean				entsperrt;
	String				kontrolle;
	Date					kontrolle_datum;
	

	public TicketItem(RzPro rz) {
		this.rz = rz;
		this.id = 0;
		this.nummer = "0";
		this.transaktion = 0;
		this.typ = TYP_INVALID; 
		this.mischung = 0;
		this.bezeichnung = "";
		this.rezeptur_id = 0;
		this.bemerkungen = "";
		this.sorte = 0;
		this.la = 0;
		this.la_minus = 0;
		this.staerke = 0;
		this.erstellt = rz.getDatabase().getServerTimestamp();
		this.erstellt_user = rz.getDatabase().dbGetUser();
		this.geaendert = rz.getDatabase().getServerTimestamp();
		this.geaendert_user = rz.getDatabase().dbGetUser();
		this.losnummer="";
		this.losnummer_original="";
    	df = new SimpleDateFormat("dd.MM.yyyy H:mm");
    	this.adresse="";
    	this.adresse_id=0;
    	this.probe = 0;
    	this.bewertung = 0;
    	this.bewertungValue = 0.0;
    	this.entsperrt=false;
    	this.kontrolle = "";
    	this.kontrolle_datum = new Date();
    	this.percentage=0.0;
    	this.negativePercentage=0.0;
	}


	public TicketItem(RzPro rz, int id, String nummer, int transaktion, int typ, int mischung, String bezeichnung, 
				int rezeptur_id, String bemerkungen, int sorte, double la, double staerke,String adresse,int adresse_id,
				Date erstellt, String erstellt_user, Date geaendert, String geaendert_user,String losnummer,String losnummer_original,
				int probe,int bewertung,double bewertungValue, String kontrolle, Date kontrolle_datum) {
		this.rz = rz;
		this.id = id;
		this.nummer = nummer;
		this.transaktion = transaktion;
		this.typ = typ;
		this.mischung = mischung;
		this.bezeichnung = bezeichnung;
		this.rezeptur_id = rezeptur_id;
		this.bemerkungen = bemerkungen;
		this.sorte = sorte;
		this.la = la;
		this.la_minus = 0;
		this.staerke = staerke;
		this.adresse=adresse;
		this.adresse_id=adresse_id;
		this.erstellt = erstellt;
		this.erstellt_user = erstellt_user;
		this.geaendert = geaendert;
		this.geaendert_user = geaendert_user;
		this.losnummer = losnummer;
		this.losnummer_original = losnummer_original;
		this.probe=probe;
		this.bewertung = bewertung;
		this.bewertungValue = bewertungValue;
		this.entsperrt=false;
    	df = new SimpleDateFormat("dd.MM.yyyy H:mm");
    	this.kontrolle = kontrolle;
    	this.kontrolle_datum = kontrolle_datum;
    	this.percentage=0.0;
    	this.negativePercentage=0.0;
	}

	
	
	public String getKontrolle() {
		return kontrolle;
	}


	public void setKontrolle(String kontrolle) {
		this.kontrolle = kontrolle;
	}


	public Date getKontrolle_datum() {
		return kontrolle_datum;
	}

	public String getKontrolle_datum_text() {
		return df.format(kontrolle_datum);
	}

	public void setKontrolle_datum(Date kontrolle_datum) {
		this.kontrolle_datum = kontrolle_datum;
	}
 
	

	public TicketItem clones() {
		return new TicketItem(rz,id,nummer,transaktion,typ,mischung,bezeichnung,rezeptur_id,bemerkungen,sorte,la,staerke,adresse,adresse_id,erstellt,erstellt_user,geaendert,geaendert_user,losnummer,losnummer_original,probe,bewertung,bewertungValue,kontrolle,kontrolle_datum);
	}
	
	public boolean isEntsperrt() {
		return entsperrt;
	}
	
	public void setEntsperrt(boolean entsperrt) {
		this.entsperrt=entsperrt;
	}
	
	public int getBewertung() {
		return bewertung;
	}


	public void setBewertung(int bewertung) {
		this.bewertung = bewertung;
	}

	public double getBewertungValue() {
		return bewertungValue;
	}


	public void setBewertungValue(double bewertungValue) {
		this.bewertungValue = bewertungValue;
	}


	public int getProbe() {
		return probe;
	}


	public void setProbe(int probe) {
		this.probe = probe;
	}


	public String getAdresse() {
		return adresse;
	}


	public void setAdresse(String adresse) {
		this.adresse = adresse;
	}


	public int getAdresse_id() {
		return adresse_id;
	}


	public void setAdresse_id(int adresse_id) {
		this.adresse_id = adresse_id;
	}


	public String getLosnummer_original() {
		return losnummer_original;
	}


	public void setLosnummer_original(String losnummer_original) {
		this.losnummer_original = losnummer_original;
	}

	public String getLosnummer() {
		return losnummer;
	}


	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}


	public String getNummer() {
		return nummer;
	}


	public void setNummer(String nummer) {
		this.nummer = nummer;
	}


	public int getId() {
		return id;
	}


	public void setId(int id) {
		this.id = id;
	}


	public int getTransaktion() {
		return transaktion;
	}


	public void setTransaktion(int transaktion) {
		this.transaktion = transaktion;
	}


	public int getTyp() {
		return typ;
	}


	public void setTyp(int typ) {
		this.typ = typ;
	}


	public int getMischung() {
		return mischung;
	}


	public void setMischung(int mischung) {
		this.mischung = mischung;
	}


	public String getBezeichnung() {
		return bezeichnung;
	}


	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}


	public int getRezeptur_id() {
		return rezeptur_id;
	}


	public void setRezeptur_id(int rezeptur_id) {
		this.rezeptur_id = rezeptur_id;
	}


	public String getBemerkungen() {
		return bemerkungen;
	}


	public void setBemerkungen(String bemerkungen) {
		this.bemerkungen = bemerkungen;
	}


	public int getSorte() {
		return sorte;
	}


	public void setSorte(int sorte) {
		this.sorte = sorte;
	}


	public double getLa() {
		return la;
	}


	public void setLa(double la) {
		this.la = la;
	}


	public double getStaerke() {
		return staerke;
	}


	public void setStaerke(double staerke) {
		this.staerke = staerke;
	}


	public Date getErstellt() {
		return erstellt;
	}


	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}


	public String getErstellt_user() {
		return erstellt_user;
	}


	public void setErstellt_user(String erstellt_user) {
		this.erstellt_user = erstellt_user;
	}


	public Date getGeaendert() {
		return geaendert;
	}


	public void setGeaendert(Date geaendert) {
		this.geaendert = geaendert;
	}


	public String getGeaendert_user() {
		return geaendert_user;
	}


	public void setGeaendert_user(String geaendert_user) {
		this.geaendert_user = geaendert_user;
	}

	public String getErstelltToString() {
		return df.format(erstellt) ;
	}
	
	public String getErstelltToString2() {
		return df.format(erstellt) + " / " + erstellt_user;
	}

	public String getGeaendertToString() {
		return df.format(geaendert);
	}

	public String getGeaendertToString2() {
		return df.format(geaendert) + " / " + geaendert_user;
	}

	public double getLa_minus() {
		return la_minus;
	}


	public void addLa_minus(double la_minus) {
		this.la_minus += la_minus;
	}


	public double getPercentage() {
		return percentage;
	}


	public void setPercentage(double percentage) {
		this.percentage = percentage;
	}


	public double getNegativePercentage() {
		return negativePercentage;
	}


	public void setNegativePercentage(double negative_percentage) {
		this.negativePercentage = negative_percentage;
	}
	
}
