package de.lunqual.rzpro.items.plugins;

import java.util.jar.JarFile;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.PluginInterface;
import de.lunqual.rzpro.log.LogFactory;

public class PluginItem {
	RzPro					rz;
	String 					className;
	PluginInterface 		plugin;
	JarFile					jarFile;

	public PluginItem(RzPro rz,String className) {
		this.rz = rz;
		this.className=className;
		init();
	}

	private void init() {
		  try {
		     plugin = (PluginInterface) Class.forName(className).newInstance();
		     if(plugin != null) {
					rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "Register Plugin" , plugin.getName() );
		     }
		     plugin.init(rz);
		  }
		  catch (final Exception e) {
				rz.getLogFactory().logMessage(LogFactory.LOG_WARN, "PluginItem error" + className + " :", e.getLocalizedMessage());
		  }
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public PluginInterface getPlugin() {
		return plugin;
	}

	public String getName() {
		return plugin.getName();
	}
}
