package de.lunqual.rzpro.items.proben;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;
import 	de.lunqual.rzpro.items.stichworte.StichwortListe;

public class ProbenItem {

	int id;
	int rezeptur;
	String rezeptur_bezeichnung;
	StichwortListe adressen;
	String bezeichnung;
	String losnummer;
	String bemerkungen;
	Date erstellt;
	String user_1;
	boolean deleted=false;
	Date entsorgt=new Date();
	String user_2="";
	

	public ProbenItem(String bezeichnung) {
		this.id=0;
		this.bezeichnung=bezeichnung;
		this.adressen = new StichwortListe();
	}

	public ProbenItem(int id, int rezeptur,
			StichwortListe adressen, String bezeichnung, String rezeptur_bezeichnung,String losnummer,
			String bemerkungen, Date erstellt, String user_1,boolean deleted,Date entsorgt,String user_2) {
		super();
		this.id = id;
		this.rezeptur = rezeptur;
		this.adressen = adressen;
		this.bezeichnung = bezeichnung;
		this.rezeptur_bezeichnung=rezeptur_bezeichnung;
		this.losnummer = losnummer;
		this.bemerkungen = bemerkungen;
		this.erstellt = erstellt;
		this.user_1 = user_1;
		this.user_2 = user_2;
		this.deleted = deleted;
		this.entsorgt = entsorgt;
	}

	public String getErstelltToString(){
		final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
		return df.format(erstellt);
	}

	public String getEntsorgtToString(){
		final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
		return df.format(entsorgt);
	}
	
	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public int getRezeptur() {
		return rezeptur;
	}

	public void setRezeptur(int rezeptur) {
		this.rezeptur = rezeptur;
	}

	public StichwortListe getAdressListe() {
		return adressen;
	}

	public void setAdressListe(StichwortListe adressen) {
		this.adressen = adressen;
	}

	public String getBezeichnung() {
		return bezeichnung;
	}

	public void setBezeichnung(String bezeichnung) {
		this.bezeichnung = bezeichnung;
	}

	public String getLosnummer() {
		return losnummer;
	}

	public void setLosnummer(String losnummer) {
		this.losnummer = losnummer;
	}

	public String getBemerkungen() {
		return bemerkungen;
	}

	public void setBemerkungen(String bemerkungen) {
		this.bemerkungen = bemerkungen;
	}

	public Date getErstellt() {
		return erstellt;
	}

	public void setErstellt(Date erstellt) {
		this.erstellt = erstellt;
	}

	public String getUser_1() {
		return user_1;
	}

	public void setUser_1(String user_1) {
		this.user_1 = user_1;
	}

	public String getRezeptur_bezeichnung() {
		return rezeptur_bezeichnung;
	}

	public void setRezeptur_bezeichnung(String rezeptur_bezeichnung) {
		this.rezeptur_bezeichnung = rezeptur_bezeichnung;
	}

	public boolean isDeleted() {
		return deleted;
	}

	public void setDeleted(boolean deleted) {
		this.deleted = deleted;
	}

	public Date getEntsorgt() {
		return entsorgt;
	}

	public void setEntsorgt(Date entsorgt) {
		this.entsorgt = entsorgt;
	}

	public String getUser_2() {
		return user_2;
	}

	public void setUser_2(String user_2) {
		this.user_2 = user_2;
	}



}
