package de.lunqual.rzpro.items.rechnen;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.options.OptionFactory;

public class RechenChartItem {

	RzPro		rz;
	int			id;
	String		name;
	double		value;

	public RechenChartItem(RzPro rz,int id, String name, double value) {
		this.rz = rz;
		this.id = id;
		this.name = name;
		this.value = value;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public double getValue() {
		return value;
	}
	
	public void setValue(double value) {
		this.value = value;
	}

	public String getString(){
		rz.getOptionFactory();
		return  rz.getLocale().getString("rechenchartitem.format")
				.replaceAll("%n", name)
				.replaceAll("%p", rz.getLocale().formatNumber(value,OptionFactory.NF_NORMAL));
	}
	
}
