package de.lunqual.rzpro.items.rechnen;



import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.currency.CurrencyItem;

public class RechenChartListe extends ArrayList<RechenChartItem> implements Serializable{
	RzPro rz;
	Comparator comp;
	int		rezeptur;
	CurrencyItem c;
	RechenItem	ri;
	int					mode = RzPro.EINHEIT_LITER;
	
	public RechenChartListe(RzPro rz,RechenItem rq) {
		this.rz = rz;
		init();
		this.rezeptur = rq.getRezeptur().getID();
		 ri = new RechenItem(rz,rezeptur,null);
		 ri.setWaehrung(rq.getWaehrung());
		 for(int i =0;i< rq.getZeilenListe().size();i++) {
			 RechenZeile zl = rq.getZeilenListe().getItem(i);
			 if(zl.isRechnen()) {
				 ri.getZeilenListe().getItem(i).setOriginalMenge(zl.getOriginalMenge());
			 }
		 }

	}
	
	public RechenChartListe(RzPro rz,int rezeptur,CurrencyItem cur) {
		this.rz = rz;
		this.rezeptur = rezeptur;
		this.c = cur;
		init();
		 ri = new RechenItem(rz,rezeptur,null);
		 if(cur != null) {
			 ri.setWaehrung(cur);
		 } else {
			 ri.setWaehrung(rz.getDatabase().getCurrency().dbGetCurrency(ri.getRezeptur().getWaehrung(),true));
		 }
	}
	
	private void  init() {
		comp = new Comparator() {
			public int compare(final Object o1, final Object o2) {
				final RechenChartItem b1 = (RechenChartItem) o1;
				final RechenChartItem b2 = (RechenChartItem) o2;
				return b1.getValue() >b2.getValue() ?-1:1;
			}
		};
	}
	
	
	public void rechnen(int mode) {
		this.clear();
		this.mode = mode;
		rechnen_2(mode);
		for (int i = 0;i < ri.getZeilenListe().size();i++) {
    		RechenZeile z =ri.getZeilenListe().getItem(i);
    		if(z.isRechnen()) {
    			switch(mode) {
    				case RzPro.EINHEIT_LITER:
    					this.addItem(new RechenChartItem(rz,z.getRezeptur().getID(),z.getRezeptur().getTitel(),z.getLiter()));
    					break;
    				case RzPro.EINHEIT_LA:
    					this.addItem(new RechenChartItem(rz,z.getRezeptur().getID(),z.getRezeptur().getTitel(),z.getLa()));
    					break;
    				case RzPro.EINHEIT_KG:
    					this.addItem(new RechenChartItem(rz,z.getRezeptur().getID(),z.getRezeptur().getTitel(),z.getKg()));
    					break;
    				case RzPro.EINHEIT_KOSTEN:
    				case RzPro.EINHEIT_KOSTEN_STEUER:
    					this.addItem(new RechenChartItem(rz,z.getRezeptur().getID(),z.getRezeptur().getTitel(),z.getKalkulationBetrag().doubleValue()));
    					break;
    			}
    		}
    	}
		if(mode == RzPro.EINHEIT_LITER) {
			this.addItem(new RechenChartItem(rz,0,rz.getLocale().getString("rezepturcontent.verschnittwasser"),ri.getWasserP()));
		}
		if(mode == RzPro.EINHEIT_KG) {
			this.addItem(new RechenChartItem(rz,0,rz.getLocale().getString("rezepturcontent.verschnittwasser"),ri.getWasserP() * rz.getTafelFactory().Litergewicht(0)));
		}
		if(mode == RzPro.EINHEIT_KOSTEN) {
			this.addItem(new RechenChartItem(rz,0,rz.getLocale().getString("rezepturcontent.verschnittwasser"),ri.getVerschnittwasserPreis().doubleValue()));
		}
		if(mode == RzPro.EINHEIT_KOSTEN_STEUER) {
			this.addItem(new RechenChartItem(rz,0,rz.getLocale().getString("rezepturcontent.steuer"),ri.getSteuer().doubleValue()));
			this.addItem(new RechenChartItem(rz,-1,rz.getLocale().getString("rezepturcontent.verschnittwasser"),ri.getVerschnittwasserPreis().doubleValue()));
		}
	}
	
	private void rechnen_2(int mode) {
		double liter = 100;
		ri.rechnen(liter, RzPro.EINHEIT_LITER);
		if(mode == RzPro.EINHEIT_KOSTEN) {
			double preis = ri.getSummeOhneSteuer().doubleValue();
			if(preis != 0) {
				liter = 10000/preis;
				ri.rechnen(liter, RzPro.EINHEIT_LITER);
			}
		} else if (mode == RzPro.EINHEIT_KOSTEN_STEUER){
			double preis = ri.getSummeMitSteuer().doubleValue();
			if(preis != 0) {
				liter = 10000/preis;
				ri.rechnen(liter, RzPro.EINHEIT_LITER);
			}
		} else {
			ri.rechnen(100, mode);
		}
	}
	
	public void addItem(RechenChartItem rci) {
		if(!rz.isZero(rci.getValue())){
			boolean added = false;
			for(RechenChartItem r:this) {
				if(r.getId() == rci.getId()) {
					r.setValue(r.getValue() + rci.getValue());
					added = true;
				}
			}
			if(!added) {
				this.add(rci);
			}
			sort();
		}
	}
	
	
	private void sort() {
		Collections.sort(this, comp);
		//Collections.reverse(this);
	}

	public CurrencyItem getCurrency() {
		return c;
	}
	
	public boolean isPreisWarnung() {
		return ri.isPreisWarnung();
	}
	public boolean isWasserPreisWarnung() {
		return rz.isZero(ri.verschnittwasserPreis.doubleValue())?true:false;
	}
	public String getName() {
		return ri.getRezeptur().getTitel();
	}
	
	public int getMode() {
		return mode;
	}
	
	public boolean isAlkoholfrei() {
		return rz.isZero(ri.getStaerke())?true:false;
	}
	public String getModeString() {
		String ret = "";
		switch (mode) {
			case RzPro.EINHEIT_LITER: ret = rz.getLocale().getString("string_liter");break;
			case RzPro.EINHEIT_LA: ret = rz.getLocale().getString("string_la");break;
			case RzPro.EINHEIT_KG: ret = rz.getLocale().getString("string_kg");break;
			case RzPro.EINHEIT_KOSTEN: ret = rz.getLocale().getString("string_kosten").replaceAll("%w", ri.getWaehrung().getName());break;
		}
		return ret;
	}

}


