/*
 * Created on 18.08.2004
 *
 */
package de.lunqual.rzpro.items.rechnen;
import java.io.Serializable;
import java.util.ArrayList;

import de.lunqual.rzpro.RzPro;
import de.lunqual.rzpro.items.currency.CurrencyItem;


/**
 * @author labor
 *

 */
public class RechenZeilenListe extends ArrayList implements Serializable{

    RzPro				rz;
    int					zeilennummer;
    /**
     *
     */
    public RechenZeilenListe(RzPro r) {
        super();
        this.rz = r;
        zeilennummer =0;
    }
   
    public RechenZeile getItem(int i) {
        return (RechenZeile)this.get(i);
    }

    public void addItem(String aZeile) {
        if(!aZeile.equals("")) {
            this.add( new RechenZeile(rz,aZeile,zeilennummer));
            zeilennummer++;
        }
    }


    /**
     * gibt true zurück, wenn mehr als eine Sternzeile vorhanden ist
     */
    public boolean isSternzeileError() {
    	int count =0;
        for(int i =0;i < this.size();i++) {
            if(this.getItem(i).isStern()){
            	count ++;
            }
        }
    	return count >1?true:false;
    }
    
    /** gibt die Nummer der Zeile mit dem Stern zurück
     *
     * @return sternzeilen-nummer
     */
    public int getSternZeile() {
        for(int i =0;i < this.size();i++) {
            if(this.getItem(i).isStern()){
                return i;
            }
        }
        return -1;
    }
    /**
     * prüft, ob überhaupt eine Berechnung in der Liste enthalten ist
     * @return true, wenn ja, false wenn nicht
     */
    public boolean isBerechnung() {
        for(int i =0;i < this.size();i++) {
            if(this.getItem(i).isRechnen()){
                return true;
            }
        }
        return false;
    }

    public void setWaehrung(int id) {
        final CurrencyItem waehrung = rz.getDatabase().getCurrency().dbGetCurrency(id,true);
        for(int i = 0;i < this.size();i++) {
            if((this.getItem(i)).isRechnen()) {
                (this.getItem(i)).setWaehrung(waehrung);
            }
        }
    }

}
