/*
 *  Copyright (C) 2004 Karlheinz Klingbeil (lunqual)
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
package de.lunqual.rzpro.items.report;
import java.text.SimpleDateFormat;
import java.util.Date;

import de.lunqual.rzpro.RzPro;

/**
 *
 * @author  lunqual
 */
public class ReportItem {

    RzPro       rz;
    int         id;
    int         typ;
    int         system;
    String      name;
    String      formular;
    Date        erstellt;
    Date        geaendert;
    String      user_1;
    String      user_2;

    /** Creates a new instance of ReportItem */
    public ReportItem(RzPro r,int aID,int aTyp,int aSystem,Date aErstellt,Date aGeaendert,String aUser_1,String aUser_2,String aName,String aFormular) {
        rz = r;
        id = aID;
        typ = aTyp;
        system = aSystem;
        erstellt = aErstellt;
        geaendert = aGeaendert;
        user_1 = aUser_1;
        user_2 = aUser_2;
        name = aName;
        formular = aFormular;
    }

    public int getID(){return id;}
    public int getTyp(){return typ;}

    public int getSystem(){return system;}
    public String getName(){return name;}
    public Date getErstellt(){return erstellt;}
    public Date getGeaendert(){return geaendert;}
    public String getUser1(){return user_1;}
    public String getUser2(){return user_2;}
    public String getFormular(){return formular;}
    @Override
	public String toString(){
        return  name;
    }

    public void setID(int aID){id=aID;}
    public void setTyp(int aTyp){typ = aTyp;}
    public void setName(String aName){name = aName;}
    public void setErstellt(Date aErstellt){erstellt = aErstellt;}
    public void setGeandert(Date aGeaendert){geaendert = aGeaendert;}
    public void setUser1(String aUser){user_1 = aUser;}
    public void setUser2(String aUser){user_2 = aUser;}
    public void setFormular(String aFormular){formular = aFormular;}

    public String getErstelltToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(erstellt);
    }
    public String getGeaendertToString(){
        final SimpleDateFormat df = new SimpleDateFormat(RzPro.DATEFORMAT);
        return df.format(geaendert);
    }
}
